theory question_66_1
imports Main
begin

typedecl entity
typedecl event

consts
  Sun :: "entity ⇒ bool"
  Star :: "entity ⇒ bool"
  Stars :: "entity ⇒ bool"
  Hottest :: "entity ⇒ entity ⇒ entity ⇒ entity ⇒ bool"
  Object :: "entity ⇒ entity ⇒ bool"
  Earth :: "entity ⇒ bool"
  Mars :: "entity ⇒ bool"
  Moon :: "entity ⇒ bool"

(* Explanation 1: The Sun is a kind of star. *)
axiomatization where
  explanation_1: "∀x. Sun x ⟶ Star x"

(* Explanation 2: Stars are some of the hottest objects. *)
axiomatization where
  explanation_2: "∀x. Stars x ⟶ (∃e. Hottest e x x x ∧ Object e x)"

(* Explanation 3: The Sun is the hottest among stars. *)
axiomatization where
  explanation_3: "∀x y. Sun x ∧ Stars y ⟶ Hottest x y y y"

theorem hypothesis:
  assumes asm: "Sun x ∧ Earth y ∧ Mars z ∧ Moon w"
  (* Hypothesis: The Sun is the hottest among the Earth, Mars, and the Moon. *)
  shows "Hottest x y z w"
proof -
  from asm have "Sun x" by simp
  then have "Star x" using explanation_1 by blast
  then obtain e where e: "Hottest e x x x ∧ Object e x" using explanation_2 by blast
  from asm have "Earth y" by simp
  from asm have "Mars z" by simp
  from asm have "Moon w" by simp
  then have "Stars x" using e explanation_3 by blast
  then have "Hottest x y y y" using explanation_3 by blast
  then show ?thesis using `Hottest x y y y` by blast
qed

end
