theory question_66_0

imports Main

begin

typedecl entity
typedecl event

consts
  Sun :: "entity ⇒ bool"
  Star :: "entity ⇒ bool"
  Stars :: "entity ⇒ bool"
  HottestObjects :: "entity ⇒ bool"
  Earth :: "entity ⇒ bool"
  Mars :: "entity ⇒ bool"
  Moon :: "entity ⇒ bool"

(* Explanation 1: The Sun is a kind of star. *)
axiomatization where
  explanation_1: "∀x. Sun x ⟶ Star x"

(* Explanation 2: Stars are some of the hottest objects. *)
axiomatization where
  explanation_2: "∀x. Stars x ⟶ HottestObjects x"

theorem hypothesis:
  assumes asm: "Sun x ∧ Earth y ∧ Mars z ∧ Moon w"
  (* Hypothesis: The Sun is the hottest among the Earth, Mars, and the Moon. *)
  shows "∃x y z w. Sun x ∧ Earth y ∧ Mars z ∧ Moon w ∧ HottestObjects x ∧ HottestObjects y ∧ HottestObjects z ∧ HottestObjects w"
proof -
  from asm have "Sun x" by simp
  then have "Star x" using explanation_1 by blast
  then have "HottestObjects x" using explanation_2 by blast
  then obtain y z w where "Earth y ∧ Mars z ∧ Moon w" by blast
  then have "HottestObjects y ∧ HottestObjects z ∧ HottestObjects w" using `HottestObjects x` by blast
  thus ?thesis using asm by blast
qed

end
