theory question_67_4

imports Main

begin
typedecl entity
typedecl event

consts
  Older :: "entity ⇒ bool"
  Male :: "entity ⇒ bool"
  Sitting :: "event ⇒ bool"
  Together :: "entity ⇒ entity ⇒ bool"
  On :: "entity ⇒ event ⇒ bool"
  Boat :: "event ⇒ bool"
  RiverBoatTour :: "event ⇒ bool"

(* Explanation 1: If two older males are sitting together, they are likely on the same boat. *)
axiomatization where
  explanation_1: "∀x y e. Older x ∧ Male x ∧ Older y ∧ Male y ∧ Sitting e ∧ Together x y ⟶ On x e ∧ On y e"

(* Explanation 2: If two individuals are on the same boat, they are likely sitting together. *)
axiomatization where
  explanation_2: "∀x y e. On x e ∧ On y e ∧ Boat e ⟶ Sitting e ∧ Together x y"

theorem hypothesis:
  (* Premise: Two older males sitting together on a river boat tour. *)
  assumes asm: "Older x ∧ Male x ∧ Older y ∧ Male y ∧ RiverBoatTour e ∧ Sitting e ∧ Together x y"
  (* Hypothesis: Two males sitting together on a boat. *)
  shows "∃x y e. Male x ∧ Male y ∧ Boat e ∧ Sitting e ∧ Together x y ∧ On x e ∧ On y e"
proof -
  from asm have "Older x ∧ Male x ∧ Older y ∧ Male y ∧ Sitting e ∧ Together x y" by blast
  then have "On x e ∧ On y e" using explanation_1 by blast
  then have "Sitting e ∧ Together x y" using explanation_2 by blast
  then show ?thesis using asm by blast
qed

end
