##This is the reproduction package for our paper submission: "Go Back in Time: Control Event Temporal Order in Story Generation"

### 0. Preliminary
- We list the packages in our environment in `env.yml` for your reference.
- All links below are anonymous.
- All data used for experiments can be download here: `https://drive.google.com/drive/folders/1h0T2W5pj5gCNoTJuZt9LwFbMXqnv4dfc?usp=sharing`
- Save them in `./data`
- The pretrained storyline model can be downloaded here: `https://drive.google.com/drive/folders/1ZmvZKgwdK8MQj99pgZN7Y_mP2UA29Ap7?usp=sharing`
- Save it in `./output/pretrained`


### 1. Replicate ROCStories Experiments
#### 1.1 Training
##### Vanilla end-to-end
- simply run `bash ./code/run_story_generation_pipeline.sh`
- by setting the `suffix` variable to `gen_with_no_struct_input_pipeline_story_input`

##### + structured control
- simply run `bash ./code/run_story_generation_pipeline.sh`
- by setting the `suffix` variable to `gen_with_rel_output_pipeline_story_input`

##### + pretrained
- simply run `bash ./code/run_story_generation_pipeline.sh`
- by setting the `suffix` variable to `gen_with_rel_output_pipeline_pretrain_story_input`
- and use `--load_model ${load_model_dir}` in the bash script.

##### + RL
- simply run `bash ./code/run_story_generation_pipeline_rl.sh`

##### Two-stage
- run `bash ./code/run_seq_generation.sh`, which will output a storyline model in `./output/storyline_model/`
- run `bash ./code/run_story_generation.sh`, which will output a story model in `./output/story_model/`

#### 1.2 Evaluation
- For end-to-end models, simply run `bash ./code/eval_story_generation_pipeline.sh` by setting `suffix` associated with above models
- For two-stage: 1) run `bash ./code/eval_seq_generation.sh`, which outputs a storyline prediction file `test_storyline_pred.json`; 
- For two-stage: 2) run `bash ./code/eval_story_generation.sh,` which take `test_storyline_pred.json` as input.



### 2. Replicate Writing Prompts Experiments

#### 2.1 Training
##### Vanilla end-to-end
- simply run `bash ./code/run_story_generation_pipeline_wp.sh`
- by setting the `suffix` variable to `suffix="gen_with_no_struct_story_input_wp`

##### + structured control
- simply run `bash ./code/run_story_generation_pipeline_wp.sh`
- by setting the `suffix` variable to `suffix="gen_with_rel_pipeline_story_input_wp`

##### + RL
- simply run `bash ./code/run_story_generation_pipeline_wp_rl.sh`


#### 2.2 Evaluation
- For end-to-end models, simply run `bash ./code/eval_story_generation_pipeline_wp.sh` by setting `suffix` associated with above models.
- We skip two-stage models here as they do not work as well and will drastically increase the complexity of this repo.
- We can share all details upon paper acceptance.



