function v = matrixlincomb(x, a1, d1, a2, d2) %#ok<INUSL>
% Linear combination function for tangent vectors represented as matrices.
%
% function v = lincomb(x, a1, d1)
% function v = lincomb(x, a1, d1, a2, d2)
%
% Given a point x, two tangent vectors d1 and d2 at x, and two real
% coefficients a1 and a2, returns a tangent vector at x representing
% a1*d1 + a2*d2, if d1 and d2 are represented as matrices (or more
% generally as arrays in Matlab).
%
% If a2 and d2 are omitted, the returned tangent vector is a1*d1.
%
% The input x is actually unused.
%
% This function is a helper to define manifolds in Manopt.

% This file is part of Manopt: www.manopt.org.
% Original author: Nicolas Boumal, July 2, 2015.
% Contributors: 
% Change log: 

    if nargin == 3
        v = a1*d1;
    elseif nargin == 5
        v = a1*d1 + a2*d2;
    else
        error('matrixlincomb takes either 3 or 5 inputs.');
    end
    
end
