/*
 * Decompiled with CFR 0.152.
 */
package fig.record;

import fig.basic.MapUtils;
import fig.basic.Utils;
import fig.record.LoadFileState;
import fig.record.RecordNode;
import java.util.HashMap;
import java.util.Map;

public class GlobalEnv {
    private Map<String, String> varMap;
    private RecordNode rootRecord;
    private LoadFileState loadFileState;
    private int maxResultNodes = Integer.MAX_VALUE;
    private int verboseLevel = 1;
    private int maxLoadSize = 100000;
    private boolean cleanupMandate = true;

    public GlobalEnv(RecordNode rootRecord) {
        this.varMap = new HashMap<String, String>();
        this.loadFileState = new LoadFileState(this);
        this.rootRecord = rootRecord;
    }

    public RecordNode getRootRecord() {
        return this.rootRecord;
    }

    public String getVar(String key) {
        return this.varMap.get(key);
    }

    public String getVar(String key, String defaultValue) {
        return MapUtils.get(this.varMap, key, defaultValue);
    }

    public int getVarInt(String key, int defaultValue) {
        return Utils.parseIntEasy(this.varMap.get(key), defaultValue);
    }

    public boolean getVarBoolean(String key, boolean defaultValue) {
        return Utils.parseBooleanEasy(this.varMap.get(key), defaultValue);
    }

    public void putVar(String key, String value) {
        GlobalEnv.putMap(this.varMap, key, value);
        this.setFromVars();
    }

    private static void putMap(Map<String, String> map, String key, String value) {
        if (value == null) {
            map.remove(key);
        } else {
            map.put(key, value);
        }
    }

    public void setFromVars() {
        this.maxResultNodes = this.getVarInt("maxResultNodes", this.maxResultNodes);
        this.verboseLevel = this.getVarInt("verbose", this.verboseLevel);
        this.cleanupMandate = this.getVarBoolean("cleanup", this.cleanupMandate);
        this.maxLoadSize = this.getVarInt("maxLoadSize", this.maxLoadSize);
    }

    public int getMaxResultNodes() {
        return this.maxResultNodes;
    }

    public boolean verbose(int level) {
        return level <= this.verboseLevel;
    }

    public boolean getCleanupMandate() {
        return this.cleanupMandate;
    }

    public int getMaxLoadSize() {
        return this.maxLoadSize;
    }

    public LoadFileState getLoadFileState() {
        return this.loadFileState;
    }
}

