/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.BitSet;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;

public class CachingWrapperFilter
extends Filter {
    protected Filter filter;
    protected transient Map cache;

    public CachingWrapperFilter(Filter filter) {
        this.filter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BitSet bits(IndexReader reader) throws IOException {
        if (this.cache == null) {
            this.cache = new WeakHashMap();
        }
        Map map = this.cache;
        synchronized (map) {
            BitSet cached = (BitSet)this.cache.get(reader);
            if (cached != null) {
                return cached;
            }
        }
        BitSet bits = this.filter.bits(reader);
        Map map2 = this.cache;
        synchronized (map2) {
            this.cache.put(reader, bits);
        }
        return bits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        if (this.cache == null) {
            this.cache = new WeakHashMap();
        }
        Map map = this.cache;
        synchronized (map) {
            DocIdSet cached = (DocIdSet)this.cache.get(reader);
            if (cached != null) {
                return cached;
            }
        }
        DocIdSet docIdSet = this.filter.getDocIdSet(reader);
        Map map2 = this.cache;
        synchronized (map2) {
            this.cache.put(reader, docIdSet);
        }
        return docIdSet;
    }

    public String toString() {
        return "CachingWrapperFilter(" + this.filter + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof CachingWrapperFilter)) {
            return false;
        }
        return this.filter.equals(((CachingWrapperFilter)o).filter);
    }

    public int hashCode() {
        return this.filter.hashCode() ^ 0x1117BF25;
    }
}

