###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################
#!/usr/bin/env ruby
############################################
# trees2latex.rb
#
# Turns trees into latex code for easy pasting into
# a latex document
#
###########################################

num_parens = 0
num_brackets = 0
matches = Array.new
tree_type = "lingtree"
term_type = "mysquishterm"
indent = 0

while(line = gets)
  line = line.chomp
  num_parens = line.length - line.gsub(/\(/,'').length
  num_brackets = line.length - line.gsub(/\[/,'').length
  if num_parens > num_brackets
    left_sym = "("
    right_sym = ")"
    re_start = Regexp.new("^\\( *([^ ]+) +")
    re_end   = Regexp.new("^([^ \\)]* *)\\) *")
  else
    left_sym = "["
    right_sym = "]"
    re_start = Regexp.new("^\\[([^ ]+) +")
    re_end   = Regexp.new("^([^ \\]]*)\\] *")
  end
  while line != ""
    if re_start.match(line)
      line = line.sub(re_start, '')
      term = $1.sub(/([_$])/,'\\\\\1')
      indent.times do |i|
        print " "
      end
      puts "\\#{tree_type}{\\#{term_type}{#{term}}}{"
      indent += 2
    elsif re_end.match(line)
      line = line.sub(re_end, '')
      if $1 == ""
        # Then we matched just a close bracket
        indent.times do |i| 
          print " "
        end
        puts "}"
        indent -= 2
      else
        # We matched a word and a closed bracket
        indent.times do |i| 
          print " "
        end
        term = $1.sub(/([_$])/,'\\\\\1')
        puts "\\#{term_type}{#{term}}}"
        indent -= 2
      end
    else
      puts "Else block found with line = ccc#{line}ccc"
      break
    end
  end
end

