###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################


# cat wsj_0001.trees | perl scripts/treesed.pl
use Getopt::Std;

getopts("pd");

$remove_punct = 0;
if($opt_p){
  $remove_punct = 1; 
}

$DEBUG = 0;
if ($opt_d) {
  $DEBUG = 1;
}

sub debug {
	if ($DEBUG) {
		$msg = $_[1];
		print stderr $_[0] , " " , $msg, "\n";
	}
}

## for each tree...
$lineNum=1;

#open FH, $ARGV[0];
#while ( <FH> ) {
while ( <> ) {
  # for srl only. Try not to use S in the label
  s/ARGMRELDAZDIS/ARGMRELDAZDIZ/g;

  debug("******line ", $lineNum++);
  
  ## Make parentheses look standard...
  s/\( */(/g;
  s/ *\)/)/g;

  ## Remove repair annotation
  s/\(RM \(\-DFL\- \\\[\) \)//g;
  s/\(IP \(\-DFL\- \\\+\) \)//g;
  s/\(-DFL- E_S\)//g;
  s/\(-DFL- N_S\)//g;
  s/\(RS \(\-DFL\- \\\]\) \)//g;
  ## Sometimes that creates empty categories (especially in mis-annotated data)
  ## Remove those empty categories
  s/\([^ ]+[ ]+\)//;
  
  ## Collapse out everything between cat. and UNF
  s/\(([^ ]+)-[^ ]+-UNF/(\1-UNF/g;
  s/-UNF/UNF/g;
  # We wil undo this shift later, but for right now it's done so INTJ is not 
  # confused with IN (I think 4 underscores should be enough)
  s/INTJ/____INTJ/g;
  
  ## translate to parens...
  s/\[/\(/g;
  s/\]/\)/g;

  if($remove_punct == 1){
      # Remove/change punctuation...
      s/\([^ ]+ \.\.\.\)//g;
      s/\([^ ]+ \.\)//g;
      s/\([^ ]+ \!\)//g;
      s/\([^ ]+ \?\)//g;
      s/\([^ ]+ \,\)//g;
      s/\([^ ]+ *\([^ ]+ *\-\-\) *\)//g;  ## dash is nested... don't know why
      s/\([^ ]+ \-\-\)//g;
      s/\([^ ]+ \-\)//g;
      s/\([^ ]+ \;\)//g;
      s/\([^ ]+ \:\)//g;
      s/\([^ ]+ \`\)//g;
      s/\([^ ]+ \'\)//g;
      s/\([^ ]+ \`\`\)//g;
      s/\([^ ]+ \'\'\)//g;
      s/\([^ ]+ -L.B-\)//g;
      s/\([^ ]+ -R.B-\)//g;
  }


  # Get rid of typos (categories starting with ^)
  s/\(\^/\(/g;

  # Distinguish punctuation...
  s/\(([\w]+\!ldelim\!)?[^ ]+ \.\.\.(:[^\)]*)?\)/\(\1\, \.\.\.\2\)/g;
  s/\(([\w]+\!ldelim\!)?[^ ]+ \?(:[^\)]*)?\)/\(\1\? \?\2\)/g;
  s/\([^ ]+ *\(([\w]+\!ldelim\!)?[^ ]+ *\-\-(:[^\)]*)?\) *\)/\(\1\, \-\-\2\)/g;  ## dash is nested... don't know why

  s/\(([\w]+\!ldelim\!)?[^ ]+ \-\-(:[^\)]*)?\)/\(\1\, \-\-\2\)/g;
  s/\(([\w]+\!ldelim\!)?[^ ]+ \-(:[^\)]*)?\)/\(\1\, \-\-\2\)/g;
  s/\(([\w]+\!ldelim\!)?[^ ]+ \:(:[^\)]*)?\)/\(\1\, \:\2\)/g;
  s/\(([\w]+\!ldelim\!)?[^ ]+ \;(:[^\)]*)?\)/\(\1\, \;\2\)/g;
  s/\(([\w]+\!ldelim\!)?[^ ]+ \`(:[^\)]*)?\)/\(\1\` \`\2\)/g;
  s/\(([\w]+\!ldelim\!)?[^ ]+ \'(:[^\)]*)?\)/\(\1\' \'\2\)/g;


  ########## GLOBAL SYMBOL SHIFT
  #s/\!/\!exclamation\!/g;
  s/\~/\!tilde\!/g;
  #s/\`\`/\!openquote\!/g;
  #s/\`/\!openscare\!/g;
  s/\@/\!at\!/g;
  s/\#/\!pound\!/g;
  #s/\$/\!dollar\!/g;
  #s/\%/\!percent\!/g;
  #s/\^/\!carat\!/g;
  s/\&/\!ampersand\!/g;
  #s/\*/\!star\!/g;
  s/--/\!dash\!/g;
  s/\+/\!plus\!/g;
  #s/\=/\!equals\!/g;
  s/:/\!colon\!/g;
  s/;/\!semi\!/g;
  #s/\"/\!dblquote\!/g;
  #s/\'\'/\!closequote\!/g;
  #s/\'/\!closescare\!/g;
  #s/\./\!period\!/g;
  #s/\,/\!comma\!/g;
  s/([^\*])\?/\1\!question\!/g;
  s/\//\!slash\!/g;
  ##########

  # substitute -LRB- to \!LRB\!
  s/-LRB-/\!LRB\!/g;
  # substitute -RRB- to \!RRB\!
  s/-RRB-/\!RRB\!/g;
  # substitute -NONE- to \!NONE\!
  s/-NONE-/\!NONE\!/g;
  # substitute *T* to \!t\! ("word" trace will get lowercased anyway)
  s/\*T\*/\!t\!/g;
  # substitute *RNR* to \!rnr\! ("word" trace will get lowercased anyway)
  s/\*RNR\*/\!rnr\!/g;
  # substitute NP-TMP to NP-tmp
  s/NP[^ ]*\-TMP/NP-tmp/g;
  # substitute S*-ADV to S*-adv
  s/(S[^ ]*)\-ADV/\1-adv/g;
  # remove all other dash specifications beginning with capital letter
  s/\-[A-Z][A-Z]*([^ \)\]]*) /\1 /g;
  s/\-[A-Z][A-Z]*([^ \)\]]*) /\1 /g;
  s/\-[A-Z][A-Z]*([^ \)\]]*) /\1 /g;

$step = 0;

  ## for each constituent...
  while ( $_ =~ /\([^\(\)]*\)/ ) {

	if ($step == 101) {
#		$DEBUG = 1;
	}
	
    ## convert outer parens to braces...
    $_ =~ s/\(([^\(\)]*)\)/{\1}/;

    #################### ADD SED RULES HERE: apply rules to angles (children) within braces (consituent)...
    debug($step++, "   $_");

    #### EOS PUNCT
    # isolate period quote after S
    s/{([^ ]*) +(.*<.*<.*) +<([\w]+\!ldelim\!)?(\. [^>]*)> +<([\w]+\!ldelim\!)?('' [^>]*)> *}/\(\1 \(\1-qr \{\1-qr-pr \2\} <\3\4>\) <\5\6>\)/;
    # isolate period after S
    #s/{([^ ]*) +(.*<.*<.*) +<(\. [^>]*)> *}/\(\1 \{\1-pr \2\} <\3>\)/;
    s/{([^ ]*) +(.*<.*<.*) *<([\w]+\!ldelim\!)?(\. [^>]*)> *}/\(\1 \{\1-pr \2\} <\3\4>\)/;
#    # grab punct after S
#    s/{([^ ]*) +(.*)<(S[^ ]*) ([^>]*)> *<(, [^>]*)>(.*)}/\(\1 \2\{\3 <\3 \4> <\5>\}\6\)/;
    # grab quotes around single category
#    s/{([^ ]*) +(.*)<(``) ([^>]*)> *<([^ ]*) ([^>]*)> *<('') ([^>]*)>(.*)}/\(\1 \2\{\5 <\3 \4> <\5 \6> <\7 \8>\}\9\)/;
#    s/{([^ ]*) +(.*)<([\w]+\!ldelim\!)?(``) ([^>]*)> *<([\w]+\!ldelim\!)?([^ ]*) ([^>]*)> *<([\w]+\!ldelim\!)?('') ([^>]*)>(.*)}/\(\1 \2\{\6\7 <\3\4 \5> <\6\7 \8> <\9$10 $11>\}$12\)/;
    
    # grab quotes around single category with comma
#    s/{([^ ]*) +(.*)<(`` [^>]*)> *<([^ ]*) ([^>]*)> *<(, [^>]*)> *<('' [^>]*)>(.*)}/\(\1 \2\{\4 <\3> <\4 \5> <\6> <\7>\}\8\)/;
#    s/{([^ ]*) +(.*)<([\w]+\!ldelim\!)?(`` [^>]*)> *<([^ ]*) ([^>]*)> *<([\w]+\!ldelim\!)?(, [^>]*)> *<([\w]+\!ldelim\!)?('' [^>]*)>(.*)}/\(\1 \2\{\5 <\3\4> <\5 \6> <\7\8> <\9$10>\}$11\)/;
    
    # grab quotes at edges of multiple categories
#    s/{([^ ]*) +( *)<([\w]+\!ldelim\!)?(``) ([^>]*)> *(.*>.*<.*) *<([\w]+\!ldelim\!)?('') ([^>]*)>( *)}/\(\1 <\3\4 \5> \{\1 \6\} <\7\8 \9>\)/;
    
    
    
    
    # grab paren/brack around single category
#    s/{([^ ]*) +(.*)<([\w]+\!ldelim\!)?(-L.B-) ([^>]*)> *<([^ ]*) ([^>]*)> *<([\w]+\!ldelim\!)?(-R.B-) ([^>]*)>(.*)}/\(\1 \2\{\6 <\3\4 \5> <\6 \7> <\8\9 $10>\}$11\)/;
    # grab paren/brack at edges of multiple categories
#    s/{([^ ]*) +( *)<([\w]+\!ldelim\!)?(-L.B-) ([^>]*)> *(.*>.*<.*) *<([\w]+\!ldelim\!)?(-R.B-) ([^>]*)>( *)}/\(\1 <\3\4 \5> \{\1 \6\} <\7\8 \9>\)/;


    #### TIME NPS
    # substitute NP-tmp
    #s/{NP-[^ ]*tmp[^ \-\=]*[^ ]* (.*)}/\(PP-tmp \{NP \1\}\)/g;
    if ( $_ =~ /[\w]+\!ldelim\!/ ) { #srl tree input
    	s/{([\w]+\!ldelim\!)NP-[^ ]*tmp[^ \-\=]*[^ ]* (.*)}/\(\1PP-tmp \{ID\!ldelim\!NP \2\}\)/g; 
    } else { #non-srl tree input
    	s/{NP-[^ ]*tmp[^ \-\=]*[^ ]* (.*)}/\(PP-tmp \{NP \1\}\)/g;
    }
    
    #move the srl label from NP-tmp up to PP-tmp and reset ID label for NP-tmp
#    # remove all other dash specifications beginning with capital letter or number, not ending in dash
#    s/{([^ \-\=]*)[\-\=][\-\=A-Z0-9]*[^\-] /{\1 /g;



    #### EMPTY CATEGORIES
    # delete ICH (moved -- not just raised -- modifier) and U (transposed currency symbol) traces; too hard to reconstruct
    s/{([\w]+\!ldelim\!)?\!NONE\! .*ICH.*}//;
    s/{([\w]+\!ldelim\!)?\!NONE\! *\*U\*(!colon!.*)? *}//;
    # eliminate expletive it cleft (a shame, but sent is too deeply attached)
    s/{([\w]+\!ldelim\!)?NP[^ ]* +<([\w]+\!ldelim\!)?(NP[^>]*)> +<([\w]+\!ldelim\!)?S[^ ]*-empty 0> *}/{\2\3}/;
    # delete unary projections of deleted empty constituents
    s/{[^ ]* *}//;
    # fold empty category for currency into nonterm
    s/{([\w]+\!ldelim\!)?QP([^ ]*) +(.*<)([\w]+\!ldelim\!)?(\!pound\!.*)}/{\4NP-currunit\2 \3\4\5}/; #use the label of the !pound!
#    s/{([\w]+\!ldelim\!)?QP([^ ]*) +(.*<)([\w]+\!ldelim\!)?(\$.*)}/{\4NP-currunit\2 \3\4\5}/;
	if ( $_ =~ /{([\w]+\!ldelim\!)?QP([^ ]*) +(.*<)([\w]+\!ldelim\!)?(\$.*)}/ ) {
		if ($3 =~ /REL\!ldelim\!/ ) {
			s/{([\w]+\!ldelim\!)?QP([^ ]*) +(.*<)([\w]+\!ldelim\!)?(\$.*)}/{\1NP-currunit\2 \3\4\5}/;
		} else {
			s/{([\w]+\!ldelim\!)?QP([^ ]*) +(.*<)([\w]+\!ldelim\!)?(\$.*)}/{\4NP-currunit\2 \3\4\5}/;
		}
	}
    
    s/{([\w]+\!ldelim\!)?QP([^ ]*) +(.*<)([\w]+\!ldelim\!)?(\%.*)}/{\4NP-currunit\2 \3\4\5}/;
    s/{([\w]+\!ldelim\!)?(NP[^ ]*|ADJP[^ ]*) (.*)<([\w]+\!ldelim\!)?NP-currunit[^ ]* ([^>]*)> *<([\w]+\!ldelim\!)?\!NONE\! [^>]*>([^}]*)}/{\1\2 \3 \5\7}/;   ## probably redundant now with *U* removed
    # fold empty X categories into X-empty nonterm
    s/{([^ ]*) +<([\w]+\!ldelim\!)?\!NONE\! +\!t\!\-([0-9]+)(\!colon\!.*)?> *}/{\1-empty-\3 0}/;
    s/{([^ ]*) +<([\w]+\!ldelim\!)?\!NONE\! +\!rnr\!\-([0-9]+)(\!colon\!.*)?> *}/{\1-empty-\3 0}/;
    s/{([^ ]*) +<([\w]+\!ldelim\!)?\!NONE\! +\*(\!colon\!.*)?> *}/{\1-empty-ctrl 0}/;
    s/{([^ ]*) +<([\w]+\!ldelim\!)?\!NONE\! +[^>]*> *}/{\1-empty 0}/;
#    # rename VP with TO to infinitive VP-inf nonterm
#    s/{VP +(<TO[^>]*> *<VP[^>]*>[^ ]*)}/{VPto-inf \1}/;
#    # fold NP trace in S trace into infinitive VP-inf nonterm
#    s/{S +<NP-empty 0> *<VPto ([^>]*)> *}/{VPto \1}/;
    # fold NP trace in VP into passive VP nonterm
	s/{([\w]+\!ldelim\!)?(VP[^ ]*|VBN[^ ]*|VBD[^ ]*) +(.*)<([\w]+\!ldelim\!)?(VBN[^ ]*|VBD[^ ]*) +([^>]*)> *<([\w]+\!ldelim\!)?NP[^ ]*-empty(-ctrl)? 0>(.*)}/{\1\2 \3<\4\5-psv-argNP \6> \9}/;
    # fold empty NP in S with VPvb|VPvbp into S imperative
    s/{([\w]+\!ldelim\!)?(S[^ ]*|PRN[^ ]*) +(.*)<[^ ]*NP[^ ]*-empty-ctrl 0> *<([\w]+\!ldelim\!)?(VPvbp|VPvb)([^a-z][^>]*)>(.*)}/{\1\2 \3<\1Simp\6>\7}/; #use the parent srl label for Simp for now
    # fold empty NP in S with VPvbg into S pro progressive / passive / infinitive
#    s/{([\w]+\!ldelim\!)?(S[^ ]*) +(.*)<[^ ]*NP[^ ]*-empty(-ctrl)? 0> *<([\w]+\!ldelim\!)?VP(vbg|vbd|vbn|vb|to)([^>]*)>(.*)}/{\1\2 \3<\5Spro\6\7>\8}/; #use label from the VP node for Spro
#    s/{([\w]+\!ldelim\!)?(S[^ ]*) +(.*)<[^ ]*NP[^ ]*-empty(-ctrl)? 0> *<([\w]+\!ldelim\!)?VP(vbg|vbd|vbn|vb|to)([^>]*)>(.*)}/{\1\2 \3<\1Spro\6\7>\8}/; #use label from the first S node for Spro
    s/{([\w]+\!ldelim\!)?(S[^ ]*) +(.*)<[^ ]*NP[^ ]*-empty(-ctrl)? 0> *<(A[^ ]*\!ldelim\!)?VP(vbg|vbd|vbn|vb|to)([^>]*)>(.*)}/{\1\2 \3<\5Spro\6\7>\8}/; #use label from the VP node for Spro
    s/{([\w]+\!ldelim\!)?(S[^ ]*) +(.*)<[^ ]*NP[^ ]*-empty(-ctrl)? 0> *<(ID\!ldelim\!)?VP(vbg|vbd|vbn|vb|to)([^>]*)>(.*)}/{\1\2 \3<\1Spro\6\7>\8}/; #use label from the first S node for Spro
    s/{([\w]+\!ldelim\!)?(S[^ ]*) +(.*)<[^ ]*NP[^ ]*-empty(-ctrl)? 0> *<(REL\!ldelim\!)?VP(vbg|vbd|vbn|vb|to)([^>]*)>(.*)}/{\1\2 \3<\1Spro\6\7>\8}/; #use label from the first S node for Spro
    # fold empty NP in S with VPto into S pro stative
    #what should the label for Sprostv be???
#    s/{([\w]+\!ldelim\!)?(S[^ ]*) +(.*)<[^ ]*NP[^ ]*-empty(-ctrl)? 0> *(.*)<([\w]+\!ldelim\!)?(ADJP|NP|PP)([^>]*)>(.*)}/{\1\2 \3\5<\6Sprostv\8>\9}/; #use the srl label from the ADJP|NP|PP for Sprostv
#    s/{([\w]+\!ldelim\!)?(S[^ ]*) +(.*)<[^ ]*NP[^ ]*-empty(-ctrl)? 0> *(.*)<([\w]+\!ldelim\!)?(ADJP|NP|PP)([^>]*)>(.*)}/{\1\2 \3\5<\1Sprostv\8>\9}/; #use the srl label from the the parent S for Sprostv
    s/{([\w]+\!ldelim\!)?(S[^ ]*) +(.*)<[^ ]*NP[^ ]*-empty(-ctrl)? 0> *(.*)<(A[^ ]*\!ldelim\!)?(ADJP|NP|PP)([^>]*)>(.*)}/{\1\2 \3\5<\6Sprostv\8>\9}/; #use the srl label from ADJP|NP|PP for Sprostv if it's non-ID
    s/{([\w]+\!ldelim\!)?(S[^ ]*) +(.*)<[^ ]*NP[^ ]*-empty(-ctrl)? 0> *(.*)<(ID\!ldelim\!)?(ADJP|NP|PP)([^>]*)>(.*)}/{\1\2 \3\5<\1Sprostv\8>\9}/; #use the srl label from the parent S for Sprostv if ADJP|NP|PP has ID or REL
    s/{([\w]+\!ldelim\!)?(S[^ ]*) +(.*)<[^ ]*NP[^ ]*-empty(-ctrl)? 0> *(.*)<(REL\!ldelim\!)?(ADJP|NP|PP)([^>]*)>(.*)}/{\1\2 \3\5<\1Sprostv\8>\9}/; #use the srl label from the parent S for Sprostv if ADJP|NP|PP has ID or REL

#    if ($_ =~ /{([\w]+\!ldelim\!)?(S[^ ]*) +(.*)<[^ ]*NP[^ ]*-empty(-ctrl)? 0> *(.*)<([\w]+\!ldelim\!)?(ADJP|NP|PP)([^>]*)>(.*)}/ ) {
#      if ($6=~ /ARG.*\!ldelim\!/) { #use the srl label from ADJP|NP|PP for Sprostv if it's non-ID
#        s/{([\w]+\!ldelim\!)?(S[^ ]*) +(.*)<[^ ]*NP[^ ]*-empty(-ctrl)? 0> *(.*)<([\w]+\!ldelim\!)?(ADJP|NP|PP)([^>]*)>(.*)}/{\1\2 \3\5<\6Sprostv\8>\9}/;
#      } else { #use the srl label from the parent S for Sprostv if ADJP|NP|PP has ID or REL
#        s/{([\w]+\!ldelim\!)?(S[^ ]*) +(.*)<[^ ]*NP[^ ]*-empty(-ctrl)? 0> *(.*)<([A-Za-z0-9\-]\!ldelim\!)?(ADJP|NP|PP)([^>]*)>(.*)}/{\1\2 \3\5<\1Sprostv\8>\9}/; 
#      }
#    }
    
    
#    # fold NP trace in S with VP into VP nonterm
#    s/{S[^ ]* +<[^ ]*-empty 0> *<VP([^>]*)> *}/{VP\1}/;
#    # fold NP trace in S with VP into VP nonterm, subsuming args
#    s/{S[^ ]* +(.*)<[^ ]*-empty 0> *<(VP[^ ]*) ([^>]*)>(.*)}/{VP\2 \1<VP\2 \3>\4}/;
#    # fold NP trace in S with XP into XP nonterm
#    s/{S[^ ]* +<[^ ]*-empty 0> *<(ADJP[^>]*|NP[^>]*|PP[^>]*)> *}/{\1}/;
    # fold NP trace in SBAR into S nonterm
    s/{([\w]+\!ldelim\!)?SBAR[^ \^]*([^ ]*) +<([\w]+\!ldelim\!)?\!NONE\! [^>]*> *<([\w]+\!ldelim\!)?S([^ \^]*)[^ \-]*([^ ]*) ([^>]*)> *}/{\1S\5\2\6 \7}/; #take label from SBAR
    s/{([\w]+\!ldelim\!)?SBAR[^ \^]*([^ ]*) +<[^ ]*-empty-([0-9]*) 0> *<([\w]+\!ldelim\!)?S([^ \^]*)[^ \-]*([^ ]*) ([^>]*)> *}/{\1S\3\2\6-\5 \7}/; #take label from SBAR
#    # redo some mislabeled rel clauses with subject extr
#    s/{(SBAR[^ ]*) +(<WH.*) +<(Simp|Spro[a-z]*)(.*)}/{WH\1 \2 <S-extrNP\4}/;
    # redo SBAR as WHSBAR
    s/{([\w]+\!ldelim\!)?(SBAR[^ ]*) +(<)([\w]+\!ldelim\!)?(WH.*) +(<)([\w]+\!ldelim\!)?(S.*)}/{\1WH\2 \3\4\5 \6\7\8}/; #take label from SBAR
#    # last resort: nuke all remaining empty constituents w/o trace
#    s/{[^ ]* +<[A-Z]*-empty(-ctrl)? +[^>]*> *<([^>]*)> *}/{\2}/;
#    s/{[^ ]* +<([^>]*)> +<[A-Z]*-empty(-ctrl)? +[^>]*> *}/{\1}/;

    # turn NN in VP into VBG -- weird way to annotate gerunds
    s/{([\w]+\!ldelim\!)?(VP[^ ]*) <([\w]+\!ldelim\!)?NN[^ \^]*([^ ]*) ([^>]*)>(.*)}/{\1\2 <\1VBGvbg\4 \5>\6}/; #use the srl label from the parent VP for now

    # give terminal symbols lower case and add lowercase pos to category
    if ($_ =~ /{([\w]+\!ldelim\!)?(VB[A-Z]*|MD|TO|BES|HVS)([^ ]*) *([^ \/]*) *}/) { 
    	$c="$1$2"; $u=$3; $p=lc($2); $w=lc($4); s/{.*}/{$c$p$u $w}/; 
    }
#    if ($_ =~ /{(VB[A-Z]*|MD|TO|BES|HVS)([^ ]*) *([^ \/]*) *}/) { $c=$1; $u=$2; $p=lc($1); $w=$3; s/{.*}/{$c$p$u $w}/; } ## To use case in POS decisions
    # give terminal symbols lower case
    if ($_ =~ /{([\w]+\!ldelim\!)?([A-Z\$]*)([^ ]*) *([^ \/]*) *}/) { 
    	$c="$1$2$3"; $w=lc($4); s/{.*}/{$c $w}/; 
    }
    
#    if ($_ =~ /{([A-Z\$]*)([^ ]*) *([^ \/]*) *}/) { $c="$1$2"; $w=$3; s/{.*}/{$c $w}/; } ## To use case in POS decisions (with above)











	#### CONJUNCTION
    # grab XP , conj XP as XP-LIST
#    s/{([^ ]*) +(.*)<(S[^ ]*|NP[^ ]*|VP[^ ]*|PP[^ ]*|ADJP[^ ]*|ADVP[^ ]*|CD[^ ]*) ([^>]*)> *<(,[^>]*)> *<(CC[^>]*)> *<\3 ([^>]*)>(.*)}/\(\1 \2\{LIST\3 <\3 \4> <\5> <\6> <\3 \7>\}\8\)/;
#    s/{([^ ]*) +(.*)<([\w]+\!ldelim\!)?(S[^ ]*|NP[^ ]*|VP[^ ]*|PP[^ ]*|ADJP[^ ]*|ADVP[^ ]*|CD[^ ]*) ([^>]*)> *<([\w]+\!ldelim\!)?(,[^>]*)> *<([\w]+\!ldelim\!)?(CC[^>]*)> *<\3\4 ([^>]*)>(.*)}/\(\1 \2\{\3LIST\4 <\3\4 \5> <\6\7> <\8\9> <\3\4 $10>\}$11\)/;
#    s/{([^ ]*) +(.*)<([\w]+\!ldelim\!)?(S[^ ]*|NP[^ ]*|VP[^ ]*|PP[^ ]*|ADJP[^ ]*|ADVP[^ ]*|CD[^ ]*) ([^>]*)> *<([\w]+\!ldelim\!)?(,[^>]*)> *<([\w]+\!ldelim\!)?(CC[^>]*)> *<([\w]+\!ldelim\!)?\4 ([^>]*)>(.*)}/\(\1 \2\{\3LIST\4 <\3\4 \5> <\6\7> <\8\9> <$10\4 $11>\}$12\)/;
 	if ( $_ =~ /{([^ ]*) +(.*)<([\w]+\!ldelim\!)?(S[^ ]*|NP[^ ]*|VP[^ ]*|PP[^ ]*|ADJP[^ ]*|ADVP[^ ]*|CD[^ ]*) ([^>]*)> *<([\w]+\!ldelim\!)?(,[^>]*)> *<([\w]+\!ldelim\!)?(CC[^>]*)> *<([\w]+\!ldelim\!)?\4 ([^>]*)>(.*)}/ ) {
 		if ($1 =~ /^ID\!ldelim\!/ && $3 !~ /^ID\!ldelim\!/ ) {
 			s/{([\w]+\!ldelim\!)?([^ ]*) +(.*)<([\w]+\!ldelim\!)?(S[^ ]*|NP[^ ]*|VP[^ ]*|PP[^ ]*|ADJP[^ ]*|ADVP[^ ]*|CD[^ ]*) ([^>]*)> *<([\w]+\!ldelim\!)?(,[^>]*)> *<([\w]+\!ldelim\!)?(CC[^>]*)> *<([\w]+\!ldelim\!)?\4 ([^>]*)>(.*)}/\(\1\2 \3\{\1LIST\5 <\4\5 \6> <\7\8> <\9$10> <$11\4 $12>\}$13\)/;
 		} else {
 			s/{([^ ]*) +(.*)<([\w]+\!ldelim\!)?(S[^ ]*|NP[^ ]*|VP[^ ]*|PP[^ ]*|ADJP[^ ]*|ADVP[^ ]*|CD[^ ]*) ([^>]*)> *<([\w]+\!ldelim\!)?(,[^>]*)> *<([\w]+\!ldelim\!)?(CC[^>]*)> *<([\w]+\!ldelim\!)?\4 ([^>]*)>(.*)}/\(\1 \2\{\3LIST\4 <\3\4 \5> <\6\7> <\8\9> <$10\4 $11>\}$12\)/;
 		}
 	}   
    # grab XP , XP , XP as XP-LIST at end of constit
#    s/{([^ ]*) +(.*)<(NP[^ ]*) ([^>]*)> *<(,[^>]*)> *<\3 ([^>]*)> *<(,[^>]*)> *<\3 ([^>]*)>( *)}/\(\1 \2\{LIST\3 <\3 \4> <\5> <LIST\3 \[\3 \6\] \[\7\] \[\3 \8\]>\}\9\)/;
#    s/{([^ ]*) +([^<]*)<([\w]+\!ldelim\!)?(NP[^ ]*) ([^>]*)> *<([\w]+\!ldelim\!)?(,[^>]*)> *<([\w]+\!ldelim\!)?\4 ([^>]*)> *<([\w]+\!ldelim\!)?(,[^>]*)> *<([\w]+\!ldelim\!)?\4 ([^>]*)>( *)}/\(\1 \2\{\3LIST\4 <\3\4 \5> <\6\7> <\3LIST\4 \[\3\4 \9\] \[$10$11\] \[\3\4 $13\]>\}$14\)/;
    if ($_ =~ /{([^ ]*) +(.*)<([\w]+\!ldelim\!)?(NP[^ ]*) ([^>]*)> *<([\w]+\!ldelim\!)?(,[^>]*)> *<([\w]+\!ldelim\!)?\4 ([^>]*)> *<([\w]+\!ldelim\!)?(,[^>]*)> *<([\w]+\!ldelim\!)?\4 ([^>]*)>( *)}/ ) {
    	if ($1 =~ /^ARG.*\!ldelim\!.*$/ ) { #reset ID to all the children
    		s/{([^ ]*) +(.*)<([\w]+\!ldelim\!)?(NP[^ ]*) ([^>]*)> *<([\w]+\!ldelim\!)?(,[^>]*)> *<([\w]+\!ldelim\!)?\4 ([^>]*)> *<([\w]+\!ldelim\!)?(,[^>]*)> *<([\w]+\!ldelim\!)?\4 ([^>]*)>( *)}/\(\1 \2\{ID!ldelim!LIST\4 <ID!ldelim!\4 \5> <\6\7> <ID!ldelim!LIST\4 \[ID!ldelim!\4 \9\] \[$10$11\] \[ID!ldelim!\4 $13\]>\}$14\)/;
    	} else { #either non-srl version or parent has ID label, retain each child label
		    s/{([^ ]*) +(.*)<([\w]+\!ldelim\!)?(NP[^ ]*) ([^>]*)> *<([\w]+\!ldelim\!)?(,[^>]*)> *<([\w]+\!ldelim\!)?\4 ([^>]*)> *<([\w]+\!ldelim\!)?(,[^>]*)> *<([\w]+\!ldelim\!)?\4 ([^>]*)>( *)}/\(\1 \2\{\3LIST\4 <\3\4 \5> <\6\7> <\8LIST\4 \[\8\4 \9\] \[$10$11\] \[$12\4 $13\]>\}$14\)/;
    	}
    }


    # grab XP , XP-LIST as XP-LIST
#    s/{([^ ]*) +(.*)<(S[^ ]*|NP[^ ]*|VP[^ ]*|PP[^ ]*|ADJP[^ ]*|ADVP[^ ]*|CD[^ ]*) ([^>]*)> *<(,[^>]*)> *<LIST\3 ([^>]*)>(.*)}/\(\1 \2\{LIST\3 <\3 \4> <\5> <LIST\3 \6>\}\7\)/;
    s/{([^ ]*) +(.*)<([\w]+\!ldelim\!)?(S[^ ]*|NP[^ ]*|VP[^ ]*|PP[^ ]*|ADJP[^ ]*|ADVP[^ ]*|CD[^ ]*) ([^>]*)> *<([\w]+\!ldelim\!)?(,[^>]*)> *<([\w]+\!ldelim\!)?LIST\4 ([^>]*)>(.*)}/\(\1 \2\{\3LIST\4 <\3\4 \5> <\6\7> <\8LIST\4 \9>\}$10\)/;

    # grab XP XP conj XP as XP XP-LIST
#    s/{(SBAR|SQ|SINV|S|NP|VP|PP|ADJP|ADVP|CD)([^ ]*) +(.*)<\1([^ ]*) ([^>]*)> *<\1\4 ([^>]*)> *<(CC[^>]*)> *<\1\4 ([^>]*)>(.*)}/\(\1\4 \3<\1\4 \5> \{LIST\1\4 <\1\4 \6> <\7> <\1\4 \8>\}\9\)/;
    s/{([\w]+\!ldelim\!)?(SBAR|SQ|SINV|S|NP|VP|PP|ADJP|ADVP|CD)([^ ]*) +(.*)<([\w]+\!ldelim\!)?\2([^ ]*) ([^>]*)> *<([\w]+\!ldelim\!)?\2\6 ([^>]*)> *<([\w]+\!ldelim\!)?(CC[^>]*)> *<([\w]+\!ldelim\!)?\2\6 ([^>]*)>(.*)}/\(\1\2\6 \4<\5\2\6 \7> \{\8LIST\2\6 <\8\2\6 \9> <$10$11> <$12\2\6 $13>\}$14\)/;

    ##s/{([^ ]*) +(.*)<(S|NP|VP|PP|ADJP|ADVP|CD)([^ ]*) ([^>]*)> *<\3\4 ([^>]*)> *<(CC[^>]*)> *<\3\4 ([^>]*)>(.*)}/\(\1\4 \2<\3\4 \5> \{LIST\3\4 <\3\4 \6> <\7> <\3\4 \8>\}\9\)/;
    ##s/{([^ ]*) +(.*)<(S[^ ]*|NP[^ ]*|VP[^ ]*|PP[^ ]*|ADJP[^ ]*|ADVP[^ ]*|CD[^ ]*) ([^>]*)> *<\3 ([^>]*)> *<(CC[^>]*)> *<\3 ([^>]*)>(.*)}/\(\1 \2<\3 \4> \{LIST\3 <\3 \5> <\6> <\3 \7>\}\8\)/;
    # grab XP XP XP as XP-LIST at end of constit
#    s/{([^ ]*) +(.*)<(NP[^ ]*) ([^>]*)> *<\3 ([^>]*)> *<\3 ([^>]*)>( *)}/\(\1 \2<\3 \4> \{LIST\3 <\3 \5> <\3 \6>\}\7\)/;
    s/{([^ ]*) +(.*)<([\w]+\!ldelim\!)?(NP[^ ]*) ([^>]*)> *<([\w]+\!ldelim\!)?\4 ([^>]*)> *<([\w]+\!ldelim\!)?\4 ([^>]*)>( *)}/\(\1 \2<\3\4 \5> \{\6LIST\4 <\6\4 \7> <\8\4 \9>\}$10\)/;
    # grab XP XP XP-LIST as XP XP-LIST
#    s/{([^ ]*) +(.*)<(S[^ ]*|NP[^ ]*|VP[^ ]*|PP[^ ]*|ADJP[^ ]*|ADVP[^ ]*|CD[^ ]*) ([^>]*)> *<\3 ([^>]*)> *<LIST\3 ([^>]*)>(.*)}/\(\1 \2<\3 \4> \{LIST\3 <\3 \5> <LIST\3 \6>\}\7\)/;
    s/{([^ ]*) +(.*)<([\w]+\!ldelim\!)?(S[^ ]*|NP[^ ]*|VP[^ ]*|PP[^ ]*|ADJP[^ ]*|ADVP[^ ]*|CD[^ ]*) ([^>]*)> *<(\3)?\4 ([^>]*)> *<(\3)?LIST\4 ([^>]*)>(.*)}/\(\1 \2<\3\4 \5> \{\3LIST\4 <\3\4 \7> <\3LIST\4 \9>\}$10\)/;
    # grab X conj X as X  ####(do generic conj first, as more specific one will appear beside it and ultimately replace it via "undo unary identity projection")
#    s/{([^ ]*) +(.*)<([^ ]*) ([^>]*)> *<(CC)([^>]*)> *<\3 ([^>]*)>(.*)}/\(\1 \2\{\3 <\3 \4> <\5\6> <\3 \7>\}\8\)/;
#    s/{([^ ]*) +(.*)<([^ ]*) ([^>]*)> *<([\w]+\!ldelim\!)?(CC)([^>]*)> *<\3 ([^>]*)>(.*)}/\(\1 \2\{\3 <\3 \4> <\5\6\7> <\3 \8>\}\9\)/;

	#Note the following 2 rewrites: if the parent has non-ID srl label or child is a REL, use ID label. Otherwise, promote one up from child
#    s/{([\w]+\!ldelim\!)?([^ ]*) +(.*)<([\w]+\!ldelim\!)?([^ ]*) ([^>]*)> *<([\w]+\!ldelim\!)?(CC)([^>]*)> *<\4\5 ([^>]*)>(.*)}/\(\1\2 \3\{\1\5 <\4\5 \6> <\7\8\9> <\4\5 $10>\}$11\)/; # use top srl label for the newly introduced cat right after the brace
#    s/{([\w]+\!ldelim\!)?([^ ]*) +(.*)<([\w]+\!ldelim\!)?([^ ]*) ([^>]*)> *<([\w]+\!ldelim\!)?(CC)([^>]*)> *<\4\5 ([^>]*)>(.*)}/\(\1\2 \3\{\4\5 <\4\5 \6> <\7\8\9> <\4\5 $10>\}$11\)/; # keep their srl label when grouping CC's
	if ($_ =~ /{([\w]+\!ldelim\!)?([^ ]*) +(.*)<([\w]+\!ldelim\!)?([^ ]*) ([^>]*)> *<([\w]+\!ldelim\!)?(CC)([^>]*)> *<([\w]+\!ldelim\!)?\5 ([^>]*)>(.*)}/ ) {
		if ($_ =~ /\!ldelim\!/ && ($1 !~ /^ID\!ldelim\!/ || $4 =~ /^REL\!ldelim\!/ )) {
			s/{([\w]+\!ldelim\!)?([^ ]*) +(.*)<([\w]+\!ldelim\!)?([^ ]*) ([^>]*)> *<([\w]+\!ldelim\!)?(CC)([^>]*)> *<([\w]+\!ldelim\!)?\5 ([^>]*)>(.*)}/\(\1\2 \3\{ID!ldelim!\5 <\4\5 \6> <\7\8\9> <$10\5 $11>\}$12\)/; # use top srl label for the newly introduced cat right after the brace		
		} else {
			s/{([\w]+\!ldelim\!)?([^ ]*) +(.*)<([\w]+\!ldelim\!)?([^ ]*) ([^>]*)> *<([\w]+\!ldelim\!)?(CC)([^>]*)> *<([\w]+\!ldelim\!)?\5 ([^>]*)>(.*)}/\(\1\2 \3\{\4\5 <\4\5 \6> <\7\8\9> <$10\5 $11>\}$12\)/; # keep their srl label when grouping CC's
		}
	}
   
   
    # don't use proj in any new nonterminal resulting from conj
    #s/{([^ ]*)-proj[^\- ]*([^ ]* .*<.*)}/{\1\2}/;

    #### NOUN PHRASES
    # right-binarize (basal) NPs as much as possible
#    s/{(NP|WHNP)[a-z]*([^ ]*) +(.*)<([A-Z]*)([^ ]* [^>]*)> *<(NN[A-Z]*)([a-z]*)([^ ]* [^>]*)>(.*)}/\(\1\2 \3\{\6 <\4\5> <\6\7\8>\}\9\)/;
#    s/{([\w]+\!ldelim\!)?(NP|WHNP)[a-z]*([^ ]*) +(.*)<([\w]+\!ldelim\!)?([A-Z]*)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)?(NN[A-Z]*)([a-z]*)([^ ]* [^>]*)>(.*)}/\(\1\2\3 \4\{\1\9 <\5\6\7> <\8\9$10$11>\}$12\)/; #use srl label from NP|WHNP for the outer introduced NP|WHNP
#    s/{([\w]+\!ldelim\!)?(NP|WHNP)[a-z]*([^ ]*) +(.*)<([\w]+\!ldelim\!)?([A-Z]*)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)?(NN[A-Z]*)([a-z]*)([^ ]* [^>]*)>(.*)}/\(\1\2\3 \4\{\8\9 <\5\6\7> <\8\9$10$11>\}$12\)/; #conflict with the line above
    if ($_ =~ /{([\w]+\!ldelim\!)?(NP|WHNP)[a-z]*([^ ]*) +(.*)<([\w]+\!ldelim\!)?([A-Z]*)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)?(NN[A-Z]*)([a-z]*)([^ ]* [^>]*)>(.*)}/ ) {
    	if ($1 !~ /^ID\!ldelim\!/ ) { #set srl=ID for children, or just keep them the way they are
		    s/{([\w]+\!ldelim\!)?(NP|WHNP)[a-z]*([^ ]*) +(.*)<([\w]+\!ldelim\!)?([A-Z]*)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)?(NN[A-Z]*)([a-z]*)([^ ]* [^>]*)>(.*)}/\(\1\2\3 \4\{\8\9 <\5\6\7> <\8\9$10$11>\}$12\)/; #use srl label from NP|WHNP for the outer introduced NP|WHNP
    	} else { #propage ID downward from top NP|WHNP
		    s/{([\w]+\!ldelim\!)?(NP|WHNP)[a-z]*([^ ]*) +(.*)<([\w]+\!ldelim\!)?([A-Z]*)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)?(NN[A-Z]*)([a-z]*)([^ ]* [^>]*)>(.*)}/\(\1\2\3 \4\{\1\9 <\5\6\7> <\8\9$10$11>\}$12\)/; #use srl label from NP|WHNP for the outer introduced NP|WHNP
    	}
    }



    # left-binarize NP genitive marker if left and right context reduced to nil
#    s/{(NP|WHNP)[a-z]*([^ ]*) +( *)<(NN[A-Z]*|NP)([a-z]*)([^ ]* [^>]*)> *<(POS)([^ ]* [^>]*)>( *)}/\{\1pos <\4\5\6> <\7\8>\}/;
#    s/{([\w]+\!ldelim\!)?(NP|WHNP)[a-z]*([^ ]*) +( *)<([\w]+\!ldelim\!)?(NN[A-Z]*|NP)([a-z]*)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)?(POS)([^ ]* [^>]*)>( *)}/\{\1\2pos <ID!ldelim!\6\7\8> <\9$10$11>\}/; #srl label of the consti is the one of the pos which is \1. reset the one under it to just ID
	if ( $_ =~ /[\w]+\!ldelim\!/ ) {#srl tree input
		s/{([\w]+\!ldelim\!)?(NP|WHNP)[a-z]*([^ ]*) +( *)<([\w]+\!ldelim\!)?(NN[A-Z]*|NP)([a-z]*)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)?(POS)([^ ]* [^>]*)>( *)}/\{\1\2pos <ID!ldelim!\6\7\8> <\9$10$11>\}/; #srl label of the consti is the one of the pos which is \1. reset the one under it to just ID
	} else {#non-srl tree input
    	s/{(NP|WHNP)[a-z]*([^ ]*) +( *)<(NN[A-Z]*|NP)([a-z]*)([^ ]* [^>]*)> *<(POS)([^ ]* [^>]*)>( *)}/\{\1pos <\4\5\6> <\7\8>\}/;
	}

    # left-binarize NPs after left context reduced to nil
#    s/{(NP)[a-z]*([^ ]*) +( *)<(NN[A-Z]*|NP)([a-z]*)([^ ]* [^>]*)> *<(ADVP|PP|S|VP|WHSBAR)([^ ]* [^>]*)>(.*)}/\(\1\2 \3\{\4 <\4nn\5\6> <\7\8>\}\9\)/;  ##>( *<.*)}
#    s/{([\w]+\!ldelim\!)?(NP)[a-z]*([^ ]*) +( *)<([\w]+\!ldelim\!)?(NN[A-Z]*|NP)([a-z]*)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)?(ADVP|PP|S|VP|WHSBAR)([^ ]* [^>]*)>(.*)}/\(\1\2\3 \4\{\5\6 <\5\6nn\7\8> <\9$10$11>\}$12\)/;  #the outer NP get srl label from parent
    if ( $_ =~ /{([\w]+\!ldelim\!)?(NP)[a-z]*([^ ]*) +( *)<([\w]+\!ldelim\!)?(NN[A-Z]*|NP)([a-z]*)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)?(ADVP|PP|S|VP|WHSBAR)([^ ]* [^>]*)>(.*)}/ ) {
    	if ($1 !~ /^ID\!ldelim\!/ && $5 =~ /^ID\!ldelim\!/ ) { #special case for the 7 sents that failed the nested check
    		s/{([\w]+\!ldelim\!)?(NP)[a-z]*([^ ]*) +( *)<([\w]+\!ldelim\!)?(NN[A-Z]*|NP)([a-z]*)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)?(ADVP|PP|S|VP|WHSBAR)([^ ]* [^>]*)>(.*)}/\(\1\2\3 \4\{\5\6 <\5\6nn\7\8> <\9$10$11>\}$12\)/;  #the outer NP get srl label from parent
    	} else {
    		s/{([\w]+\!ldelim\!)?(NP)[a-z]*([^ ]*) +( *)<([\w]+\!ldelim\!)?(NN[A-Z]*|NP)([a-z]*)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)?(ADVP|PP|S|VP|WHSBAR)([^ ]* [^>]*)>(.*)}/\(\1\2\3 \4\{\1\6 <\5\6nn\7\8> <\9$10$11>\}$12\)/;  #the outer NP get srl label from parent
    	}		
    }
    
	
#    # left-binarize NPs after left context reduced to nil
#    s/{(NP)[a-z]*([^ ]*) +( *)<(NN[A-Z]*|NP)([a-z]*)([^ ]* [^>]*)> *<\, *\,> *<(PP|S|VP|WHSBAR)([^ ]* [^>]*)>(.*)}/\(\1\2 \3\{\4 <\4\5\6> <\, \,> <\7\8>\}\9\)/;  ##>( *<.*)}
    # undo last unary N bar projection
#    s/{(NP)[a-z]*([^ ]*) +<(NN[A-Z]*)([a-z]*)([^ ]*) +(\[[^<>]*)> *}/{\1\2 \6}/;  ## +(\[
    s/{([\w]+\!ldelim\!)?(NP)[a-z]*([^ ]*) +<([\w]+\!ldelim\!)?(NN[A-Z]*)([a-z]*)([^ ]*) +(\[[^<>]*)> *}/{\1\2\3 \8}/;  ## +(\[







    #### VERB PHRASES
    # right-binarize VPs after right context reduced to nil
#    s/{(VP)[a-z]*([^ ]*) +(.*)<(ADVP|RB|PP)([^ ]* [^>]*)> *<(VB[A-Z]*|VP)([a-z]*)([^ ]* [^>]*)>( *)}/\(\1\7\2 \3\{\6\7 <\4\5> <\6\7\8>\}\9\)/; ##(<.*)<
#    s/{([\w]+\!ldelim\!)?(VP)[a-z]*([^ ]*) +(.*)<([\w]+\!ldelim\!)?(ADVP|RB|PP)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)?(VB[A-Z]*|VP)([a-z]*)([^ ]* [^>]*)>( *)}/\(\1\2$10\3 \4\{\8\9$10 <\5\6\7> <\8\9$10$11>\}$12\)/; ##(<.*)<
	if ($_ =~ /{([\w]+\!ldelim\!)?(VP)[a-z]*([^ ]*) +(.*)<([\w]+\!ldelim\!)?(ADVP|RB|PP)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)?(VB[A-Z]*|VP)([a-z]*)([^ ]* [^>]*)>( *)}/ ) {
		if ($5 =~ /\!ldelim\!/ && $5 !~ /^ID\!ldelim\!/ && $8 !~ /^ID\!ldelim\!/ && $5 !~ /$8/ ) {
			s/{([\w]+\!ldelim\!)?(VP)[a-z]*([^ ]*) +(.*)<([\w]+\!ldelim\!)?(ADVP|RB|PP)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)?(VB[A-Z]*|VP)([a-z]*)([^ ]* [^>]*)>( *)}/\(\1\2$10\3 \4\{ID!ldelim!\9$10 <\5\6\7> <\8\9$10$11>\}$12\)/; ##(<.*)<
		} else {
			s/{([\w]+\!ldelim\!)?(VP)[a-z]*([^ ]*) +(.*)<([\w]+\!ldelim\!)?(ADVP|RB|PP)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)?(VB[A-Z]*|VP)([a-z]*)([^ ]* [^>]*)>( *)}/\(\1\2$10\3 \4\{\8\9$10 <\5\6\7> <\8\9$10$11>\}$12\)/; #promote the srl label from the VB|VP
		}
	}	
#    # right-binarize VPs after right context reduced to nil
#    s/{(VP)[a-z]*([^ ]*) +(.*)<(ADVP|RB|PP)([^ ]* [^>]*)> *<\, *\,> *<(VB[A-Z]*|VP)([a-z]*)([^ ]* [^>]*)>( *)}/\(\1\7\2 \3\{\6\7 <\4\5> <\, \,> <\6\7\8>\}\9\)/; ##(<.*)<
    # right-binarize VPs after right context does not contain normal constituents (i.e. contains punct like quote)
#    s/{(VP)[a-z]*([^ ]*) +(.*)<(ADVP|RB|PP)([^ ]* [^>]*)> *<(VB[A-Z]*|VP)([a-z]*)([^ ]* [^>]*)>( *<[^A-Z].*)}/\(\1\7\2 \3\{\6\7 <\4\5> <\6\7\8>\}\9\)/; ##(<.*)<
    if ( /\w+\!ldelim\!/ ) {
    	s/{([\w]+\!ldelim\!)?(VP)[a-z]*([^ ]*) +(.*)<([\w]+\!ldelim\!)?(ADVP|RB|PP)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)?(VB[A-Z]*|VP)([a-z]*)([^ ]* [^>]*)>( *<)([\w]+\!ldelim\!)?([^A-Z].*)}/\(\1\2$10\3 \4\{ID!ldelim!\9$10 <\5\6\7> <\8\9$10$11>\}$12$13$14\)/; ##(<.*)<
    } else {
    	s/{(VP)[a-z]*([^ ]*) +(.*)<(ADVP|RB|PP)([^ ]* [^>]*)> *<(VB[A-Z]*|VP)([a-z]*)([^ ]* [^>]*)>( *<[^A-Z].*)}/\(\1\7\2 \3\{\6\7 <\4\5> <\6\7\8>\}\9\)/; ##(<.*)<
    }
#    # right-binarize VPs after right context does not contain normal constituents (i.e. contains punct like quote)
#    s/{(VP)[a-z]*([^ ]*) +(.*)<(ADVP|RB|PP)([^ ]* [^>]*)> *<\, *\,> *<(VB[A-Z]*|VP)([a-z]*)([^ ]* [^>]*)>( *<[^A-Z].*)}/\(\1\7\2 \3\{\6\7 <\4\5> <\, \,> <\6\7\8>\}\9\)/; ##(<.*)<

    # left-binarize VPs headed by VB or BES as much as possible
    if ( /[\w]+\!ldelim\!/ ) {
    	if ( $_ =~ /{([\w]+\!ldelim\!)(VP|SQ)[a-z]*([^ ]*) +(.*)<([\w]+\!ldelim\!)(VB[A-Z]*|BES)([a-z]*)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)([A-Z]+)([^ ]* [^>]*)>(.*)}/ && $1 !~ /^ID\!ldelim\!/ && $5 =~ /^ID\!ldelim\!/) {
    		s/{([\w]+\!ldelim\!)(VP|SQ)[a-z]*([^ ]*) +(.*)<([\w]+\!ldelim\!)(VB[A-Z]*|BES)([a-z]*)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)([A-Z]+)([^ ]* [^>]*)>(.*)}/\(\1\2\7\3 \4\{\5\6\7 <\5\6\7\8> <\9$10$11>\}$12\)/; #seal the top srl label from propagating down
    	} else {
			s/{([\w]+\!ldelim\!)(VP|SQ)[a-z]*([^ ]*) +(.*)<([\w]+\!ldelim\!)(VB[A-Z]*|BES)([a-z]*)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)([A-Z]+)([^ ]* [^>]*)>(.*)}/\(\1\2\7\3 \4\{\1\6\7 <\5\6\7\8> <\9$10$11>\}$12\)/; #propagate down the top srl label on the outer VP
    	}
    } else {
    	s/{(VP|SQ)[a-z]*([^ ]*) +(.*)<(VB[A-Z]*|BES)([a-z]*)([^ ]* [^>]*)> *<([A-Z]+)([^ ]* [^>]*)>(.*)}/\(\1\5\2 \3\{\4\5 <\4\5\6> <\7\8>\}\9\)/;
    }
    
    # left-binarize VPs headed by TO or MD as much as possible
    # what should be the srl label for the introduced VP??? Use the one from the right-most VP|VB for now. Wrong. Use the label from parent VP|SQ
#    s/{(VP|SQ)[a-z]*([^ ]*) +(.*)<(TO|MD)([a-z]*)([^ ]* [^>]*)> *<(VP|VB)([^ ]* [^>]*)>(.*)}/\(\1\5\2 \3\{VP\5 <\4\5\6> <\7\8>\}\9\)/;
    s/{([\w]+\!ldelim\!)?(VP|SQ)[a-z]*([^ ]*) +(.*)<([\w]+\!ldelim\!)?(TO|MD)([a-z]*)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)?(VP|VB)([^ ]* [^>]*)>(.*)}/\(\1\2\7\3 \4\{\1VP\7 <\5\6\7\8> <\9$10$11>\}$12\)/;
    # left-binarize VPs headed by VP as much as possible
#    s/{(VP|SQ)[a-z]*([^ ]*) +(.*)<(VP)([a-z]*)([^ ]* [^>]*)> *<(PP|VP)([^ ]* [^>]*)>(.*)}/\(\1\5\2 \3\{\4\5 <\4\5\6> <\7\8>\}\9\)/;
    s/{([\w]+\!ldelim\!)?(VP|SQ)[a-z]*([^ ]*) +(.*)<([\w]+\!ldelim\!)?(VP)([a-z]*)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)?(PP|VP)([^ ]* [^>]*)>(.*)}/\(\1\2\7\3 \4\{\5\6\7 <\5\6\7\8> <\9$10$11>\}$12\)/;
#    # right-binarize VPs as much as possible
#    s/{(VP[^ ]*) +(.*)<([^ ]*) ([^>]*)> *<(VB[^ ]*|VP[^ ]*) ([^>]*)>(.*)}/\(\1 \2\{\5 <\3 \4> <\5 \6>\}\7\)/;
    # undo last unary V bar projection
#    s/{(VP)[a-z]*([^ ]*) +<(VB[A-Z]*)([a-z]*)([^ ]*) +(\[[^<>]*)> *}/{\1\4\2 \6}/;  ## +(\[
    s/{([\w]+\!ldelim\!)?(VP)[a-z]*([^ ]*) +<([\w]+\!ldelim\!)?(VB[A-Z]*)([a-z]*)([^ ]*) +(\[[^<>]*)> *}/{\1\2\6\3 \8}/;  ## +(\[

    #### SENTENTIAL PROJECTIONS
    # right-binarize NP-SBJ VP as S. What should be the srl label for the S introduced? Use the one from the S above for now.
#    s/{(S[A-Z]*)[a-z]*([^ ]*) +(.*)<(NP)([^ ]* [^>]*)> *<(VP)([a-z]*)([^ ]* [^>]*)>(.*)}/\(\1\2 \3\{S <\4\5> <\6\7\8>\}\9\)/;
#    s/{([\w]+\!ldelim\!)?(S[A-Z]*)[a-z]*([^ ]*) +(.*)<([\w]+\!ldelim\!)?(NP)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)?(VP)([a-z]*)([^ ]* [^>]*)>(.*)}/\(\1\2\3 \4\{\1S <\5\6\7> <\8\9$10$11>\}$12\)/;
 	#tricky label for the raised S node
    if ( $_ =~ /\!ldelim\!/) {
    	s/{([\w]+\!ldelim\!)?(S[A-Z]*)[a-z]*([^ ]*) +(.*)<([\w]+\!ldelim\!)?(NP)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)?(VP)([a-z]*)([^ ]* [^>]*)>(.*)}/\(\1\2\3 \4\{ID!ldelim!S <\5\6\7> <\8\9$10$11>\}$12\)/;
    } else {
    	s/{(S[A-Z]*)[a-z]*([^ ]*) +(.*)<(NP)([^ ]* [^>]*)> *<(VP)([a-z]*)([^ ]* [^>]*)>(.*)}/\(\1\2 \3\{S <\4\5> <\6\7\8>\}\9\)/;
    }
    # right-binarize MOD VP as VP
#    s/{(SINV)[a-z]*([^ ]*) +(.*)<(ADVP|RB[A-Z]*|PP)([^ ]* [^>]*)> *<(VP|VB[A-Z]*)([a-z]*)([^>]*)>(.*)}/\(\1\2 \3\{\6\7 <\4\5> <\6\7\8>\}\9\)/;
    s/{([\w]+\!ldelim\!)?(SINV)[a-z]*([^ ]*) +(.*)<([\w]+\!ldelim\!)?(ADVP|RB[A-Z]*|PP)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)?(VP|VB[A-Z]*)([a-z]*)([^>]*)>(.*)}/\(\1\2\3 \4\{\8\9$10 <\5\6\7> <\8\9$10$11>\}$12\)/;
    # right-binarize MOD VP as VP
#    s/{(S[A-Z]*)[a-z]*([^ ]*) +(<.*)<(ADVP|RB[A-Z]*|PP)([^ ]* [^>]*)> *<(VP|VB[A-Z]*)([a-z]*)([^>]*)>(.*)}/\(\1\2 \3\{\6\7 <\4\5> <\6\7\8>\}\9\)/;
    s/{([\w]+\!ldelim\!)?(S[A-Z]*)[a-z]*([^ ]*) +(<.*)<([\w]+\!ldelim\!)?(ADVP|RB[A-Z]*|PP)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)?(VP|VB[A-Z]*)([a-z]*)([^>]*)>(.*)}/\(\1\2\3 \4\{\8\9$10 <\5\6\7> <\8\9$10$11>\}$12\)/;

  
  
  
  
  
  
  
  
  
  
  
  
  
    # right-binarize S
#    s/{(S[A-Z]*)[a-z]*([^ ]*) +(.*)<(ADVP|RB[A-Z]*|PP)([^ ]* [^>]*)> *<(\1)([a-z]*)( [^>]*)>(.*)}/\(\1\7\2 \3\{\6\7 <\4\5> <\6\7\8>\}\9\)/;
#    s/{([\w]+\!ldelim\!)?(S[A-Z]*)[a-z]*([^ ]*) +(.*)<([\w]+\!ldelim\!)?(ADVP|RB[A-Z]*|PP)([^ ]* [^>]*)> *<(\1)([a-z]*)( [^>]*)>(.*)}/\(\1\2\9\3 \4\{\8\9 <\5\6\7> <\8\9$10>\}$11\)/;
#    s/{([\w]+\!ldelim\!)?(S[A-Z]*)[a-z]*([^ ]*) +(.*)<([\w]+\!ldelim\!)?(ADVP|RB[A-Z]*|PP)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)?(\2)([a-z]*)( [^>]*)>(.*)}/\(\1\2$10\3 \4\{\8\9$10 <\5\6\7> <\8\9$10$11>\}$12\)/;
	if ( $_ =~ /{([\w]+\!ldelim\!)?(S[A-Z]*)[a-z]*([^ ]*) +(.*)<([\w]+\!ldelim\!)?(ADVP|RB[A-Z]*|PP)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)?(\2)([a-z]*)( [^>]*)>(.*)}/ ) {
		if ($1 =~ /^ID\!ldelim\!/ && $8 !~ /^ID\!ldelim\!/ ) {
			s/{([\w]+\!ldelim\!)?(S[A-Z]*)[a-z]*([^ ]*) +(.*)<([\w]+\!ldelim\!)?(ADVP|RB[A-Z]*|PP)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)?(\2)([a-z]*)( [^>]*)>(.*)}/\(\1\2$10\3 \4\{\1\9$10 <\5\6\7> <\8\9$10$11>\}$12\)/;
		} else {
			s/{([\w]+\!ldelim\!)?(S[A-Z]*)[a-z]*([^ ]*) +(.*)<([\w]+\!ldelim\!)?(ADVP|RB[A-Z]*|PP)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)?(\2)([a-z]*)( [^>]*)>(.*)}/\(\1\2$10\3 \4\{\8\9$10 <\5\6\7> <\8\9$10$11>\}$12\)/;
		}	
	}
    # left-binarize S
#    s/{(S[A-Z]*)[a-z]*([^ ]*) +(.*)<(\1)([a-z]*)( [^>]*)> *<(ADVP|RB[A-Z]*|PP)([^ ]* [^>]*)>(.*)}/\(\1\5\2 \3\{\4\5 <\4\5\6> <\7\8>\}\9\)/;
    s/{([\w]+\!ldelim\!)?(S[A-Z]*)[a-z]*([^ ]*) +(.*)<([\w]+\!ldelim\!)?(\2)([a-z]*)( [^>]*)> *<([\w]+\!ldelim\!)?(ADVP|RB[A-Z]*|PP)([^ ]* [^>]*)>(.*)}/\(\1\2\7\3 \4\{\5\6\7 <\5\6\7\8> <\9$10$11>\}$12\)/;

##    # right-binarize S from above
##    s/{(S[^ ]*) +<(ADVP[^ ]*|PP[^ ]*) (.*>.*<.*)}/\(\1 \2 \{\1 \3\}\)/;
##    # left-binarize S from above
##    s/{(S[^ ]*) (.*>.*<.*) +<(ADVP[^ ]*|PP[^ ]*)}/\(\1 \{\1 \2\} \3\)/;
#    # left-binarize VPs after left context reduced to nil
#    s/{(VP[^ ]*|SQ[^ ]*) +( *)<(VB[^ ]*) ([^>]*)> *<([^ ]*) ([^>]*)> *(<.*)}/\(\1 \2\{\3 <\3 \4> <\5 \6>\}\7\)/;
    # redo Sto
#    s/{(S) +(<NP.*) +(<VPto.*)}/{\1to \2 \3}/;
    s/{([\w]+\!ldelim\!)?(S) +(<)([\w]+\!ldelim\!)?(NP.*) +(<)([\w]+\!ldelim\!)?(VPto.*)}/{\1\2to \3\4\5 \6\7\8}/;
    # undo last unary S bar projection
#    s/{(S)[a-z]*([^ ]*) +<(S)([a-z]*)([^ ]*) +(\[[^<>]*)> *}/{\1\4\2 \6}/;  ## +(\[
	if ( $_ =~ /{([\w]+\!ldelim\!)?(S)[a-z]*([^ ]*) +<([\w]+\!ldelim\!)?(S)([a-z]*)([^ ]*) +(\[[^<>]*)> *}/ ) {
		if ($1 !~ /^ID\!ldelim\!/) { #keep label from parent
			s/{([\w]+\!ldelim\!)?(S)[a-z]*([^ ]*) +<([\w]+\!ldelim\!)?(S)([a-z]*)([^ ]*) +(\[[^<>]*)> *}/{\1\2\6\3 \8}/;  
		} else {
			s/{([\w]+\!ldelim\!)?(S)[a-z]*([^ ]*) +<([\w]+\!ldelim\!)?(S)([a-z]*)([^ ]*) +(\[[^<>]*)> *}/{\4\2\6\3 \8}/;  #use srl label from the inner S
		}
	}
    
    #### ADJECTIVAL / ADVERBIAL PHRASES
    # right-binarize ADJPs as much as possible
#    s/{(ADJP)[a-z]*([^ ]*) +(.*)<(RB[A-Z]*)([^ ]* [^>]*)> *<(JJ[A-Z]*)([a-z]*)([^ ]* [^>]*)>(.*)}/\(\1\2 \3\{\6 <\4\5> <\6\7\8>\}\9\)/;
    s/{([\w]+\!ldelim\!)?(ADJP)[a-z]*([^ ]*) +(.*)<([\w]+\!ldelim\!)?(RB[A-Z]*)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)?(JJ[A-Z]*)([a-z]*)([^ ]* [^>]*)>(.*)}/\(\1\2\3 \4\{\8\9 <\5\6\7> <\8\9$10$11>\}$12\)/;
    # left-binarize ADJPs after left context reduced to nil
#    s/{(ADJP)[a-z]*([^ ]*) +( *)<(JJ[A-Z]*|ADJP)([a-z]*)([^ ]* [^>]*)> *<(PP|S)([^ ]* [^>]*)>(.*)}/\(\1\2 \3\{\4 <\4\5\6> <\7\8>\}\9\)/;  ##>( *<.*)}
    s/{([\w]+\!ldelim\!)?(ADJP)[a-z]*([^ ]*) +( *)<([\w]+\!ldelim\!)?(JJ[A-Z]*|ADJP)([a-z]*)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)?(PP|S)([^ ]* [^>]*)>(.*)}/\(\1\2\3 \4\{\5\6 <\5\6\7\8> <\9$10$11>\}$12\)/;  ##>( *<.*)}
    # undo last unary A bar projection
#    s/{(ADJP)[a-z]*([^ ]*) +<(JJ[A-Z]*)([a-z]*)([^ ]*) +(\[[^<>]*)> *}/{\1\2 \6}/;  ## +(\[
    s/{([\w]+\!ldelim\!)?(ADJP)[a-z]*([^ ]*) +<([\w]+\!ldelim\!)?(JJ[A-Z]*)([a-z]*)([^ ]*) +(\[[^<>]*)> *}/{\1\2\3 \8}/;  ## +(\[
    # right-binarize ADVPs as much as possible
#    s/{(ADVP)[a-z]*([^ ]*) +(.*)<(RB[A-Z]*)([^ ]* [^>]*)> *<(RB[A-Z]*)([a-z]*)([^ ]* [^>]*)>(.*)}/\(\1\2 \3\{\6 <\4\5> <\6\7\8>\}\9\)/;
    s/{([\w]+\!ldelim\!)?(ADVP)[a-z]*([^ ]*) +(.*)<([\w]+\!ldelim\!)?(RB[A-Z]*)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)?(RB[A-Z]*)([a-z]*)([^ ]* [^>]*)>(.*)}/\(\1\2\3 \4\{\8\9 <\5\6\7> <\8\9$10$11>\}$12\)/;
    
    
    
    
    
    
    
    # left-binarize ADVPs after left context reduced to nil
#    s/{(ADVP)[a-z]*([^ ]*) +( *)<(RB[A-Z]*|ADVP)([a-z]*)([^ ]* [^>]*)> *<(PP|S)([^ ]* [^>]*)>(.*)}/\(\1\2 \3\{\4 <\4\5\6> <\7\8>\}\9\)/;  ##>( *<.*)}
    if ( $_ =~ /{([\w]+\!ldelim\!)?(ADVP)[a-z]*([^ ]*) +( *)<([\w]+\!ldelim\!)?(RB[A-Z]*|ADVP)([a-z]*)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)?(PP|S)([^ ]* [^>]*)>(.*)}/ ) {
    	if ($1 !~ /^ID\!ldelim\!/ ) {
    		s/{([\w]+\!ldelim\!)?(ADVP)[a-z]*([^ ]*) +( *)<([\w]+\!ldelim\!)?(RB[A-Z]*|ADVP)([a-z]*)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)?(PP|S)([^ ]* [^>]*)>(.*)}/\(\1\2\3 \4\{\5\6 <\5\6\7\8> <\9$10$11>\}$12\)/;  #use top parent's srl label for the new RB|ADVP
    	} else {
    		s/{([\w]+\!ldelim\!)?(ADVP)[a-z]*([^ ]*) +( *)<([\w]+\!ldelim\!)?(RB[A-Z]*|ADVP)([a-z]*)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)?(PP|S)([^ ]* [^>]*)>(.*)}/\(\1\2\3 \4\{\1\6 <\5\6\7\8> <\9$10$11>\}$12\)/;  #use top parent's srl label for the new RB|ADVP
    	}
    }
    
    # undo last unary Ad bar projection
#    s/{(ADVP)[a-z]*([^ ]*) +<(RB[A-Z]*)([a-z]*)([^ ]*) +(\[[^<>]*)> *}/{\1\2 \6}/;  ## +(\[
    s/{([\w]+\!ldelim\!)?(ADVP)[a-z]*([^ ]*) +<([\w]+\!ldelim\!)?(RB[A-Z]*)([a-z]*)([^ ]*) +(\[[^<>]*)> *}/{\1\2\3 \8}/;  ## +(\[
    # annotate unary rb
#    s/{(ADVP[^ ]*) *<(RB[^ ]*) ([^ >]*)> *}/{\1 <\2-unary \3>}/;
    s/{([\w]+\!ldelim\!)?(ADVP[^ ]*) *<([\w]+\!ldelim\!)?(RB[^ ]*) ([^ >]*)> *}/{\1\2 <\3\4-unary \5>}/;

    #### PREPOSITIONAL PHRASES
#    # annotate particles with word instead of pos
#    s/{(PRT)[^ ]* *<(RP)[^ ]* ([a-z]*) *> *}/{\1\3 <\2\3 \3>}/;
    # annotate prepositions with word instead of pos
#    s/{(IN)[a-z]*([^ ]*) *(of|that)(\!colon\!.*)?}/{\1\3\2 \3\4}/;
    s/{([\w]+\!ldelim\!)?(IN)[a-z]*([^ ]*) *(of|that)(\!colon\!.*)?}/{\1\2\4\3 \4\5}/;
    
    #s/{(PP|SBAR)[a-z]*([^ ]*) *<(IN|TO)(of|that|to)([^ ]* .*)}/{\1\4 <\3\4\5}/;
    # left-binarize PPs/SBARs headed by IN or TO as much as possible
#    s/{(PP|SBAR)[a-z]*([^ ]*) +(.*)<(IN|TO)([a-z]*)([^ ]* [^>]*)> *<([A-Z]+)([^ ]* [^>]*)>(.*)}/\(\1\5\2 \3\{\1\5 <\4\5\6> <\7\8>\}\9\)/;
#    s/{([\w]+\!ldelim\!)?(PP|SBAR)[a-z]*([^ ]*) +(.*)<([\w]+\!ldelim\!)?(IN|TO)([a-z]*)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)?([A-Z]+)([^ ]* [^>]*)>(.*)}/\(\1\2\7\3 \4\{\1\2\7 <\5\6\7\8> <\9$10$11>\}$12\)/;
    if ($_ =~ /[\w]+\!ldelim\!/ ) { #srl version
    	if ( $_ =~ /{([\w]+\!ldelim\!)(PP|SBAR)[a-z]*([^ ]*) +(.*)<([\w]+\!ldelim\!)(IN|TO)([a-z]*)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)([A-Z]+)([^ ]* [^>]*)>(.*)}/ ) {
    		if ($5 =~ /^ID\!ldelim\!/) {
    			s/{([\w]+\!ldelim\!)(PP|SBAR)[a-z]*([^ ]*) +(.*)<([\w]+\!ldelim\!)(IN|TO)([a-z]*)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)([A-Z]+)([^ ]* [^>]*)>(.*)}/\(\1\2\7\3 \4\{\5\2\7 <\5\6\7\8> <\9$10$11>\}$12\)/;
    		} else {
    			s/{([\w]+\!ldelim\!)(PP|SBAR)[a-z]*([^ ]*) +(.*)<([\w]+\!ldelim\!)(IN|TO)([a-z]*)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)([A-Z]+)([^ ]* [^>]*)>(.*)}/\(\1\2\7\3 \4\{\1\2\7 <\5\6\7\8> <\9$10$11>\}$12\)/;		
    		}
    	}
        
    } else { #non-srl version
    	s/{(PP|SBAR)[a-z]*([^ ]*) +(.*)<(IN|TO)([a-z]*)([^ ]* [^>]*)> *<([A-Z]+)([^ ]* [^>]*)>(.*)}/\(\1\5\2 \3\{\1\5 <\4\5\6> <\7\8>\}\9\)/;
    }
    
    
    
    # right-binarize PPs after right context reduced to nil
#    s/{(PP)[a-z]*([^ ]*) +(.*)<(ADVP|RB|PP)([^ ]* [^>]*)> *<(PP)([a-z]*)([^ ]* [^>]*)>( *)}/\(\1\7\2 \3\{\6\7 <\4\5> <\6\7\8>\}\9\)/; ##(<.*)<
    s/{([\w]+\!ldelim\!)?(PP)[a-z]*([^ ]*) +(.*)<([\w]+\!ldelim\!)?(ADVP|RB|PP)([^ ]* [^>]*)> *<([\w]+\!ldelim\!)?(PP)([a-z]*)([^ ]* [^>]*)>( *)}/\(\1\2$10\3 \4\{\8\9$10 <\5\6\7> <\8\9$10$11>\}$12\)/; ##(<.*)<
    # undo last unary P bar projection
#    s/{(PP)[a-z]*([^ ]*) +<(PP)([a-z]*)([^ ]*) +(\[[^<>]*)> *}/{\1\4\2 \6}/;  ## +(\[
    s/{([\w]+\!ldelim\!)?(PP)[a-z]*([^ ]*) +<([\w]+\!ldelim\!)?(PP)([a-z]*)([^ ]*) +(\[[^<>]*)> *}/{\1\2\6\3 \8}/;  ## +(\[
#    # right-binarize PPs after right context reduced to nil
#    s/{(PP)[a-z]*([^ ]*) +(.*)<(ADVP|RB)([^ ]* [^>]*)> *<(IN)([a-z]*)([^ ]* [^>]*)>(.*)}/\(\1\7\2 \3\{\6\7 <\4\5> <\6\7\8>\}\9\)/; ##(<.*)<

    #### TERMINAL SYMBOLS
    # propagate unary head pos at terminal
#    s/{(NP)[a-z]*([^ ]*) +<(NN[A-Z]*)([a-z]*)([^ ]*) +([^<>]*)> *}/{\1\2 <\3\5 \6>}/;
    s/{([\w]+\!ldelim\!)?(NP)[a-z]*([^ ]*) +<([\w]+\!ldelim\!)?(NN[A-Z]*)([a-z]*)([^ ]*) +([^<>]*)> *}/{\1\2\3 <\4\5\7 \8>}/;
    # propagate unary head pos at terminal
#    s/{(VP)[a-z]*([^ ]*) +<(VB[A-Z]*)([a-z]*)([^ ]*) +([^<>]*)> *}/{\1\4\2 <\3\4\5 \6>}/;
    s/{([\w]+\!ldelim\!)?(VP)[a-z]*([^ ]*) +<([\w]+\!ldelim\!)?(VB[A-Z]*)([a-z]*)([^ ]*) +([^<>]*)> *}/{\1\2\6\3 <\4\5\6\7 \8>}/;
    # propagate unary head pos at terminal
#    s/{(ADJP)[a-z]*([^ ]*) +<(JJ[A-Z]*)([a-z]*)([^ ]*) +([^<>]*)> *}/{\1\2 <\3\5 \6>}/;
    s/{([\w]+\!ldelim\!)?(ADJP)[a-z]*([^ ]*) +<([\w]+\!ldelim\!)?(JJ[A-Z]*)([a-z]*)([^ ]*) +([^<>]*)> *}/{\1\2\3 <\4\5\7 \8>}/;
    # propagate unary head pos at terminal
#    s/{(ADVP)[a-z]*([^ ]*) +<(RB[A-Z]*)([a-z]*)([^ ]*) +([^<>]*)> *}/{\1\2 <\3\5 \6>}/;
    s/{([\w]+\!ldelim\!)?(ADVP)[a-z]*([^ ]*) +<([\w]+\!ldelim\!)?(RB[A-Z]*)([a-z]*)([^ ]*) +([^<>]*)> *}/{\1\2\3 <\4\5\7 \8>}/;
    # undo unary identity projection
#    s/{([^ ]*) +<\1([^ ]*) ([^>]*)> *}/{\1\2 \3}/;
    s/{([\w]+\!ldelim\!)?([^ ]*) +<([\w]+\!ldelim\!)?\2([^ ]*) ([^>]*)> *}/{\1\2\4 \5}/;

#    s/{([^ ]*) +<\1([^ ]*) ([^>]*)> *}/{\1\2 \3}/;
    s/{([\w]+\!ldelim\!)?([^ ]*) +<([\w]+\!ldelim\!)?\2([^ ]*) ([^>]*)> *}/{\1\2\4 \5}/;

#    # remove unary children
#    s/{([^ ]*) +<[^ ]* +([^<>]*)> *}/{\1 \2}/;

#    # grab punct at end of any consitit
#    s/{([^ ]*) +(.*<.*<.*) <(\,|\.|\!|!question!)([^>]*)> *}/\(\1 \{\1 \2\} <\3\4>\)/;

	# What srl label to use on the introduced CD? Use the first (higher-up) one
    s/{(.*)<([\w]+\!ldelim\!)?(CD [^>]*)> *<([\w]+\!ldelim\!)?(CD [^>]*)>(.*)}/\(\1\{\2CD <\2\3> <\4\5>\6\}\)/;
    # What srl label to use on the introduced QP? Use the one on the QP for now.
    s/{(.*)<([\w]+\!ldelim\!)?(RB [^>]*)> *<([\w]+\!ldelim\!)?(QP [^>]*)>(.*)}/\(\1\{\4QP <\2\3> <\4\5>\6\}\)/;

    #### PARENS / BRACKETS
    # right paren/bracket raising: introduce from matched parens
    #s/{(.*) +<\!LRB\! \!lrb\!> +<(?![^ ]*-br)([^ ]*) +([^>]*)> +<\!RRB\! \!rrb\!>(.*)}/\(\1 {\2-br <\!LRB\! \!lrb\!> <\2 \3>} <\!RRB\! \!rrb\!>\4\)/;
    s/{(.*) +<([\w]+\!ldelim\!)?\!LRB\! \!lrb\!> +<([\w]+\!ldelim\!)?(?![^ ]*-br)([^ ]*) +([^>]*)> +<([\w]+\!ldelim\!)?\!RRB\! \!rrb\!>(.*)}/\(\1 {\3\4-br <\2\!LRB\! \!lrb\!> <\3\4 \5>} <\6\!RRB\! \!rrb\!>\7\)/;
    # right paren/bracket raising: introduce from right paren
    #s/{(.*<.*) +<(?![^ ]*-br)([^ ]*) +([^>]*)> +<\!RRB\! \!rrb\!>(.*)}/\(\1 {\2-br <\2 \3>} <\!RRB\! \!rrb\!>\4\)/;
    s/{(.*<.*) +<([\w]+\!ldelim\!)?(?![^ ]*-br)([^ ]*) +([^>]*)> +<([\w]+\!ldelim\!)?\!RRB\! \!rrb\!>(.*)}/\(\1 {\2\3-br <\2\3 \4>} <\5\!RRB\! \!rrb\!>\6\)/;
    # right paren/bracket raising: propagate
    #s/{(?![^ ]*-br)([^ ]*) +(<.*) +<\!RRB\! \!rrb\!> *}(?! +<\.)(?=.*\))/{\1-br \2} <\!RRB\! \!rrb\!>/;
    s/{([\w]+\!ldelim\!)?(?![^ ]*-br)([^ ]*) +(<.*) +<([\w]+\!ldelim\!)?\!RRB\! \!rrb\!> *}(?! +<([\w]+\!ldelim\!)?\.)(?=.*\))/{\1\2-br \3} <\4\!RRB\! \!rrb\!>/;
    #s/{([^ ]*-br) +(<.*) +<\!RRB\! \!rrb\!> *}(?! +<\.)(?=.*\))/{\1-br \2} <\!RRB\! \!rrb\!>/;
    s/{([\w]+\!ldelim\!)?([^ ]*-br) +(<.*) +<([\w]+\!ldelim\!)?\!RRB\! \!rrb\!> *}(?! +<([\w]+\!ldelim\!)?\.)(?=.*\))/{\1\2-br \3} <\4\!RRB\! \!rrb\!>/;
    # right paren/bracket raising: terminate
    #s/{(.*) +<([^ ]*)-br +([^>]*)> +<\!RRB\! \!rrb\!> +(<.*)}/\(\1 {\2 <\2-br \3> <\!RRB\! \!rrb\!>} \4\)/;
    s/{(.*) +<([\w]+\!ldelim\!)?([^ ]*)-br +([^>]*)> +<([\w]+\!ldelim\!)?\!RRB\! \!rrb\!> +(<.*)}/\(\1 {\2\3 <\2\3-br \4> <\5\!RRB\! \!rrb\!>} \6\)/;

    #### QUOTES
    # right quote raising: introduce from matched comma quote ... comma quote
    #s/{(.*) +<, ,> +<`` ``> +<(?![^ ]*-qr)([^ ]*) +([^>]*)> +<, ,> +<'' ''>(.*)}/\(\1 \(\2-qr-cr <, ,> {\2-qr <`` ``> <\2 \3>}\) <, ,> <'' ''>\4\)/;
    s/{(.*) +<([\w]+\!ldelim\!)?, ,> +<([\w]+\!ldelim\!)?`` ``> +<([\w]+\!ldelim\!)?(?![^ ]*-qr)([^ ]*) +([^>]*)> +<([\w]+\!ldelim\!)?, ,> +<([\w]+\!ldelim\!)?'' ''>(.*)}/\(\1 \(\4\5-qr-cr <\2, ,> {\4\5-qr <\3`` ``> <\4\5 \6>}\) <\7, ,> <\8'' ''>\9\)/;
    # right quote raising: introduce from matched quotes with comma
    #s/{(.*) +<`` ``> +<(?![^ ]*-qr)([^ ]*) +([^>]*)> +<, ,> +<'' ''>(.*)}/\(\1 {\2-qr <`` ``> <\2 \3> <, ,>} <'' ''>\4\)/;
#    s/{(.*) +<([\w]+\!ldelim\!)?`` ``> +<([\w]+\!ldelim\!)?(?![^ ]*-qr)([^ ]*) +([^>]*)> +<([\w]+\!ldelim\!)?, ,> +<([\w]+\!ldelim\!)?'' ''>(.*)}/\(\1 {\3\4-qr <\2`` ``> <ID!ldelim!\4 \5> <\6, ,>} <\7'' ''>\8\)/;
    if ( $_ =~ /\w+\!ldelim\!/ ) {
    	s/{(.*) +<([\w]+\!ldelim\!)?`` ``> +<([\w]+\!ldelim\!)?(?![^ ]*-qr)([^ ]*) +([^>]*)> +<([\w]+\!ldelim\!)?, ,> +<([\w]+\!ldelim\!)?'' ''>(.*)}/\(\1 {\3\4-qr <\2`` ``> <ID!ldelim!\4 \5> <\6, ,>} <\7'' ''>\8\)/;
    } else {
    	s/{(.*) +<`` ``> +<(?![^ ]*-qr)([^ ]*) +([^>]*)> +<, ,> +<'' ''>(.*)}/\(\1 {\2-qr <`` ``> <\2 \3> <, ,>} <'' ''>\4\)/;
    }
    # right quote raising: introduce from matched quotes
    #s/{(.*) +<`` ``> +<(?![^ ]*-qr)([^ ]*) +([^>]*)> +<'' ''>(.*)}/\(\1 {\2-qr <`` ``> <\2 \3>} <'' ''>\4\)/;
    s/{(.*) +<([\w]+\!ldelim\!)?`` ``> +<([\w]+\!ldelim\!)?(?![^ ]*-qr)([^ ]*) +([^>]*)> +<([\w]+\!ldelim\!)?'' ''>(.*)}/\(\1 {\3\4-qr <\2`` ``> <\3\4 \5>} <\6'' ''>\7\)/;
    # right quote raising: introduce from right quote
    #s/{(.*<.*) +<(?!,)(?![^ ]*-qr)([^ ]*) +([^>]*)> +<'' ''>(.*)}/\(\1 {\2-qr <\2 \3>} <'' ''>\4\)/;
    if ( /\w+\!ldelim\!/ ) {
    	s/{(.*<.*) +<([\w]+\!ldelim\!)(?!,)(?![^ ]*-qr)([^ ]*) +([^>]*)> +<([\w]+\!ldelim\!)'' ''>(.*)}/\(\1 {\2\3-qr <\2\3 \4>} <\5'' ''>\6\)/;	
    } else {
    	s/{(.*<.*) +<(?!,)(?![^ ]*-qr)([^ ]*) +([^>]*)> +<'' ''>(.*)}/\(\1 {\2-qr <\2 \3>} <'' ''>\4\)/;
    }
    # right quote raising: propagate
    #s/{(?![^ ]*-qr)([^ ]*) +(<.*) +<'' ''> *}(?! +<\.)(?=.*\))/{\1-qr \2} <'' ''>/;
    s/{([\w]+\!ldelim\!)?(?![^ ]*-qr)([^ ]*) +(<.*) +<([\w]+\!ldelim\!)?'' ''> *}(?! +<([\w]+\!ldelim\!)?\.)(?=.*\))/{\1\2-qr \3} <\4'' ''>/;
    #s/{([^ ]*-qr) +(<.*) +<'' ''> *}(?! +<\.)(?=.*\))/{\1 \2} <'' ''>/;
    s/{([\w]+\!ldelim\!)?([^ ]*-qr) +(<.*) +<([\w]+\!ldelim\!)?'' ''> *}(?! +<([\w]+\!ldelim\!)?\.)(?=.*\))/{\1\2 \3} <\4'' ''>/;
    # right quote raising: terminate
    #s/{(.*) +<([^ ]*)-qr +([^>]*)> +<'' ''> +(<.*)}/\(\1 {\2 <\2-qr \3> <'' ''>} \4\)/;
    s/{(.*) +<([\w]+\!ldelim\!)?([^ ]*)-qr +([^>]*)> +<([\w]+\!ldelim\!)?'' ''> +(<.*)}/\(\1 {\2\3 <\2\3-qr \4> <\5'' ''>} \6\)/;

    #### DASHES
    # right punct raising: introduce from matched dashes
    #s/{(.*) +<, !dash!> +<(?![^ ]*-dr)([^ ]*) +([^>]*)> +<, !dash!>(.*)}/\(\1 {\2-dr <, !dash!> <\2 \3>} <, !dash!>\4\)/;
    s/{(.*) +<([\w]+\!ldelim\!)?, !dash!> +<([\w]+\!ldelim\!)?(?![^ ]*-dr)([^ ]*) +([^>]*)> +<([\w]+\!ldelim\!)?, !dash!>(.*)}/\(\1 {\3\4-dr <, !dash!> <\3\4 \5>} <\6, !dash!>\7\)/;
    # right punct raising: introduce from right dash
    #s/{(.*<.*) +<(?![^ ]*-dr)([^ ]*) +([^>]*)> +<, !dash!>(.*)}/\(\1 {\2-dr <\2 \3>} <, !dash!>\4\)/;
    s/{(.*<.*) +<([\w]+\!ldelim\!)?(?![^ ]*-dr)([^ ]*) +([^>]*)> +<([\w]+\!ldelim\!)?, !dash!>(.*)}/\(\1 {\2\3-dr <\2\3 \4>} <\5, !dash!>\6\)/;
    # right punct raising: propagate
    #s/{(?![^ ]*-dr)([^ ]*) +(<.*) +<, !dash!> *}(?! +<\.)(?=.*\))/{\1-dr \2} <, !dash!>/;
    s/{([\w]+\!ldelim\!)?(?![^ ]*-dr)([^ ]*) +(<.*) +<([\w]+\!ldelim\!)?, !dash!> *}(?! +<([\w]+\!ldelim\!)?\.)(?=.*\))/{\1\2-dr \3} <\4, !dash!>/;
    #s/{([^ ]*-dr) +(<.*) +<, !dash!> *}(?! +<\.)(?=.*\))/{\1 \2} <, !dash!>/;
    s/{([\w]+\!ldelim\!)?([^ ]*-dr) +(<.*) +<([\w]+\!ldelim\!)?, !dash!> *}(?! +<([\w]+\!ldelim\!)?\.)(?=.*\))/{\1\2 \3} <\4, !dash!>/;
    # right punct raising: terminate
    #s/{(.*) +<([^ ]*)-dr +([^>]*)> +<, !dash!> +(<.*)}/\(\1 {\2 <\2-dr \3> <, !dash!>} \4\)/;
    s/{(.*) +<([^ ]*)-dr +([^>]*)> +<([\w]+\!ldelim\!)?, !dash!> +(<.*)}/\(\1 {\2 <\2-dr \3> <\4, !dash!>} \5\)/;

    #### COMMAS
    # right comma raising: introduce from matched commas
    #s/{(.*) +<, ,> +<(?![^ ]*-cr)([^ ]*) +([^>]*)> +<, ,>(.*)}/\(\1 {\2-cr <, ,> <\2 \3>} <, ,>\4\)/;
    s/{(.*) +<([\w]+\!ldelim\!)?, ,> +<([\w]+\!ldelim\!)?(?![^ ]*-cr)([^ ]*) +([^>]*)> +<([\w]+\!ldelim\!)?, ,>(.*)}/\(\1 {\3\4-cr <\2, ,> <\3\4 \5>} <\6, ,>\7\)/;
    # right comma raising: introduce from right comma
    #s/{(.*<.*) +<(?![^ ]*-cr)([^ ]*) +([^>]*)> +<, ,>(.*)}/\(\1 {\2-cr <\2 \3>} <, ,>\4\)/;
    s/{(.*<.*) +<([\w]+\!ldelim\!)?(?![^ ]*-cr)([^ ]*) +([^>]*)> +<([\w]+\!ldelim\!)?, ,>(.*)}/\(\1 {\2\3-cr <\2\3 \4>} <\5, ,>\6\)/;
    # right comma raising: propagate
    #s/{(?![^ ]*-cr)([^ ]*) +(<.*) +<, ,> *}(?! +<\.)(?=.*\))/{\1-cr \2} <, ,>/;
    s/{([\w]+\!ldelim\!)?(?![^ ]*-cr)([^ ]*) +(<.*) +<([\w]+\!ldelim\!)?, ,> *}(?! +<([\w]+\!ldelim\!)?\.)(?=.*\))/{\1\2-cr \3} <\4, ,>/;
    #s/{([^ ]*-cr) +(<.*) +<, ,> *}(?! +<\.)(?=.*\))/{\1 \2} <, ,>/;
    s/{([^ ]*-cr) +(<.*) +<([\w]+\!ldelim\!)?, ,> *}(?! +<([\w]+\!ldelim\!)?\.)(?=.*\))/{\1 \2} <\3, ,>/;
    # right comma raising: terminate
    #s/{(.*) +<([^ ]*)-cr +([^>]*)> +<, ,> +(<.*)}/\(\1 {\2 <\2-cr \3> <, ,>} \4\)/;
    s/{(.*) +<([^ ]*)-cr +([^>]*)> +<([\w]+\!ldelim\!)?, ,> +(<.*)}/\(\1 {\2 <\2-cr \3> <\4, ,>} \5\)/;


	# This rule is for srl only. Keep REL label at the lower child only
    s/{(REL\!ldelim\!)([^ ]*) +<(REL\!ldelim\!)([^<>]*)> *(.*)}/{ID!ldelim!\2 <\3\4> \5}/;
    s/{(REL\!ldelim\!)([^ ]*) +<([^<>]*)> +<(REL\!ldelim\!)([^<>]*)> *(.*)}/{ID!ldelim!\2 <\3> <\4\5> \6}/;

	# This rule is for srl only. If both children has same non-ID label, promote that label to parent and reset to ID on them both
    s/{(ID\!ldelim\!)([^ ]*) +<(A[^ ]+\!ldelim\!)([^<>]*)> +<\3([^<>]*)> *}/{\3\2 <ID!ldelim!\4> <ID!ldelim!\5>}/;

	# This rule is for srl only. Unary child should get ID if parent is non-ID
    s/{(A[^ ]+\!ldelim\!)([^ ]*) +<(A[^ ]+\!ldelim\!)([^<>]*)> *}/{\1\2 <ID!ldelim!\4>}/;

	# This rule is for srl only. If parent has non-ID, neither left nor right child should have non-ID srl label
    s/{(A[^ ]+\!ldelim\!)([^ ]*) +<(A[^ ]+\!ldelim\!)([^<>]*)> +<([^<>]*)> *}/{\1\2 <ID!ldelim!\4> <\5>}/;
    s/{(A[^ ]+\!ldelim\!)([^ ]*) +<([^<>]*)> +<(A[^ ]+\!ldelim\!)([^<>]*)> *}/{\1\2 <\3> <ID!ldelim!\5>}/;

	# This rule is for srl only. Like above but 3 children instead of 2. The 3rd one is ",CC, etc. that could be anywhere between the 2 main children
    s/{(A[^ ]+\!ldelim\!)([^ ]*) +<(ID\!ldelim\!)(``|''|CC|,) ([^<>]*)> +<(A[^ ]+\!ldelim\!)([^<>]*)> +<([^<>]*)> *}/{\1\2 <\3\4 \5> <ID!ldelim!\7> <\8>}/;
    s/{(A[^ ]+\!ldelim\!)([^ ]*) +<(ID\!ldelim\!)(``|''|CC|,) ([^<>]*)> +<([^<>]*)> +<(A[^ ]+\!ldelim\!)([^<>]*)> *}/{\1\2 <\3\4 \5> <\6> <ID!ldelim!\8>}/;
    s/{(A[^ ]+\!ldelim\!)([^ ]*) +<(A[^ ]+\!ldelim\!)([^<>]*)> +<(ID\!ldelim\!)(``|''|CC|,) ([^<>]*)> +<([^<>]*)> *}/{\1\2 <ID!ldelim!\4> <\5\6 \7> <\8>}/;
    s/{(A[^ ]+\!ldelim\!)([^ ]*) +<([^<>]*)> +<(ID\!ldelim\!)(``|''|CC|,) ([^<>]*)> +<(A[^ ]+\!ldelim\!)([^<>]*)> *}/{\1\2 <\3> <\4\5 \6> <ID!ldelim!\8>}/;
    s/{(A[^ ]+\!ldelim\!)([^ ]*) +<(A[^ ]+\!ldelim\!)([^<>]*)> +<([^<>]*)> +<(ID\!ldelim\!)(``|''|CC|,) ([^<>]*)> *}/{\1\2 <ID!ldelim!\4> <\5> <\6\7 \8>}/;
    s/{(A[^ ]+\!ldelim\!)([^ ]*) +<([^<>]*)> +<(A[^ ]+\!ldelim\!)([^<>]*)> +<(ID\!ldelim\!)(``|''|CC|,) ([^<>]*)> *}/{\1\2 <\3> <ID!ldelim!\5> <\6\7 \8>}/;

	# This rule is for srl only. Like above but even 4 children. Should be interleaved between the 2 main children
    s/{(A[^ ]+\!ldelim\!)([^ ]*) +<(A[^ ]+\!ldelim\!)([^<>]*)> +<(ID\!ldelim\!)(``|''|CC|,) ([^<>]*)> +<([^<>]*)> +<(ID\!ldelim\!)(``|''|CC|,) ([^<>]*)> *}/{\1\2 <ID!ldelim!\4> <\5\6 \7> <\8> <\9$10 $11>}/;
    s/{(A[^ ]+\!ldelim\!)([^ ]*) +<([^<>]*)> +<(ID\!ldelim\!)(``|''|CC|,) ([^<>]*)> +<(A[^ ]+\!ldelim\!)([^<>]*)> +<(ID\!ldelim\!)(``|''|CC|,) ([^<>]*)> *}/{\1\2 <\3> <\4\5 \6> <ID!ldelim!\8> <\9$10 $11>}/;

	# This rule is for srl only. Should we need only a catch-all rule like this?
    s/{(A[^ ]+\!ldelim\!)([^ ]*) +(.*)<(A[^ ]+\!ldelim\!)([^<>]*)>(.*)}/{\1\2 \3<ID!ldelim!\5> \6}/;
    s/{(A[^ ]+\!ldelim\!)([^ ]*) +(.*)<(A[^ ]+\!ldelim\!)([^<>]*)>(.*)}/{\1\2 \3<ID!ldelim!\5> \6}/;
    s/{(A[^ ]+\!ldelim\!)([^ ]*) +(.*)<(A[^ ]+\!ldelim\!)([^<>]*)>(.*)}/{\1\2 \3<ID!ldelim!\5> \6}/;
    s/{(A[^ ]+\!ldelim\!)([^ ]*) +(.*)<(A[^ ]+\!ldelim\!)([^<>]*)>(.*)}/{\1\2 \3<ID!ldelim!\5> \6}/;
    s/{(A[^ ]+\!ldelim\!)([^ ]*) +(.*)<(A[^ ]+\!ldelim\!)([^<>]*)>(.*)}/{\1\2 \3<ID!ldelim!\5> \6}/;


    #print stderr ":::$_";
    ####################

    ## convert inner angles (if any) to bracks...
    while ($_ =~ /{[^{}]*</) {
      $_ =~ s/({[^{}]*)<([^<>]*)>/\1\[\2\]/;
    }

    ## convert outer braces to angles...
    $_ =~ s/{(.*)}/<\1>/;
    
  }

  ## finish up...
  $_ =~ s/</[/;
  $_ =~ s/>/]/;

  ## translate to parens again...
  $_ =~ s/\[/\(/g;
  $_ =~ s/\]/\)/g;
  $_ =~ s/____INTJ/INTJ/g;
  
  ## unshift colons (for SRL) and dashes
  $_ =~ s/!colon!!colon!/:!colon!/g;
  $_ =~ s/!colon!([^ !]+)/:\U\1/g;
  #$_ =~ s/:([^ ]*)\!dash!(.*)/:\1--\2/g;
  #$_ =~ s/:([^ ]*)\!dash!(.*)/:\1--\2/g;
  $_ =~ s/RELDASH/-/g;
  $_ =~ s/:REL-([^\.]+)\./:REL-\L\1./g;
  
  $_ =~ s/ARGMRELDAZDIZ/ARGMRELDAZDIS/g;
#  $_ =~ s/RELDAZ/-/g;
#  $_ =~ s/!ldelim!/:/g;
  
  print $_;
}
