theory question_93_2

imports Main

begin

typedecl entity

consts
  AdultEchinoderms :: "entity ⇒ bool"
  RadialSymmetry :: "entity ⇒ bool"
  Starfish :: "entity ⇒ bool"
  Echinoderms :: "entity ⇒ bool"
  Exhibits :: "entity ⇒ (entity ⇒ bool) ⇒ bool"
  ReachedMaturity :: "entity ⇒ bool"
  AdultStarfish :: "entity ⇒ bool"

(* Explanation 1: Adult echinoderms have radial symmetry. *)
axiomatization where
  explanation_1: "∀x. AdultEchinoderms x ⟶ RadialSymmetry x"

(* Explanation 2: Starfish are a type of echinoderm that exhibits radial symmetry as adults. *)
axiomatization where
  explanation_2: "∀x. Starfish x ⟶ (Echinoderms x ∧ Exhibits x (λy. AdultEchinoderms y ⟶ RadialSymmetry y))"

(* Explanation 3: Adult starfish are starfish that have reached maturity. *)
axiomatization where
  explanation_3: "∀x. AdultStarfish x ⟷ (Starfish x ∧ ReachedMaturity x)"

theorem hypothesis:
  assumes asm: "AdultStarfish x"
  (* Hypothesis: Adults of starfish have radial symmetry. *)
  shows "RadialSymmetry x"
proof -
  from asm have "AdultStarfish x" by simp
  then obtain e where e: "Starfish x ∧ ReachedMaturity x" using explanation_3 by blast
  then have "Starfish x" using e by simp
  then have "Echinoderms x ∧ Exhibits x (λy. AdultEchinoderms y ⟶ RadialSymmetry y)" using explanation_2 by blast
  then have "Exhibits x (λy. AdultEchinoderms y ⟶ RadialSymmetry y)" using e by simp
  then have "AdultEchinoderms x ⟶ RadialSymmetry x" using e by blast
  then have "RadialSymmetry x" using explanation_1 e by blast
  show ?thesis using asm `RadialSymmetry x` by blast
qed

end
