theory question_81_1
imports Main

begin

typedecl entity
typedecl event

consts
  ExternalMigration :: "entity ⇒ bool"
  PopulationSize :: "entity ⇒ bool"
  Cause :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  SuddenReduction :: "event ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Event :: "event ⇒ event ⇒ bool"
  BottleneckEffect :: "event ⇒ bool"
  NecessaryCondition :: "event ⇒ entity ⇒ bool"
  Occur :: "event ⇒ bool"

(* Explanation 1: External migration can cause a sudden reduction in population size. *)
axiomatization where
  explanation_1: "∀x y e1 e2. ExternalMigration x ∧ PopulationSize y ⟶ (∃e1 e2. Cause e1 ∧ Agent e1 x ∧ SuddenReduction e2 ∧ Patient e2 y ∧ Event e1 e2)"

(* Explanation 2: A sudden reduction in population size is a necessary condition for the bottleneck effect. *)
axiomatization where
  explanation_2: "∀x e y. BottleneckEffect e ∧ SuddenReduction y ∧ PopulationSize x ⟶ NecessaryCondition e x"

theorem hypothesis:
  assumes asm: "ExternalMigration x"
  (* Hypothesis: Bottleneck effect can occur with external migration. *)
  shows "∃e. BottleneckEffect e ∧ Occur e ∧ Agent e x"
proof -
  from asm have "ExternalMigration x" by simp
  then obtain e1 e2 where e1: "Cause e1" and e2: "SuddenReduction e2" and e3: "Event e1 e2"
    using explanation_1 by blast
  then obtain y where "PopulationSize y" and "Agent e1 x" and "Patient e2 y" using e1 e2 e3 by blast
  then have "BottleneckEffect e1" using explanation_2 by blast
  have "Occur e1" by simp
  have conclusion: "BottleneckEffect e1 ∧ Occur e1 ∧ Agent e1 x" using e1 by simp
  show ?thesis using asm conclusion by blast
qed

end
