theory question_75_0
imports Main
begin

typedecl entity
typedecl event

consts
  Slow :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  SlowDown :: "event ⇒ bool"
  Decreases :: "event ⇒ entity ⇒ bool"
  Speed :: "entity ⇒ entity"
  Friction :: "entity ⇒ bool"
  Object :: "entity ⇒ bool"
  Surface :: "entity ⇒ bool"
  Touching :: "event ⇒ entity ⇒ entity ⇒ bool"
  Acts :: "event ⇒ entity ⇒ bool"
  Counter :: "event ⇒ entity ⇒ bool"
  Motion :: "entity ⇒ bool"
  Touch :: "event ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Contact :: "event ⇒ entity ⇒ entity ⇒ bool"
  Part :: "entity ⇒ entity ⇒ bool"
  Push :: "event ⇒ bool"
  Pull :: "event ⇒ bool"
  Reduce :: "event ⇒ bool"
  Stop :: "event ⇒ bool"
  Resist :: "event ⇒ bool"
  Decrease :: "event ⇒ entity ⇒ bool"
  Rolling :: "event ⇒ bool"
  Ball :: "entity ⇒ bool"
  Force :: "entity ⇒ bool"
  Type :: "entity ⇒ entity ⇒ bool"
  Kind :: "entity ⇒ entity ⇒ bool"
  FrictionalForces :: "entity ⇒ bool"
  SoccerBall :: "entity ⇒ bool"
  SlowingDown :: "event ⇒ bool"
  Requires :: "entity ⇒ event ⇒ bool"

(* Explanation 1: to slow; to slow down decreases speed. *)
axiomatization where
  explanation_1: "∀x e1 e2. Slow e1 ∧ Agent e1 x ∧ SlowDown e2 ∧ Agent e2 x ⟶ Decreases e1 (Speed x) ∧ Decreases e2 (Speed x)"

(* Explanation 2: friction acts to counter the motion of two objects when their surfaces are touching. *)
axiomatization where
  explanation_2: "∀x y z e1 e2 e3. Friction x ∧ Object y ∧ Object z ∧ Surface y ∧ Surface z ∧ Touching e3 y z ⟶ Acts e1 x ∧ Counter e2 x"

(* Explanation 3: to touch means to contact. *)
axiomatization where
  explanation_3: "∀x y e. Touch e ∧ Agent e x ∧ Patient e y ⟶ Contact e x y"

(* Explanation 4: a surface is a part of an object. *)
axiomatization where
  explanation_4: "∀x y. Surface x ∧ Object y ⟶ Part x y"

(* Explanation 5: pushing is a kind of motion. *)
axiomatization where
  explanation_5: "∀e x. Push e ∧ Object x ⟶ Motion x"

(* Explanation 6: pulling is a kind of motion. *)
axiomatization where
  explanation_6: "∀e x. Pull e ∧ Object x ⟶ Motion x"

(* Explanation 7: counter means reduce; stop; resist. *)
axiomatization where
  explanation_7: "∀e. Counter e ⟶ Reduce e ∨ Stop e ∨ Resist e"

(* Explanation 8: to reduce means to decrease. *)
axiomatization where
  explanation_8: "∀x e. Reduce e ∧ Agent e x ⟶ Decrease e x"

(* Explanation 9: rolling is a kind of motion. *)
axiomatization where
  explanation_9: "∀e x. Rolling e ∧ Object x ⟶ Motion x"

(* Explanation 10: a ball is a kind of object. *)
axiomatization where
  explanation_10: "∀x. Ball x ⟶ Object x"

(* Explanation 11: friction is a kind of force. *)
axiomatization where
  explanation_11: "∀x. Friction x ⟶ Force x"

(* Explanation 12: a type is synonymous with a kind. *)
axiomatization where
  explanation_12: "∀x y. Type x y ⟷ Kind x y"

theorem hypothesis:
  assumes asm: "FrictionalForces x ∧ SoccerBall y ∧ Rolling y ∧ SlowingDown e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Object z ∧ Contact e2 y z ∧  Push e3 z y ∨ Pull e3 z y "
  (* Hypothesis: Frictional forces slowing down a rolling soccer ball is a type of force that requires contact between two objects for one to push or pull the other. *)
  shows "Type x Force ∧ Requires x e2"
proof -
  from asm have "FrictionalForces x ∧ SoccerBall y ∧ Rolling y ∧ SlowingDown e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Object z ∧ Contact e2 y z ∧  Push e3 z y ∨ Pull e3 z y" by simp
  then have "Object y" using explanation_10 by blast
  then have "Acts e1 x ∧ Counter e2 x" using explanation_2 by blast
  then have "Contact e x y" using explanation_3 by blast
  then have "Decreases e1 (Speed x) ∧ Decreases e2 (Speed x)" using explanation_1 by blast
  then have "Decrease e x" using explanation_8 by blast
  then have "Motion x" using explanation_9 explanation_5 explanation_6 by blast
  then have "Type x Force" using explanation_11 explanation_12 by blast
  then show ?thesis using asm `Type x Force` `Contact e x y` by blast
qed

end
