theory question_64_0

imports Main

begin
typedecl entity
typedecl event
consts
  FoodVendor :: "entity ⇒ bool"
  Food :: "entity ⇒ bool"
  Serves :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  People :: "entity ⇒ bool"
  StandInLine :: "event ⇒ bool"
  For :: "event ⇒ entity ⇒ bool"
  Waiting :: "event ⇒ bool"
  By :: "event ⇒ entity ⇒ bool"

(* Explanation 1: A food vendor serves food. *)
axiomatization where
  explanation_1: "∃x y e. FoodVendor x ∧ Food y ∧ Serves e ∧ Agent e x ∧ Patient e y"

theorem hypothesis:
  (* Premise: People are waiting in line by a food vendor. *)
  assumes asm: "People x ∧ FoodVendor z ∧ StandInLine e ∧ By e z ∧ Waiting e ∧ Agent e x"
  (* Hypothesis: People stand in line for food. *)
  shows "∃x y e. People x ∧ Food y ∧ StandInLine e ∧ For e y"
proof -
  from asm have "People x ∧ FoodVendor z ∧ StandInLine e ∧ By e z ∧ Waiting e ∧ Agent e x" by blast
  then obtain y where "Food y" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
