
import os
import sys
import json
import argparse
import pandas as pd
import logging
logging.basicConfig(format='%(asctime)s [%(filename)s:%(funcName)s:%(lineno)d] %(levelname)s: %(message)s', level=logging.DEBUG)
import overall_utils
from hotpotqa.run_hotpotqa import run_hotpotqa
from game24.run_game24 import run_game24
from sudoku.run_sudoku import run_sudoku
from gsm8k.run_gsm8k import run_gsm8k


if __name__ == '__main__':
    # load arg
    args = argparse.ArgumentParser()
    args.add_argument('--config_file', type=str, default='configs/game_of_24_bfs.yaml')
    args = args.parse_args()

    # load model
    config = overall_utils._load_yaml(args.config_file)

    dataset_name = config["dataset"]
    logging.info(f"running experiement with dataset_name: {dataset_name}, model_name: {config['openai']}, strategy: {config['strategy']}")
    if dataset_name == "hotpotqa":
        # go to run_hotpotqa
        run_hotpotqa(config)
    elif dataset_name == "game24":
        run_game24(config)
    elif dataset_name == "sudoku":
        run_sudoku(config)
    elif dataset_name == "gsm8k":
        original = config["additional"]
        num_runs = config["multi_run"]
        config["multi_run"] = f"run{num_runs}_{original}"
        for i in range(num_runs):
            config["additional"] = original + f"{num_runs}_{i}"
            run_gsm8k(config)
    elif dataset_name == "counterintuitive_AR":
        for i in range(100):
            config["additional"] = f"4_7_{i}"
            run_gsm8k(config)
