import logging
import sys
import json

from typing import Any, List, Dict


def set_logger(name: str) -> logging.Logger:
    """
    set and return the logger object

    :param name: logger name
    :return: logger object
    """
    logger = logging.getLogger(name)
    logger.setLevel(logging.INFO)

    stream_handler = logging.StreamHandler(sys.stdout)
    stream_handler.setFormatter(logging.Formatter("[%(asctime)s] %(message)s"))
    logger.addHandler(stream_handler)

    return logger


def read_dataset(dataset_path: str) -> List[Dict[str, Any]]:
    """
    read dataset from a given dataset path

    :param dataset_path: given dataset path
    :return: list of data
    """
    conv_data = []
    
    for line in open(dataset_path, 'r', encoding='UTF8'):
        conv_data.append(json.loads(line))

    return conv_data


def save_results(result_path: str, result_dataset: List[Dict[str, Any]]):
    """
    save the results (generated negatives) into a given result path
    """
    with open(result_path, 'w') as f:
        for data in result_dataset:
            f.write(json.dumps(data))
            f.write("\n")
        f.close()