import argparse
import pathlib
import re
import shutil

parser = argparse.ArgumentParser()
parser.add_argument('--workspaces', nargs='+', type=pathlib.Path, required=True)
parser.add_argument('-k', type=int, required=True)
parser.add_argument('--weights', choices=('uniform', 'distance'), default='distance')


classification_method_re = re.compile(r'^CLASSIFICATION_METHOD\s*=')

def process_workspace(args, workspace):
    # Edit configuration file
    lines = (workspace / 'conf' / 'conf.py').read_text().splitlines()
    matched_lineno = -1
    for i, line in enumerate(lines):
        m = classification_method_re.match(line)
        if m:
            matched_lineno = i
    if matched_lineno != -1:
        lines[matched_lineno] = 'CLASSIFICATION_METHOD = \'knn\''
    else:
        lines.append('CLASSIFICATION_METHOD = \'knn\'')
    with open(workspace / 'conf' / 'conf.py', 'w') as f:
        for line in lines:
            print(line, file=f)

    # Save classififier configuration
    p = workspace / 'conf' / f'knn--k_{args.k}--weights_{args.weights}.py'
    with open(p, 'w') as f:
        print('KEYWORDS = {', file=f)
        print(f'    \'n_neighbors\': {args.k},', file=f)
        print(f'    \'weights\': \'{args.weights}\',', file=f)
        print('}', file=f)
    shutil.copy(p, workspace / 'conf' / 'classifier_hyperparams.py')


def run(args):
    for workspace in args.workspaces:
        process_workspace(args, workspace)


if __name__ == '__main__':
    args = parser.parse_args()
    run(args)
