import os
import itertools


def main():

    # List your physical machines.
    phys_machs = ['taoji@139.196.228.41 -p 8020', ]
    # List the memory you needed.
    req_mem = 5000
    gpu_available = []
    for mach in phys_machs:
        res = os.popen(f"ssh {mach} -T 'nvidia-smi --query-gpu=memory.free --format=csv,nounits,noheader'")
        gpu_free_memory = res.readlines()
        for i, gpu in enumerate(gpu_free_memory):
            if int(gpu) > req_mem:
                gpu_available.append((mach, i, int(gpu)))
    # Sort by free memory in descending order.
    gpu_available.sort(key=lambda x: -x[2])
    print(gpu_available)

    # List the CMD arguments to explore. 
    argu_list = {
        'D_ARC': ['500', '512'],
        'MLP_DROP': ['0.33', '0.4']
    }
    argu_comb = list(itertools.product(*argu_list.values()))
    argu_comb = [dict(zip(argu_list.keys(), values)) for values in argu_comb]
    for argu in argu_comb:
        ckpt_name = '+'.join([k+v for k, v in argu.items()])
        print(ckpt_name)

        data_dir = '/home/taoji/data/dataset/DEP/PTB'
        ckpt_dir = f'../ckpts/{ckpt_name}'
        hyper_cfg = {
            # Data IO
            'TRAIN': f'{data_dir}/train.conllu',
            'DEV': f'{data_dir}/dev.conllu',
            'TEST': f'{data_dir}/test.conllu',
            'GLOVE': f'{data_dir}/glove_PTB.gz',
            'PRED_DEV': f'{ckpt_dir}/dev.pred',
            'PRED_TEST': f'{ckpt_dir}/test.pred',
            'LOG': f'{ckpt_dir}/exper.log',
            'MIN_COUNT': '2',
            'LAST': f'{ckpt_dir}/last.pt',
            'BEST': f'{ckpt_dir}/best.pt',
            # Training setup
            'SEED': '666',
            'N_EPOCH': '2',
            'N_BATCH': '100',
            'N_WORKER': '2',
            # Optimizer
            'LR': '0.002',
            'BETAS': '0.9 0.9',
            'EPS': '1e-8',
            'LR_DECAY': '0.75',
            'LR_ANNEAL': '8000',
            'CLIP': '5.0',
            # Network setup
            'IS_FIX_GLOVE': '',
            'D_TAG': '50',
            'N_RNN_LAYER': '3',
            'D_RNN_HID': '400',
            'D_ARC': '500',
            'D_REL': '100',
            'EMB_DROP': '0.33',
            'RNN_DROP': '0.33',
            'MLP_DROP': '0.33',
        }

        cmd_args = [f'--{k} {v}'for k, v in hyper_cfg.items()]
        cmd_run = f"CUDA_VISIBLE_DEVICES={2} python train.py {' '.join(cmd_args)}"
        print(cmd_run)


if __name__ == '__main__':
    main()