/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.aggregation;

import simplenlg.aggregation.CoordinationRule;
import simplenlg.aggregation.PhraseChecker;
import simplenlg.features.DiscourseFunction;
import simplenlg.features.Tense;
import simplenlg.realiser.CoordinateVPPhraseSpec;
import simplenlg.realiser.Phrase;
import simplenlg.realiser.SPhraseSpec;
import simplenlg.realiser.VPPhraseSpec;

public class ClauseCoordination
extends CoordinationRule {
    @Override
    public SPhraseSpec apply(SPhraseSpec ... sentences) {
        SPhraseSpec result = null;
        SPhraseSpec s1 = sentences[0];
        Tense t = s1.getTense();
        boolean perf = s1.isPerfect();
        boolean pass = s1.isPassive();
        boolean prog = s1.isProgressive();
        if (PhraseChecker.areNotCoordinate(sentences)) {
            if (PhraseChecker.sameSentences(sentences)) {
                result = sentences[0];
            } else if (PhraseChecker.sameFrontMods(sentences) && PhraseChecker.sameSurfaceSubjects(sentences)) {
                if (!PhraseChecker.sameVPArgs(sentences) && PhraseChecker.sameVPHead(sentences) && PhraseChecker.sameVPModifiers(sentences)) {
                    VPPhraseSpec vp = new VPPhraseSpec();
                    vp.setHead(sentences[0].getHead());
                    result = new SPhraseSpec();
                    for (SPhraseSpec s : sentences) {
                        for (Phrase comp : s.getComplements()) {
                            DiscourseFunction function = comp.getDiscourseFunction();
                            vp.addComplement(comp, function);
                        }
                    }
                    result.setVerbPhrase(vp);
                    for (Phrase pre : sentences[0].getPremodifiers()) {
                        vp.addPremodifier(pre);
                    }
                    for (Phrase post : sentences[0].getPostmodifiers()) {
                        vp.addPostmodifier(post);
                    }
                } else if (PhraseChecker.areNotExistential(sentences)) {
                    CoordinateVPPhraseSpec cvp = new CoordinateVPPhraseSpec(new VPPhraseSpec[0]);
                    result = new SPhraseSpec();
                    for (SPhraseSpec s : sentences) {
                        cvp.addCoordinates(s.getVerbPhrase());
                    }
                    cvp.aggregateAuxiliary(true);
                    result.setVerbPhrase(cvp);
                }
                for (Phrase subj : sentences[0].getSubjects()) {
                    result.addSubject(subj);
                }
                for (Phrase front : sentences[0].getFrontModifiers()) {
                    result.addFrontModifier(front);
                }
                if (sentences[0].hasCuePhrase()) {
                    result.setCuePhrase(sentences[0].getCuePhrase());
                }
            } else if (PhraseChecker.sameVP(sentences)) {
                result = new SPhraseSpec();
                for (SPhraseSpec s : sentences) {
                    for (Phrase f : s.getFrontModifiers()) {
                        result.addFrontModifier(f);
                    }
                    for (Phrase subj : s.getSubjects()) {
                        result.addSubject(subj);
                    }
                }
                result.setVerbPhrase(sentences[0].getVerbPhrase());
            }
            if (result != null) {
                result.setTense(t);
                result.setPassive(pass);
                result.setPerfect(perf);
                result.setProgressive(prog);
            }
        }
        return result;
    }
}

