import timeit
import nltk
import pickle
import os

from CTestGeneratorStrategy import CTestGeneratorStrategy

class StandardStrategy(CTestGeneratorStrategy):
    '''
    This is a implemenation of a ctest generation startegy with the standard generation scheme.
    This Strategy generates one c-test without any difficulty adjustments
    '''
    def generateContextSents(self,ctest, sentence):
        '''
        This method appends a sentece which should not be mutilated by gaps in the DKPro TC Format.
        :param ctest:Token-List of ctest in DKPro TC format
        :param sentence: Sentece to add
        :return:List with added sentece
        '''
        token = nltk.word_tokenize(sentence)
        if not ctest:
            if len(token) > 20:
                [ctest.append(t + "\n") for t in token[-20:]]
            else:
                [ctest.append(t + "\n") for t in token]
        else:
            if len(token) > 20:
                [ctest.append(t + "\n") for t in token[:20]]
            else:
                [ctest.append(t + "\n") for t in token]
        ctest.append("----\n")

    def generate_ctest(self, txt):
        '''
        This method generates a ctest in the DKPro TC Format according to the greedy strategy.
        The startegy suggests to generate a ctest containing always 20 gaps with one candidate in between.
        Candidates are all normal words with more than two character.
        The first and the last sentece have no mutilations to provide context information.
        :param txt: Text to produce ctest from
        :return:None if text is not appropriate for the test generation or ctest in TC Format if successful
        '''
        ctest_tc = []
        ctest =[]
        gaps=[]
        gapId = 0;
        tN = 0
        web0=[]
        web1=[]
        web2=[]
        web3=[]
        sents = [s.replace("\n", "") for s in nltk.sent_tokenize(txt)[:30]]

        if len(sents) < 2:
            print("input should contain at least 2 sentences, but only ", len(sents), "were detected")
            return

        self.generateContextSents(ctest_tc, sents[0])
        ctest.append(sents[0])
        web0.append(sents[0])
        web2.append(sents[0])
        web3.append(sents[0])
        for n, sent in enumerate(sents[1:]):
            if sents[n + 1] == None or gapId > 19:
                self.generateContextSents(ctest_tc, sent)
                ctest.append(sent)
                web0.append(sent)
                web2.append(sent)
                web3.append(sent)
                return ("".join(ctest_tc),"".join(ctest),gaps,(' '.join(web0),' '.join(web1),''.join(web2),' '.join(web3)))
            else:
                for i, t in enumerate(nltk.word_tokenize(sent)):
                    if t.isalpha() and not t.isupper() and len(t) > 1:
                        if tN % 2 == 1 and not gapId > 19:
                            cut = int(len(t) / 2)
                            ctest_tc.append(t + "\t" + str(gapId+1) + "\t" + t[0:cut] + "\t" + "0.0" + "\n")
                            ctest.append(" "+t[0:cut]+"_"*(len(t)-cut))
                            gapId += 1
                            gaps.append(t)

                            web0.append(t[0:cut] + '#GAP#')
                            web1.append(t[cut:])
                            web2.append(" "+t)
                            web3.append(t)
                        else:
                            ctest_tc.append(t + "\n")
                            ctest.append(" "+t)
                            web3.append(t)
                            web2.append(" "+t)
                            web0.append(t)
                        tN += 1
                    else:
                        ctest_tc.append(t + "\n")
                        web3.append(t)
                        web0.append(t)
                        if t not in [".",",","\'",'\'','?','!',';','&','(',')']:
                            ctest.append(" "+t)
                            web2.append(" "+t)
                        else:
                            ctest.append(t)
                            web2.append(t)
                ctest_tc.append("----\n")
        return None

    def retrieve_ctest(self):
        '''
        This method produces a c-test out of the first text of the corpus
        :return:ctest as tuple of tc-Format, Human readable, gaps, the average and the individual predicted difficulty.
        '''

        start = timeit.default_timer()
        text=self.texts[0]
        ctestTemp = self.generate_ctest(text)
        if ctestTemp is not None:
            prediction = self.predict(ctestTemp[0])
            print(sum(prediction[0])/len(prediction[0]))
            return ctestTemp+(sum(prediction[0])/len(prediction[0]),prediction[0],)
        print("Problem during the generation: cTest became None")
        return False

