/*
 * Decompiled with CFR 0.152.
 */
package fig.basic;

public class FloatVec {
    private float[] data;
    private int n;

    public FloatVec() {
        this.data = new float[0];
        this.n = 0;
    }

    public FloatVec(int cap) {
        this.data = new float[cap];
        this.n = 0;
    }

    public FloatVec(float[] data) {
        this.data = (float[])data.clone();
        this.n = data.length;
    }

    public float get(int i) {
        if (i >= this.n) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.data[i];
    }

    public float set(int i, float x) {
        if (i >= this.n) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.data[i] = x;
        return x;
    }

    public float setGrow(int i, float x) {
        if (i >= this.n) {
            if (i >= this.data.length) {
                this.setCap((i + 1) * 2);
            }
            this.n = i + 1;
        }
        this.data[i] = x;
        return x;
    }

    public void add(float x) {
        this.setGrow(this.n, x);
    }

    public void multAll(float d) {
        int i = 0;
        while (i < this.n) {
            int n = i++;
            this.data[n] = this.data[n] * d;
        }
    }

    public void setCap(int cap) {
        if (cap < this.n) {
            throw new ArrayIndexOutOfBoundsException();
        }
        float[] newData = new float[cap];
        System.arraycopy(this.data, 0, newData, 0, this.n);
        this.data = newData;
    }

    public void trimToSize() {
        this.setCap(this.n);
    }

    public int size() {
        return this.n;
    }
}

