/*
 * Decompiled with CFR 0.152.
 */
package edu.pku.coli.pear.dag;

import edu.berkeley.nlp.util.StringUtils;
import edu.pku.coli.dualdecomp.GeneralizedCoordination;
import edu.pku.coli.pear.dag.PredicateArgumentAdjunctDAG;
import edu.pku.coli.pear.dag.tran.AbstractAction;
import edu.pku.coli.pear.dag.tran.TaggingAction;
import edu.pku.coli.pear.dag.tran.TwoListPopCrossCommaAction;
import fig.basic.Indexer;
import fig.basic.ListUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SentenceForDAGParsing {
    public static final String START_WORD = "#BOW#";
    public static final String ROOT_WORD = "#ROW#";
    public static final String END_WORD = "#EOW#";
    public static final String START_TAG = "#BOT#";
    public static final String ROOT_TAG = "#ROT#";
    public static final String END_TAG = "#EOT#";
    public static int START_WORD_INDEX;
    public static int ROOT_WORD_INDEX;
    public static int END_WORD_INDEX;
    public static int START_TAG_INDEX;
    public static int ROOT_TAG_INDEX;
    public static int END_TAG_INDEX;
    public static boolean escapedWordBracket;
    public static boolean escapedPOSBracket;
    public static boolean indexWords;
    public static Indexer<String> wordIndexer;
    public static Indexer<String> posIndexer;
    private String[] words;
    private String[] poss;
    private String[] lemmas;
    private String[] sense;
    private int[] wordIndices;
    private int[] posIndices;
    private int[] lemmaIndices;
    public PredicateArgumentAdjunctDAG syntaxTree;
    List<PredicateArgumentAdjunctDAG> moreSyntaxTrees;
    PredicateArgumentAdjunctDAG goldDAG;
    PredicateArgumentAdjunctDAG sysDAG;
    AbstractAction actionHandle;
    List<AbstractAction> goldActions;
    private String id;
    List<GeneralizedCoordination> generalCoordinations;

    static {
        escapedWordBracket = false;
        escapedPOSBracket = false;
        indexWords = true;
        wordIndexer = new Indexer<String>(ListUtils.newList(START_WORD, END_WORD, ROOT_WORD));
        posIndexer = new Indexer<String>(ListUtils.newList(START_TAG, END_TAG, ROOT_TAG));
    }

    public SentenceForDAGParsing(String[] ws, String[] ps, PredicateArgumentAdjunctDAG dag) {
        this(ws, new String[0], ps, dag);
    }

    public SentenceForDAGParsing(String[] ws, String[] lms, String[] ps, PredicateArgumentAdjunctDAG dag) {
        START_WORD_INDEX = wordIndexer.getIndex(START_WORD);
        ROOT_WORD_INDEX = wordIndexer.getIndex(ROOT_WORD);
        END_WORD_INDEX = wordIndexer.getIndex(END_WORD);
        START_TAG_INDEX = wordIndexer.getIndex(START_TAG);
        ROOT_TAG_INDEX = wordIndexer.getIndex(ROOT_TAG);
        END_TAG_INDEX = wordIndexer.getIndex(END_TAG);
        this.words = new String[0];
        this.poss = new String[0];
        this.lemmas = new String[0];
        this.sense = new String[0];
        this.wordIndices = null;
        this.posIndices = null;
        this.lemmaIndices = null;
        this.syntaxTree = null;
        this.goldDAG = null;
        this.sysDAG = null;
        this.actionHandle = null;
        this.goldActions = null;
        if (ws.length != ps.length) {
            throw new RuntimeException("Words and poss not same length:\n" + Arrays.toString(ws) + "\n" + Arrays.toString(ps));
        }
        this.words = ws;
        this.lemmas = lms;
        this.poss = ps;
        this.goldDAG = dag;
        int i = 0;
        while (i < ws.length) {
            String p;
            String w = SentenceForDAGParsing.toEscapedBracket(ws[i], false);
            if (w != ws[i]) {
                ws[i] = w;
                escapedWordBracket = true;
            }
            if ((p = SentenceForDAGParsing.toEscapedBracket(ps[i], true)) != ps[i]) {
                ps[i] = p;
                escapedPOSBracket = true;
            }
            ++i;
        }
        if (indexWords) {
            this.wordIndices = new int[this.words.length];
            int k = 0;
            while (k < this.wordIndices.length) {
                this.wordIndices[k] = wordIndexer.getIndex(this.words[k]);
                ++k;
            }
            this.lemmaIndices = new int[this.lemmas.length];
            k = 0;
            while (k < this.lemmaIndices.length) {
                this.lemmaIndices[k] = wordIndexer.getIndex(this.words[k]);
                ++k;
            }
            this.posIndices = new int[this.poss.length];
            k = 0;
            while (k < this.posIndices.length) {
                this.posIndices[k] = posIndexer.getIndex(this.poss[k]);
                ++k;
            }
        }
    }

    public SentenceForDAGParsing(String[] ws, String[] ps, PredicateArgumentAdjunctDAG dag, AbstractAction ah) {
        this(ws, new String[0], ps, dag, ah);
    }

    public SentenceForDAGParsing(String[] ws, String[] ls, String[] ps, PredicateArgumentAdjunctDAG dag, AbstractAction ah) {
        this(ws, ls, ps, dag);
        this.actionHandle = ah;
        if (this.actionHandle instanceof TwoListPopCrossCommaAction) {
            dag._types = new ArrayList<String>();
            dag._types.add("ROOT");
            String[] stringArray = ws;
            int n = ws.length;
            int n2 = 0;
            while (n2 < n) {
                String w = stringArray[n2];
                dag._types.add(w);
                ++n2;
            }
        }
        this.goldActions = this.actionHandle instanceof TaggingAction ? ((TaggingAction)this.actionHandle).getOracleActions(ps) : this.actionHandle.getOracleActions(this.goldDAG);
    }

    public SentenceForDAGParsing(String[] ws, String[] ps, PredicateArgumentAdjunctDAG dag, PredicateArgumentAdjunctDAG tree) {
        this(ws, new String[0], ps, dag, tree);
    }

    public SentenceForDAGParsing(String[] ws, String[] ls, String[] ps, PredicateArgumentAdjunctDAG dag, PredicateArgumentAdjunctDAG tree) {
        this(ws, ls, ps, dag);
        this.syntaxTree = tree;
    }

    public SentenceForDAGParsing(String[] ws, String[] ps, PredicateArgumentAdjunctDAG dag, PredicateArgumentAdjunctDAG tree, AbstractAction ah) {
        this(ws, new String[0], ps, dag, tree, ah);
    }

    public SentenceForDAGParsing(String[] ws, String[] ls, String[] ps, PredicateArgumentAdjunctDAG dag, PredicateArgumentAdjunctDAG tree, AbstractAction ah) {
        this(ws, ls, ps, dag, ah);
        this.syntaxTree = tree;
    }

    public SentenceForDAGParsing(String id, String[] ws, String[] ls, String[] ps, PredicateArgumentAdjunctDAG dag) {
        this(ws, ls, ps, dag);
        this.id = id;
    }

    public SentenceForDAGParsing(String id, String[] ws, String[] ls, String[] ps, String[] sense, PredicateArgumentAdjunctDAG dag) {
        this(ws, ls, ps, dag);
        this.id = id;
        if (sense != null) {
            this.setSense(sense);
        }
    }

    public SentenceForDAGParsing(String id, String[] ws, String[] ls, String[] ps, PredicateArgumentAdjunctDAG dag, PredicateArgumentAdjunctDAG tree) {
        this(ws, ls, ps, dag, tree);
        this.id = id;
    }

    public SentenceForDAGParsing(String id, String[] ws, String[] ls, String[] ps, PredicateArgumentAdjunctDAG dag, PredicateArgumentAdjunctDAG tree, AbstractAction ah) {
        this(ws, ls, ps, dag, tree, ah);
        this.id = id;
    }

    public static SentenceForDAGParsing generateSenenceForTagging(String[] ws, String[] ps, AbstractAction ah) {
        SentenceForDAGParsing sent = new SentenceForDAGParsing(ws, ps, null);
        sent.actionHandle = ah;
        sent.goldActions = ((TaggingAction)sent.actionHandle).getOracleActions(ps);
        return sent;
    }

    public List<AbstractAction> getGoldActions() {
        return this.goldActions;
    }

    public int numOfWords() {
        return this.words.length;
    }

    public int getKthWordIndex(int posi) {
        if (posi < 0) {
            return START_WORD_INDEX;
        }
        if (posi == 0) {
            return ROOT_WORD_INDEX;
        }
        if (posi > this.wordIndices.length) {
            return END_WORD_INDEX;
        }
        return this.wordIndices[posi - 1];
    }

    public int getKthPosIndex(int posi) {
        if (posi < 0) {
            return START_TAG_INDEX;
        }
        if (posi == 0) {
            return ROOT_TAG_INDEX;
        }
        if (posi > this.posIndices.length) {
            return END_TAG_INDEX;
        }
        return this.posIndices[posi - 1];
    }

    public String getKthWord(int posi) {
        if (posi < 0) {
            return START_WORD;
        }
        if (posi == 0) {
            return ROOT_WORD;
        }
        if (posi > this.words.length) {
            return END_WORD;
        }
        return this.words[posi - 1];
    }

    public String getKthPos(int posi) {
        if (posi < 0) {
            return START_TAG;
        }
        if (posi == 0) {
            return ROOT_TAG;
        }
        if (posi > this.poss.length) {
            return END_TAG;
        }
        return this.poss[posi - 1];
    }

    public void setKthWord(int posi, String w) {
        if (posi >= 0 && posi < this.words.length) {
            this.words[posi] = w;
        }
    }

    public PredicateArgumentAdjunctDAG getGoldDAG() {
        return this.goldDAG;
    }

    public PredicateArgumentAdjunctDAG getPredictedDAG() {
        return this.sysDAG;
    }

    public void setPredictedDAG(PredicateArgumentAdjunctDAG dag) {
        this.sysDAG = dag;
    }

    public PredicateArgumentAdjunctDAG getSyntaxTree() {
        return this.syntaxTree;
    }

    public String toSentenceString() {
        return StringUtils.join((Object[])this.words);
    }

    public String id() {
        return this.id;
    }

    public String[] words() {
        return this.words;
    }

    public String[] lemmas() {
        return this.lemmas;
    }

    public String[] tags() {
        return this.poss;
    }

    public int[] wordIndices() {
        return this.wordIndices;
    }

    public int[] lemmaIndices() {
        return this.lemmaIndices;
    }

    public int[] possIndices() {
        return this.posIndices;
    }

    public SentenceForDAGParsing reverse() {
        return this.reverse(true);
    }

    public SentenceForDAGParsing reverse(boolean generateNewActions) {
        PredicateArgumentAdjunctDAG reversedTree;
        PredicateArgumentAdjunctDAG predicateArgumentAdjunctDAG = reversedTree = this.syntaxTree == null ? null : this.syntaxTree.reverse();
        if (this.actionHandle == null || !generateNewActions) {
            return new SentenceForDAGParsing(this.id, this.reverseStrings(this.words), this.reverseStrings(this.lemmas), this.reverseStrings(this.poss), this.goldDAG.reverse(), reversedTree);
        }
        return new SentenceForDAGParsing(this.id, this.reverseStrings(this.words), this.reverseStrings(this.lemmas), this.reverseStrings(this.poss), this.goldDAG.reverse(), reversedTree, this.actionHandle);
    }

    private String[] reverseStrings(String[] array) {
        if (array == null) {
            return null;
        }
        String[] reversed = new String[array.length];
        int i = 0;
        while (i < array.length) {
            reversed[i] = array[array.length - i - 1];
            ++i;
        }
        return reversed;
    }

    public String toString() {
        return StringUtils.join((Object[])this.words);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SentenceForDAGParsing)) {
            return false;
        }
        SentenceForDAGParsing sent = (SentenceForDAGParsing)o;
        if (!Arrays.equals(this.words, sent.words)) {
            return false;
        }
        if (!Arrays.equals(this.lemmas, sent.lemmas)) {
            return false;
        }
        if (!Arrays.equals(this.poss, sent.poss)) {
            return false;
        }
        if (!this.goldDAG.equals(sent.goldDAG)) {
            return false;
        }
        return !(this.syntaxTree == null ? sent.syntaxTree != null : !this.syntaxTree.equals(sent.syntaxTree));
    }

    public static String toEscapedBracket(String word, boolean isPOS) {
        if ("(".equals(word)) {
            if (isPOS) {
                return "LRB";
            }
            return "-LRB-";
        }
        if ("[".equals(word)) {
            return "-LSB-";
        }
        if ("{".equals(word)) {
            return "-LCB-";
        }
        if (")".equals(word)) {
            if (isPOS) {
                return "RRB";
            }
            return "-RRB-";
        }
        if ("]".equals(word)) {
            return "-RSB-";
        }
        if ("}".equals(word)) {
            return "-RCB-";
        }
        return word;
    }

    public static String unescapeBracket(String word) {
        if ("-LRB-".equals(word) || "LRB".equals(word)) {
            return "(";
        }
        if ("-LSB-".equals(word)) {
            return "[";
        }
        if ("-LCB-".equals(word)) {
            return "{";
        }
        if ("-RRB-".equals(word) || "RRB".equals(word)) {
            return ")";
        }
        if ("-RSB-".equals(word)) {
            return "]";
        }
        if ("-RCB-".equals(word)) {
            return "}";
        }
        return word;
    }

    public void setGeneralCoordinations(List<GeneralizedCoordination> list) {
        this.generalCoordinations = list;
    }

    public List<GeneralizedCoordination> getGeneralCoordinations() {
        return this.generalCoordinations;
    }

    public void setMoreSyntaxTrees(List<PredicateArgumentAdjunctDAG> trees) {
        this.moreSyntaxTrees = trees;
    }

    public List<PredicateArgumentAdjunctDAG> getMoreSyntaxTrees() {
        return this.moreSyntaxTrees;
    }

    public String[] getSense() {
        return this.sense;
    }

    public void setSense(String[] sense) {
        this.sense = sense;
    }
}

