/*
 * Decompiled with CFR 0.152.
 */
package edu.pku.coli.dualdecomp;

import edu.pku.coli.dualdecomp.AbstractDecoder;
import edu.pku.coli.dualdecomp.GeneralizedCoordination;
import edu.pku.coli.pear.dag.PredicateArgumentAdjunctDAG;
import edu.pku.coli.pear.dag.SentenceForDAGParsing;
import fig.basic.Pair;
import java.util.ArrayList;
import java.util.List;

public class GeneralizedCoordinationDecoder
extends AbstractDecoder {
    private static final long serialVersionUID = -8432874095225398420L;
    boolean moreMaxIter = false;
    transient double[] scores;

    public GeneralizedCoordinationDecoder() {
        this.featureExtractor = new FeatureExtractor();
    }

    @Override
    public void train(List<SentenceForDAGParsing> trainset, List<SentenceForDAGParsing> devset) {
        if (!this.moreMaxIter) {
            this.maxIter *= 10;
            this.moreMaxIter = true;
        }
        super.train(trainset, devset);
    }

    @Override
    public SentenceForDAGParsing toDAGSentence(SentenceForDAGParsing sent, int[][] var) {
        int sentLen = sent.numOfWords();
        PredicateArgumentAdjunctDAG sys = new PredicateArgumentAdjunctDAG(sentLen);
        int i = 0;
        while (i <= sentLen) {
            int j = 0;
            while (j <= sentLen) {
                if (var[i][j] == 1) {
                    sys.addArc(i, j, "X");
                }
                ++j;
            }
            ++i;
        }
        sent.setPredictedDAG(sys);
        return sent;
    }

    @Override
    public int[][] toVariable(SentenceForDAGParsing sent) {
        int sentLen = sent.numOfWords();
        int[][] var = new int[sentLen + 1][sentLen + 1];
        PredicateArgumentAdjunctDAG dag = sent.getGoldDAG();
        for (Pair<Integer, Integer> arc : dag.toUnlabeledPairs()) {
            var[arc.getFirst().intValue()][arc.getSecond().intValue()] = 1;
        }
        return var;
    }

    @Override
    public int[][] decodeAfterScoring(double[][] additionalWeight) {
        SentenceForDAGParsing sent = this.curSent;
        int sentLen = sent.numOfWords();
        int[][] var = new int[sentLen + 1][sentLen + 1];
        List<GeneralizedCoordination> coordinates = sent.getGeneralCoordinations();
        double totalScore = 0.0;
        int i = 0;
        while (i < coordinates.size()) {
            GeneralizedCoordination coord = coordinates.get(i);
            double score = this.scores[i];
            int wordPosition = coord.getWordPosition();
            if (coord.direction == GeneralizedCoordination.Direction.WORD2COORD) {
                for (int arg : coord.coordPositions) {
                    score += additionalWeight[wordPosition][arg];
                }
            } else {
                for (int pred : coord.coordPositions) {
                    score += additionalWeight[pred][wordPosition];
                }
            }
            if (score > 0.0) {
                if (coord.direction == GeneralizedCoordination.Direction.WORD2COORD) {
                    for (int arg : coord.getCoordPositions()) {
                        var[coord.wordPosition][arg] = 1;
                    }
                } else {
                    for (int pred : coord.getCoordPositions()) {
                        var[pred][coord.wordPosition] = 1;
                    }
                }
                totalScore += score;
            }
            ++i;
        }
        return var;
    }

    @Override
    public void scoreFeats(float[] param) {
        SentenceForDAGParsing sent = this.curSent;
        FeatureExtractor fe = (FeatureExtractor)this.featureExtractor;
        int sentLen = sent.numOfWords();
        List<GeneralizedCoordination> coordinates = sent.getGeneralCoordinations();
        this.scores = new double[coordinates.size()];
        int i = 0;
        while (i < coordinates.size()) {
            GeneralizedCoordination coord = coordinates.get(i);
            this.scores[i] = fe.scoreCoordinations(sent, coord, param);
            ++i;
        }
    }

    class FeatureExtractor
    extends AbstractDecoder.FeatureExtractor {
        private static final long serialVersionUID = 8435600829505156597L;

        FeatureExtractor() {
        }

        @Override
        List<Integer> extract(SentenceForDAGParsing sent, boolean predicted) {
            ArrayList<Integer> ret = new ArrayList<Integer>();
            PredicateArgumentAdjunctDAG dag = sent.getGoldDAG();
            if (predicted) {
                dag = sent.getPredictedDAG();
            }
            List<GeneralizedCoordination> coords = sent.getGeneralCoordinations();
            for (GeneralizedCoordination coord : coords) {
                boolean arc = true;
                if (coord.direction == GeneralizedCoordination.Direction.WORD2COORD) {
                    for (int arg : coord.getCoordPositions()) {
                        if (dag.containsArc(coord.getWordPosition(), arg)) continue;
                        arc = false;
                        break;
                    }
                } else {
                    for (int pred : coord.getCoordPositions()) {
                        if (dag.containsArc(pred, coord.getWordPosition())) continue;
                        arc = false;
                        break;
                    }
                }
                if (!arc) continue;
                ret.addAll(this.predArgFeats(sent, coord));
                ret.addAll(this.coordFeats(sent, coord));
            }
            return ret;
        }

        double scoreCoordinations(SentenceForDAGParsing sent, GeneralizedCoordination coord, float[] param) {
            double score = 0.0;
            score += GeneralizedCoordinationDecoder.this.score(this.predArgFeats(sent, coord), param);
            return score += GeneralizedCoordinationDecoder.this.score(this.coordFeats(sent, coord), param);
        }

        private List<Integer> coordFeats(SentenceForDAGParsing sent, GeneralizedCoordination coord) {
            ArrayList<Integer> ret = new ArrayList<Integer>();
            int ncoords = coord.getCoords().size();
            int word = sent.getKthWordIndex(coord.getWordPosition());
            int pos = sent.getKthPosIndex(coord.getWordPosition());
            ArrayList<Integer> coordWords = new ArrayList<Integer>();
            ArrayList<Integer> coordPoss = new ArrayList<Integer>();
            for (int p : coord.getCoordPositions()) {
                coordWords.add(sent.getKthWordIndex(p));
                coordPoss.add(sent.getKthPosIndex(p));
            }
            int n = 1024;
            if (coord.direction == GeneralizedCoordination.Direction.COORD2WORD) {
                n = 2048;
            }
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, word, pos, (int)((Integer)coordWords.get(0)), (int)((Integer)coordPoss.get(0)), (int)((Integer)coordWords.get(ncoords - 1)), (int)((Integer)coordPoss.get(ncoords - 1))));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, word, pos, (int)((Integer)coordWords.get(0)), (int)((Integer)coordPoss.get(0)), (int)((Integer)coordPoss.get(ncoords - 1))));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, word, pos, (int)((Integer)coordPoss.get(0)), (int)((Integer)coordWords.get(ncoords - 1)), (int)((Integer)coordPoss.get(ncoords - 1))));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pos, (int)((Integer)coordWords.get(0)), (int)((Integer)coordPoss.get(0)), (int)((Integer)coordWords.get(ncoords - 1)), (int)((Integer)coordPoss.get(ncoords - 1))));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, word, pos, (int)((Integer)coordPoss.get(0)), (int)((Integer)coordPoss.get(ncoords - 1))));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pos, (int)((Integer)coordWords.get(0)), (int)((Integer)coordPoss.get(0)), (int)((Integer)coordPoss.get(ncoords - 1))));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pos, (int)((Integer)coordPoss.get(0)), (int)((Integer)coordWords.get(ncoords - 1)), (int)((Integer)coordPoss.get(ncoords - 1))));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pos, (int)((Integer)coordPoss.get(0)), (int)((Integer)coordPoss.get(ncoords - 1))));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, word, (int)((Integer)coordWords.get(0)), (int)((Integer)coordWords.get(ncoords - 1))));
            int i = 1;
            while (i < ncoords) {
                ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, word, pos, (int)((Integer)coordWords.get(0)), (int)((Integer)coordPoss.get(0)), (int)((Integer)coordWords.get(ncoords - 1)), (int)((Integer)coordPoss.get(ncoords - 1))));
                ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, word, pos, (int)((Integer)coordWords.get(0)), (int)((Integer)coordPoss.get(0)), (int)((Integer)coordPoss.get(ncoords - 1))));
                ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, word, pos, (int)((Integer)coordPoss.get(0)), (int)((Integer)coordWords.get(ncoords - 1)), (int)((Integer)coordPoss.get(ncoords - 1))));
                ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pos, (int)((Integer)coordWords.get(0)), (int)((Integer)coordPoss.get(0)), (int)((Integer)coordWords.get(ncoords - 1)), (int)((Integer)coordPoss.get(ncoords - 1))));
                ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, word, pos, (int)((Integer)coordPoss.get(0)), (int)((Integer)coordPoss.get(ncoords - 1))));
                ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pos, (int)((Integer)coordWords.get(0)), (int)((Integer)coordPoss.get(0)), (int)((Integer)coordPoss.get(ncoords - 1))));
                ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pos, (int)((Integer)coordPoss.get(0)), (int)((Integer)coordWords.get(ncoords - 1)), (int)((Integer)coordPoss.get(ncoords - 1))));
                ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pos, (int)((Integer)coordPoss.get(0)), (int)((Integer)coordPoss.get(ncoords - 1))));
                ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, word, (int)((Integer)coordWords.get(0)), (int)((Integer)coordWords.get(ncoords - 1))));
                ++i;
            }
            return ret;
        }

        private List<Integer> predArgFeats(SentenceForDAGParsing sent, GeneralizedCoordination coord) {
            ArrayList<Integer> ret = new ArrayList<Integer>();
            int wordPosition = coord.wordPosition;
            if (coord.direction == GeneralizedCoordination.Direction.WORD2COORD) {
                for (int arg : coord.coordPositions) {
                    ret.addAll(this.predArgFeats(sent, wordPosition, arg));
                }
            } else {
                for (int pred : coord.coordPositions) {
                    ret.addAll(this.predArgFeats(sent, pred, wordPosition));
                }
            }
            return ret;
        }

        private List<Integer> predArgFeats(SentenceForDAGParsing sent, int predicate, int argument) {
            ArrayList<Integer> ret = new ArrayList<Integer>();
            int n = 42;
            int curWord = sent.getKthWordIndex(predicate);
            int curPos = sent.getKthPosIndex(predicate);
            int preCurWord = sent.getKthWordIndex(predicate - 1);
            int postCurWord = sent.getKthWordIndex(predicate + 1);
            int preCurPos = sent.getKthPosIndex(predicate - 1);
            int postCurPos = sent.getKthPosIndex(predicate + 1);
            int argumentWord = sent.getKthWordIndex(argument);
            int argumentPos = sent.getKthWordIndex(argument);
            int preArgumentWord = sent.getKthWordIndex(argument - 1);
            int postArgumentWord = sent.getKthWordIndex(argument + 1);
            int preArgumentPos = sent.getKthPosIndex(argument - 1);
            int postArgumentPos = sent.getKthPosIndex(argument + 1);
            int distCur = GeneralizedCoordinationDecoder.this.distMap(predicate - argument);
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, argumentWord, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, argumentPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, argumentWord, argumentPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, curWord, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, curPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, curWord, curPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, preArgumentWord, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, preArgumentPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, preArgumentWord, preArgumentPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, preCurWord, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, preCurPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, preCurWord, preCurPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, postArgumentWord, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, postArgumentPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, postArgumentWord, postArgumentPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, postCurWord, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, postCurPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, postCurWord, postCurPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, argumentWord, argumentPos, curWord, curPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, argumentWord, argumentPos, curWord, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, argumentWord, argumentPos, curPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, argumentWord, curWord, curPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, argumentPos, curWord, curPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, argumentWord, curWord, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, argumentPos, curPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, argumentWord, argumentPos, preArgumentWord, preArgumentPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, argumentWord, argumentPos, preArgumentPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, argumentPos, preArgumentWord, preArgumentPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, argumentPos, preArgumentPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, argumentWord, argumentPos, postArgumentWord, postArgumentPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, argumentWord, argumentPos, postArgumentPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, argumentPos, postArgumentWord, postArgumentPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, argumentPos, postArgumentPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, curWord, curPos, preCurWord, preCurPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, curWord, curPos, preCurPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, curPos, preCurWord, preCurPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, curPos, preCurPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, curWord, curPos, postCurWord, postCurPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, curWord, curPos, postCurPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, curPos, postCurWord, postCurPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, curPos, postCurPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, curWord, curPos, preArgumentWord, preArgumentPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, curWord, curPos, preArgumentPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, curPos, preArgumentWord, preArgumentPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, curPos, preArgumentPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, curWord, curPos, postArgumentWord, postArgumentPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, curWord, curPos, postArgumentPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, curPos, postArgumentWord, postArgumentPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, curPos, postArgumentPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, argumentWord, argumentPos, preCurWord, preCurPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, argumentWord, argumentPos, preCurPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, argumentPos, preCurWord, preCurPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, argumentPos, preCurPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, argumentWord, argumentPos, postCurWord, postCurPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, argumentWord, argumentPos, postCurPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, argumentPos, postCurWord, postCurPos, distCur));
            ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, argumentPos, postCurPos, distCur));
            PredicateArgumentAdjunctDAG tree = sent.getSyntaxTree();
            if (GeneralizedCoordinationDecoder.this.usePathFeat && tree != null && !tree.isEmpty()) {
                char p;
                int pos;
                PredicateArgumentAdjunctDAG.ArcInfo parentArc;
                ArrayList<Integer> curToRoot = new ArrayList<Integer>();
                ArrayList<Integer> dependentToRoot = new ArrayList<Integer>();
                int t = predicate;
                while ((parentArc = tree.getOneParent(t)) != null) {
                    curToRoot.add(t);
                    t = parentArc.index;
                }
                curToRoot.add(t);
                t = argument;
                while ((parentArc = tree.getOneParent(t)) != null) {
                    dependentToRoot.add(t);
                    t = parentArc.index;
                }
                dependentToRoot.add(t);
                int leastCommonAncestor = 1;
                while (leastCommonAncestor <= curToRoot.size() && leastCommonAncestor <= dependentToRoot.size() && curToRoot.get(curToRoot.size() - leastCommonAncestor) == dependentToRoot.get(dependentToRoot.size() - leastCommonAncestor)) {
                    ++leastCommonAncestor;
                }
                int pathPoss = n++;
                int pathP = n++;
                int i = 0;
                while (i <= curToRoot.size() - leastCommonAncestor) {
                    pos = sent.getKthPosIndex((Integer)curToRoot.get(i));
                    p = sent.getKthPos((Integer)curToRoot.get(i)).charAt(0);
                    pathPoss = 31 * pathPoss + pos;
                    pathP = 31 * pathP + p;
                    ++i;
                }
                pathPoss = -pathPoss;
                pathP = -pathP;
                if (leastCommonAncestor > 1) {
                    int pos2 = sent.getKthPosIndex((Integer)curToRoot.get(curToRoot.size() - leastCommonAncestor + 1));
                    char p2 = sent.getKthPos((Integer)curToRoot.get(curToRoot.size() - leastCommonAncestor + 1)).charAt(0);
                    pathPoss = 31 * pathPoss + pos2;
                    pathPoss = 31 * pathPoss + SentenceForDAGParsing.posIndexer.size();
                    pathP = 31 * pathP + p2;
                    pathP = 31 * pathP + 255;
                }
                i = dependentToRoot.size() - leastCommonAncestor;
                while (i >= 0) {
                    pos = sent.getKthPosIndex((Integer)dependentToRoot.get(i));
                    p = sent.getKthPos((Integer)dependentToRoot.get(i)).charAt(0);
                    pathPoss = 31 * pathPoss + pos;
                    pathP = 31 * pathP + p;
                    --i;
                }
                ret.add(GeneralizedCoordinationDecoder.this.hashInts(pathPoss));
                ret.add(GeneralizedCoordinationDecoder.this.hashInts(pathP));
                ret.add(GeneralizedCoordinationDecoder.this.hashInts(pathPoss, distCur));
                ret.add(GeneralizedCoordinationDecoder.this.hashInts(pathP, distCur));
                ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathPoss, argumentWord, argumentPos, curWord, curPos, distCur));
                ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathPoss, argumentWord, argumentPos, curWord, distCur));
                ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathPoss, argumentWord, argumentPos, curPos, distCur));
                ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathPoss, argumentWord, curWord, curPos, distCur));
                ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathPoss, argumentPos, curWord, curPos, distCur));
                ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathPoss, argumentWord, curWord, distCur));
                ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathPoss, argumentPos, curPos, distCur));
                ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathP, argumentWord, argumentPos, curWord, curPos, distCur));
                ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathP, argumentWord, argumentPos, curWord, distCur));
                ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathP, argumentWord, argumentPos, curPos, distCur));
                ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathP, argumentWord, curWord, curPos, distCur));
                ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathP, argumentPos, curWord, curPos, distCur));
                ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathP, argumentWord, curWord, distCur));
                ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathP, argumentPos, curPos, distCur));
            }
            if (sent.getMoreSyntaxTrees() != null) {
                for (PredicateArgumentAdjunctDAG mtree : sent.getMoreSyntaxTrees()) {
                    char p;
                    int pos;
                    PredicateArgumentAdjunctDAG.ArcInfo parentArc;
                    ArrayList<Integer> curToRoot = new ArrayList<Integer>();
                    ArrayList<Integer> dependentToRoot = new ArrayList<Integer>();
                    ArrayList<String> stkTopToRootLabels = new ArrayList<String>();
                    ArrayList<String> queTopToRootLabels = new ArrayList<String>();
                    int t = predicate;
                    while ((parentArc = mtree.getOneParent(t)) != null) {
                        curToRoot.add(t);
                        stkTopToRootLabels.add(parentArc.label);
                        t = parentArc.index;
                    }
                    curToRoot.add(t);
                    t = argument;
                    while ((parentArc = mtree.getOneParent(t)) != null) {
                        dependentToRoot.add(t);
                        queTopToRootLabels.add(parentArc.label);
                        t = parentArc.index;
                    }
                    dependentToRoot.add(t);
                    int leastCommonAncestor = 1;
                    while (leastCommonAncestor <= curToRoot.size() && leastCommonAncestor <= dependentToRoot.size() && curToRoot.get(curToRoot.size() - leastCommonAncestor) == dependentToRoot.get(dependentToRoot.size() - leastCommonAncestor)) {
                        ++leastCommonAncestor;
                    }
                    int pathPoss = n++;
                    int pathP = n++;
                    int pathLab = n++;
                    int i = 0;
                    while (i <= curToRoot.size() - leastCommonAncestor) {
                        pos = sent.getKthPosIndex((Integer)curToRoot.get(i));
                        p = sent.getKthPos((Integer)curToRoot.get(i)).charAt(0);
                        pathPoss = 31 * pathPoss + pos;
                        pathP = 31 * pathP + p;
                        pathLab = 31 * pathLab + ((String)stkTopToRootLabels.get(i)).hashCode();
                        ++i;
                    }
                    pathPoss = -pathPoss;
                    pathP = -pathP;
                    pathLab = -pathLab;
                    if (leastCommonAncestor > 1) {
                        int pos3 = sent.getKthPosIndex((Integer)curToRoot.get(curToRoot.size() - leastCommonAncestor + 1));
                        char p3 = sent.getKthPos((Integer)curToRoot.get(curToRoot.size() - leastCommonAncestor + 1)).charAt(0);
                        pathPoss = 31 * pathPoss + pos3;
                        pathPoss = 31 * pathPoss + SentenceForDAGParsing.posIndexer.size();
                        pathP = 31 * pathP + p3;
                        pathP = 31 * pathP + 255;
                    }
                    i = dependentToRoot.size() - leastCommonAncestor;
                    while (i >= 0) {
                        pos = sent.getKthPosIndex((Integer)dependentToRoot.get(i));
                        p = sent.getKthPos((Integer)dependentToRoot.get(i)).charAt(0);
                        pathPoss = 31 * pathPoss + pos;
                        pathP = 31 * pathP + p;
                        pathLab = 31 * pathLab + ((String)queTopToRootLabels.get(i)).hashCode();
                        --i;
                    }
                    ret.add(GeneralizedCoordinationDecoder.this.hashInts(pathPoss));
                    ret.add(GeneralizedCoordinationDecoder.this.hashInts(pathP));
                    ret.add(GeneralizedCoordinationDecoder.this.hashInts(pathLab));
                    ret.add(GeneralizedCoordinationDecoder.this.hashInts(pathPoss, distCur));
                    ret.add(GeneralizedCoordinationDecoder.this.hashInts(pathP, distCur));
                    ret.add(GeneralizedCoordinationDecoder.this.hashInts(pathLab, distCur));
                    ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathPoss, argumentWord, argumentPos, curWord, curPos, distCur));
                    ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathPoss, argumentWord, argumentPos, curWord, distCur));
                    ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathPoss, argumentWord, argumentPos, curPos, distCur));
                    ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathPoss, argumentWord, curWord, curPos, distCur));
                    ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathPoss, argumentPos, curWord, curPos, distCur));
                    ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathPoss, argumentWord, curWord, distCur));
                    ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathPoss, argumentPos, curPos, distCur));
                    ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathP, argumentWord, argumentPos, curWord, curPos, distCur));
                    ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathP, argumentWord, argumentPos, curWord, distCur));
                    ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathP, argumentWord, argumentPos, curPos, distCur));
                    ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathP, argumentWord, curWord, curPos, distCur));
                    ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathP, argumentPos, curWord, curPos, distCur));
                    ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathP, argumentWord, curWord, distCur));
                    ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathP, argumentPos, curPos, distCur));
                    ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathLab, argumentWord, argumentPos, curWord, curPos, distCur));
                    ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathLab, argumentWord, argumentPos, curWord, distCur));
                    ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathLab, argumentWord, argumentPos, curPos, distCur));
                    ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathLab, argumentWord, curWord, curPos, distCur));
                    ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathLab, argumentPos, curWord, curPos, distCur));
                    ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathLab, argumentWord, curWord, distCur));
                    ret.add(GeneralizedCoordinationDecoder.this.hashInts(n++, pathLab, argumentPos, curPos, distCur));
                }
            }
            return ret;
        }
    }
}

