import torch
import torch.nn as nn
from tqdm import tqdm
from torch.autograd import Variable
from batch_generator import *
from torch.nn.utils.rnn import pack_padded_sequence, pad_packed_sequence
import time
from itertools import chain
from custom_rnn import *

# Hyper Parameters
embedding_size = 300
depth = 5
filter_size = 100
num_classes = 10
batch_size = 128
iter_size = 128
iter_num = batch_size // iter_size
num_epochs = 2
init_learning_rate = [0.001, 0.001, 0.001]
device=torch.device('cuda:0')
# train_filename='imdb_tr.pkl'
# test_filename='imdb_te.pkl'
# dic_filename='imdb_dic.pkl'

def get_maxlen(df_name):
    df = load_file(df_name)
    ls = df['len'].tolist()
    ls = [sum(l) for l in ls]
    return max(ls)

train_filename='../data/text_classification/ag/allen/train.pkl'
test_filename='../data/text_classification/ag/allen/test.pkl'
dic_filename='../data/text_classification/ag/allen/dictionary.pkl'
# glove_filename = None
glove_filename= '../data/text_classification/ag/allen/glove.pkl'

dic = load_file(dic_filename)
trdf = load_file(train_filename)
tedf = load_file(test_filename)
tr = BucketedDataIterator(trdf,dic, 20,char_embedding=False, max_len=1000)
te = BucketedDataIterator(tedf,dic,char_embedding=False,oov_index=tr.oov_index, max_len=1000)
vocab_size = tr.oov_index + 1
# maxlen = get_maxlen(train_filename)


def adjust_learning_rate(optimizer, lr):
    for param_group in optimizer.param_groups:
        param_group['lr'] = lr
    return optimizer


class Conv_Block(nn.Module):
    def __init__(self, inchannel, outchannel, kernel_size=3, shortcut=True):
        super(Conv_Block, self).__init__()
        self.padding = int((kernel_size - 1) / 2)
        self.kernel_size = kernel_size
        self.conv = nn.Sequential(nn.Conv1d(inchannel,outchannel,
                                            kernel_size=kernel_size,stride=1,padding=self.padding),
                                  nn.ReLU(),
                                  nn.Conv1d(outchannel,outchannel,
                                            kernel_size=kernel_size,stride=1,padding=self.padding))
        self.shortcut = shortcut
        if shortcut:
            self.shortcut_connection = nn.Sequential(nn.ReLU(),nn.Linear(inchannel,outchannel))

        # self.ln = nn.LayerNorm(outchannel)
        # self.transition = nn.Sequential(nn.Conv1d(inchannel,inchannel,kernel_size=1),nn.ReLU())
        self.reset_parameters()

    def reset_parameters(self):
        for i in self.conv:
            if isinstance(i,nn.Conv1d):
                # nn.init.normal_(i.weight,std=0.01)
                nn.init.kaiming_normal_(i.weight,nonlinearity='relu')
                # nn.init.xavier_normal_(i.weight, gain=math.sqrt(2))
                nn.init.constant_(i.bias, val=0)
        if self.shortcut:
            for i in self.shortcut_connection:
                if isinstance(i, nn.Linear):
                    # nn.init.normal_(i.weight, std=0.01)
                    nn.init.kaiming_normal_(i.weight, nonlinearity='relu')
                    # nn.init.xavier_normal_(i.weight, gain=math.sqrt(2))
                    nn.init.constant_(i.bias, val=0)
        # nn.init.kaiming_normal_(self.transition[0].weight, nonlinearity='relu')

    def forward(self, x):
        out = self.conv(x)
        if self.shortcut:
            sc = self.shortcut_connection(x.transpose(1,2)).transpose(1,2)
        out = 0.5*(sc + out)
        out = F.max_pool1d(out,self.kernel_size,2,self.padding)
        return out


class DPCNN(nn.Module):
    def __init__(self, embed_size, num_classes, filter_size=250,kernel_size=3,depth=7,shortcut=True):
        super(DPCNN, self).__init__()
        self.min_len = 2 ** depth
        self.embed_size = embed_size
        self.filter_size = filter_size
        self.kernel_size = kernel_size
        self.shortcut = shortcut
        self.depth = depth
        self.embed = Word_embedding(embed_size,vocab_size,glove_filename,dic,init='kaiming')
        self.convs = nn.ModuleList()
        for i in range(depth):
            if i ==0:
                self.convs.append(Conv_Block(embed_size, filter_size,kernel_size=kernel_size,shortcut=shortcut))
            else:
                self.convs.append(Conv_Block(filter_size, filter_size, kernel_size=kernel_size, shortcut=shortcut))
        self.fc = nn.Linear(filter_size,num_classes)
        self.reset_parameters()

    def reset_parameters(self):
        # nn.init.normal_(self.fc.weight, std=0.01)
        nn.init.kaiming_normal_(self.fc.weight,nonlinearity='linear')
        # nn.init.xavier_normal_(self.fc.weight)
        nn.init.constant_(self.fc.bias,val=0)

    def forward(self, x, seq_lengths):
        batch_size = x.size(0)
        x = self.embed(x) #[batch, length, embed_size]
        length = x.size(1)
        x = x.transpose(1,2)
        if length < self.min_len:
            zeros = torch.zeros(batch_size, self.embed_size, self.min_len).to(device)  # for contextualized
            zeros[:, :, :length] = x
            x = zeros
        for i in range(self.depth):
            x = self.convs[i](x)
        x = F.max_pool1d(x,x.size(2)).squeeze(2)
        out = self.fc(x)
        return out


# Train the Model
max_accuraries = []
for lr in init_learning_rate:
    tr.epochs = 0
    te.epochs = 0
    current_epochs = 0
    learning_rate = lr
    rnn = DPCNN(embedding_size, num_classes,depth=depth)
    rnn.to(device)
    print(count_parameters(rnn) - count_parameters(rnn.embed))
    # Loss and Optimizer
    criterion = nn.CrossEntropyLoss().to(device)
    optimizer = torch.optim.Adam(rnn.parameters(), lr=learning_rate)
    # optimizer = torch.optim.SGD(rnn.parameters(), lr=learning_rate,momentum=0.9, weight_decay=0.0001)
    while tr.epochs < num_epochs:
        t = time.time()
        adjust_learning_rate(optimizer, learning_rate)
        cnt = 0
        rnn.train()
        while current_epochs == tr.epochs:
            cnt += 1
            pbar = tqdm(range(100))
            loss_eval = 0
            total = 0
            correct = 0
            mse = 0
            for i in pbar:
                optimizer.zero_grad()
                for _ in range(iter_num):
                # training_process
                    x, lengths, labels = tr.next_batch(iter_size)
                    x = torch.from_numpy(x).long().to(device)
                    labels = torch.from_numpy(labels).to(device)
                    lengths = torch.from_numpy(np.array(lengths)).to(device)
                    # Forward + Backward + Optimize
                    outputs = rnn(x,lengths)
                    _, predicted = torch.max(outputs.data, 1)
                    loss = criterion(outputs, labels).to(device)
                    loss_eval += loss.data.item()
                    loss.backward()
                    total += labels.size(0)
                    correct += (predicted == labels).sum()
                    mse += ((predicted - labels)**2).sum()

                torch.nn.utils.clip_grad_norm_(rnn.parameters(), 5.0)
                optimizer.step()
                pbar.set_description("accuracy : %f mse : %f loss : %f epoch : %d iter : %d" % (
                100 * float(correct) / float(total),float(mse) / float(total), loss_eval / ((float(i) + 1) * iter_num), (current_epochs + 1),
                cnt))
                if current_epochs < tr.epochs:
                    pbar.close()
                    break
        learning_rate = learning_rate * 0.1
        i = 0
        total = 0
        correct = 0
        mse = 0
        pbar = tqdm()
        rnn.eval()
        while current_epochs == te.epochs:
            for _ in range(iter_num):
                x, lengths, labels = te.next_batch(iter_size//2)
                x = torch.from_numpy(x).long().to(device)
                lengths = torch.from_numpy(np.array(lengths)).to(device)
                labels = torch.from_numpy(labels).to(device)
                outputs = rnn(x,lengths)
                _, predicted = torch.max(outputs.data, 1)
                total += labels.size(0)
                correct += (predicted == labels).sum()
                mse += ((predicted - labels)**2).sum()
            pbar.set_description(
                "test accuracy : %f test MSE : %f time spent %f" % (100 * float(correct) / float(total), float(mse) / float(total), time.time() - t))
        pbar.close()
        acc = 100 * float(correct) / float(total)

        current_epochs += 1
        # print('Test Accuracy %f%%, time spent %f ' %(100*float(correct) / float(total), time.time()-t))
        t = time.time()
# for i in range(num_layers):
#     cell = rnn.lstm.get_cell(i)
#     print(cell.weight_ar.data)
