#!/bin/bash

OUTPATH=surug--01-0/task1

MODELS=`ls /hd4/data/sigmorphon2017/encdec/*high-unidir-128-0.npz \
    | sed 's/-0.npz//'`

mkdir -p $OUTPATH

for MODEL in $MODELS; do
    LANGNAME=`basename $MODEL | sed 's/-high-unidir-128//'`
    MODEL0="$MODEL"-0
    MODEL1="$MODEL"-1
    TESTFILE=all/task1/"$LANGNAME"-covered-test
    if [ -e $TESTFILE ]; then
        echo `basename $MODEL` $TESTFILE
        sem -j+0 python3 encdec/test_fb.py \
            --beam-size 10 \
            --model "$MODEL0","$MODEL1" \
            --input $TESTFILE \
            >$OUTPATH/"$LANGNAME"-high-out
    else
        echo "$TESTFILE does not exist, skipping"
    fi
done

sem --wait

