#!/bin/bash

#there are files such as leave{1-4}_{01|01|1}.out

#pass the srcfolder, the parser (cky), the folder to be evaluated

SRCFOLDER=$1
GOLDFOLDER=$2
PARSER=$3
FOLDER=$4

mkdir -p ${FOLDER}/evaluation

for alpha in 0.1 0.5 1.0
do
  for i in 1 2 3 4
  do
    if [ -f ${FOLDER}/leave${i}_${alpha}.out ]
    then
      echo Evaluating ${FOLDER}/leave${i}_${alpha}.out
      echo Turning it into a PCFG
      python ${SRCFOLDER}/grammars/generalize.py ${FOLDER}/leave${i}_${alpha}.out ${FOLDER}/evaluation/leave${i}_${alpha}.pcfg
      echo Running the evaluationscript, writing results to ${FOLDER}/leave${i}_${alpha}.eval
      python ${SRCFOLDER}/evaluation/evaluate.py ${PARSER} ${FOLDER}/evaluation/leave${i}_${alpha}.pcfg ${GOLDFOLDER}/gold${i}.yld ${GOLDFOLDER}/gold${i}.txt ${FOLDER}/evaluation/leave${i}_${alpha}.eval
    fi
  done
done
	
