/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.util;

public class Math {
    public static final double GOLDEN_RATIO = (1.0 + java.lang.Math.sqrt(5.0)) / 2.0;
    public static final double LN_2 = java.lang.Math.log(2.0);
    static final double INV_LN_2 = 1.0 / LN_2;
    public static final double LOG2_E = Math.log2(java.lang.Math.E);
    public static final long[] FIBONACCI_SEQUENCE = new long[]{1L, 2L, 3L, 5L, 8L, 13L, 21L, 34L, 55L, 89L, 144L, 233L, 377L, 610L, 987L, 1597L, 2584L, 4181L, 6765L, 10946L, 17711L, 28657L, 46368L, 75025L, 121393L, 196418L, 317811L, 514229L, 832040L, 1346269L, 2178309L, 3524578L, 5702887L, 0x8CCCC9L, 14930352L, 24157817L, 39088169L, 63245986L, 102334155L, 165580141L, 267914296L, 433494437L, 701408733L, 1134903170L, 1836311903L, 2971215073L, 4807526976L, 7778742049L, 12586269025L, 20365011074L, 32951280099L, 53316291173L, 86267571272L, 139583862445L, 225851433717L, 365435296162L, 591286729879L, 956722026041L, 1548008755920L, 2504730781961L, 4052739537881L, 6557470319842L, 10610209857723L, 17167680177565L, 27777890035288L, 44945570212853L, 72723460248141L, 117669030460994L, 190392490709135L, 308061521170129L, 498454011879264L, 806515533049393L, 1304969544928657L, 2111485077978050L, 3416454622906707L, 5527939700884757L, 8944394323791464L, 14472334024676221L, 23416728348467685L, 37889062373143906L, 61305790721611591L, 99194853094755497L, 160500643816367088L, 259695496911122585L, 420196140727489673L, 679891637638612258L, 1100087778366101931L, 1779979416004714189L, 2880067194370816120L, 4660046610375530309L, 7540113804746346429L};
    static double[] LANCZOS_COEFFS = new double[]{0.9999999999998099, 676.5203681218851, -1259.1392167224028, 771.3234287776531, -176.6150291621406, 12.507343278686905, -0.13857109526572012, 9.984369578019572E-6, 1.5056327351493116E-7};
    static double SQRT_2_PI = java.lang.Math.sqrt(java.lang.Math.PI * 2);
    static double NEGATIVE_DIGAMMA_1 = 0.5772156649015329;
    private static final double[] DIGAMMA_COEFFS = new double[]{0.30459198558715156, 0.7203797743918283, -0.12454959243861367, 0.027769457331927826, -0.0067762371439822455, 0.0017238755142247706, -4.481769906425293E-4, 1.1793660000155573E-4, -3.1253894280980133E-5, 8.317399701217328E-6, -2.2191427643780047E-6, 5.930226672932935E-7, -1.5863051191470655E-7, 4.2459203983193604E-8, -1.1369129616951114E-8, 3.045022172959317E-9, -8.156845508075315E-10, 2.1852324749975456E-10, -5.854649144168952E-11, 1.5686348450871205E-11, -4.2029496273143235E-12, 1.1261435719264908E-12, -3.017435363686028E-13, 8.085095525638953E-14, -2.1663779809421234E-14, 5.804763427133939E-15, -1.5553767189204733E-15, 4.1676108598040806E-16, -1.1167065064221317E-16};

    private Math() {
    }

    public static boolean isPrime(int num) {
        if (num < 2) {
            return false;
        }
        for (int i = 2; i <= num / 2; ++i) {
            if (num % i != 0) continue;
            return false;
        }
        return true;
    }

    public static int nextPrime(int num) {
        if (num < 2) {
            return 2;
        }
        int i = num + 1;
        while (!Math.isPrime(i)) {
            ++i;
        }
        return i;
    }

    public static double naturalLogToBase2Log(double x) {
        return x * INV_LN_2;
    }

    public static double logBase2ToNaturalLog(double x) {
        return x / LOG2_E;
    }

    public static double log2(double x) {
        return Math.naturalLogToBase2Log(java.lang.Math.log(x));
    }

    public static int byteAsUnsigned(byte b) {
        return b >= 0 ? b : 256 + b;
    }

    public static double log2Factorial(long n) {
        if (n < 0L) {
            String msg = "Factorials only defined for non-negative arguments. Found argument=" + n;
            throw new IllegalArgumentException(msg);
        }
        double sum = 0.0;
        for (long i = 1L; i <= n; ++i) {
            sum += Math.log2(i);
        }
        return sum;
    }

    public static double sum(double ... xs) {
        double sum = 0.0;
        for (int i = 0; i < xs.length; ++i) {
            sum += xs[i];
        }
        return sum;
    }

    public static double minimum(double ... xs) {
        if (xs.length == 0) {
            return Double.NaN;
        }
        double min = xs[0];
        for (int i = 1; i < xs.length; ++i) {
            if (!(xs[i] < min)) continue;
            min = xs[i];
        }
        return min;
    }

    public static double maximum(double ... xs) {
        if (xs.length == 0) {
            return Double.NaN;
        }
        double max = xs[0];
        for (int i = 1; i < xs.length; ++i) {
            if (!(xs[i] > max)) continue;
            max = xs[i];
        }
        return max;
    }

    public static double log2BinomialCoefficient(long n, long m) {
        return Math.log2(n) - Math.log2(m) - Math.log2(n - m);
    }

    @Deprecated
    public static void assertFiniteNonNegative(String label, double x) {
        if (x < 0.0 || Double.isNaN(x) || Double.isInfinite(x)) {
            String msg = label + " must be finite and non-negative." + " Found " + label + "=" + x;
            throw new IllegalArgumentException(msg);
        }
    }

    public static double log2Gamma(double z) {
        if (z < 0.5) {
            return Math.log2(java.lang.Math.PI) - Math.log2(java.lang.Math.sin(java.lang.Math.PI * z)) - Math.log2Gamma(1.0 - z);
        }
        double result = 0.0;
        while (z > 1.5) {
            result += Math.log2(z - 1.0);
            z -= 1.0;
        }
        return result + Math.log2(Math.lanczosGamma(z));
    }

    static double lanczosGamma(double z) {
        double zMinus1 = z - 1.0;
        double x = LANCZOS_COEFFS[0];
        for (int i = 1; i < LANCZOS_COEFFS.length - 2; ++i) {
            x += LANCZOS_COEFFS[i] / (zMinus1 + (double)i);
        }
        double t = zMinus1 + (double)(LANCZOS_COEFFS.length - 2) + 0.5;
        return SQRT_2_PI * java.lang.Math.pow(t, zMinus1 + 0.5) * java.lang.Math.exp(-t) * x;
    }

    public static double digamma(double x) {
        if (x <= 0.0 && x == (double)((long)x)) {
            return Double.NaN;
        }
        double accum = 0.0;
        if (x < 0.0) {
            accum += java.lang.Math.PI / java.lang.Math.tan(java.lang.Math.PI * (1.0 - x));
            x = 1.0 - x;
        }
        if (x < 1.0) {
            while (x < 1.0) {
                double d = x;
                x = d + 1.0;
                accum -= 1.0 / d;
            }
        }
        if (x == 1.0) {
            return accum - NEGATIVE_DIGAMMA_1;
        }
        if (x == 2.0) {
            return accum + 1.0 - NEGATIVE_DIGAMMA_1;
        }
        if (x == 3.0) {
            return accum + 1.5 - NEGATIVE_DIGAMMA_1;
        }
        if (x > 3.0) {
            while (x > 3.0) {
                accum += 1.0 / (x -= 1.0);
            }
            return accum + Math.digamma(x);
        }
        double tNMinus1 = 1.0;
        double tN = x -= 2.0;
        double digamma = DIGAMMA_COEFFS[0] + DIGAMMA_COEFFS[1] * tN;
        for (int n = 2; n < DIGAMMA_COEFFS.length; ++n) {
            double tN1 = 2.0 * x * tN - tNMinus1;
            digamma += DIGAMMA_COEFFS[n] * tN1;
            tNMinus1 = tN;
            tN = tN1;
        }
        return accum + digamma;
    }

    public static double relativeAbsoluteDifference(double x, double y) {
        return Double.isInfinite(x) || Double.isInfinite(y) ? Double.POSITIVE_INFINITY : java.lang.Math.abs(x - y) / (java.lang.Math.abs(x) + java.lang.Math.abs(y));
    }

    public static double logSumOfExponentials(double[] xs) {
        if (xs.length == 1) {
            return xs[0];
        }
        double max = Math.maximum(xs);
        double sum = 0.0;
        for (int i = 0; i < xs.length; ++i) {
            if (xs[i] == Double.NEGATIVE_INFINITY) continue;
            sum += java.lang.Math.exp(xs[i] - max);
        }
        return max + java.lang.Math.log(sum);
    }

    public static double max(double ... xs) {
        if (xs.length == 0) {
            return Double.NaN;
        }
        double max = xs[0];
        for (int i = 1; i < xs.length; ++i) {
            max = java.lang.Math.max(max, xs[i]);
        }
        return max;
    }

    public static int sum(int ... xs) {
        int sum = 0;
        for (int i = 0; i < xs.length; ++i) {
            sum += xs[i];
        }
        return sum;
    }
}

