/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.matrix;

import com.aliasi.matrix.SparseFloatVector;
import com.aliasi.matrix.Vector;
import com.aliasi.util.Distance;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinkowskiDistance
implements Distance<Vector>,
Serializable {
    static final long serialVersionUID = -3492306373950488519L;
    int mOrder;

    public MinkowskiDistance(int order) {
        this.mOrder = order;
    }

    public int order() {
        return this.mOrder;
    }

    @Override
    public double distance(Vector v1, Vector v2) {
        if (v1.numDimensions() != v2.numDimensions()) {
            String msg = "Vectors must have same dimensions. v1.numDimensions()=" + v1.numDimensions() + " v2.numDimensions()=" + v2.numDimensions();
            throw new IllegalArgumentException(msg);
        }
        if (v1 instanceof SparseFloatVector && v2 instanceof SparseFloatVector) {
            return this.sparseDistance((SparseFloatVector)v1, (SparseFloatVector)v2);
        }
        double sum = 0.0;
        int i = v1.numDimensions();
        while (--i >= 0) {
            double absDiff = Math.abs(v1.value(i) - v2.value(i));
            sum += Math.pow(absDiff, this.mOrder);
        }
        return Math.pow(sum, 1.0 / (double)this.mOrder);
    }

    double sparseDistance(SparseFloatVector v1, SparseFloatVector v2) {
        double sum = 0.0;
        int index1 = 0;
        int index2 = 0;
        int[] keys1 = v1.mKeys;
        int[] keys2 = v2.mKeys;
        float[] vals1 = v1.mValues;
        float[] vals2 = v2.mValues;
        while (index1 < keys1.length && index2 < keys2.length) {
            int comp = keys1[index1] - keys2[index2];
            double diff = Math.abs(comp == 0 ? vals1[index1++] - vals2[index2++] : (comp < 0 ? vals1[index1++] : vals2[index2++]));
            sum += Math.pow(diff, this.mOrder);
        }
        while (index1 < keys1.length) {
            sum += Math.pow(Math.abs(vals1[index1]), this.mOrder);
            ++index1;
        }
        while (index2 < keys2.length) {
            sum += Math.pow(Math.abs(vals2[index2]), this.mOrder);
            ++index2;
        }
        return Math.pow(sum, 1.0 / (double)this.mOrder);
    }
}

