/*
 * Decompiled with CFR 0.152.
 */
package tsg.metrics;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import tsg.TSNodeLabel;
import tsg.metrics.MCP;
import tsg.metrics.MPD;
import tsg.metrics.MPP;
import tsg.metrics.MRuleProduct;
import tsg.metrics.MRuleSum;
import tsg.metrics.ParseMetricOptimizer;

public class MetricOptimizerArray {
    public static double[] lambdaValues = new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
    public static boolean runOnlyMPD = false;
    ParseMetricOptimizer[] MO;
    int lambdaValuesLength;
    int arrayLength;

    public static double format(double d) {
        return Double.parseDouble(MCP.lambdaFormat.format(d));
    }

    public static void setLambdaValues(double min, double max, double gap) {
        int length = (int)((max - min) / gap) + 1;
        lambdaValues = new double[length];
        double previous = MetricOptimizerArray.lambdaValues[0] = MetricOptimizerArray.format(min);
        int i = 1;
        while (i < length - 1) {
            MetricOptimizerArray.lambdaValues[i] = MetricOptimizerArray.format(previous += gap);
            ++i;
        }
        MetricOptimizerArray.lambdaValues[length - 1] = MetricOptimizerArray.format(previous + gap);
    }

    public MetricOptimizerArray() {
        if (runOnlyMPD) {
            this.arrayLength = 1;
            this.MO = new ParseMetricOptimizer[]{new MPD()};
            return;
        }
        this.lambdaValuesLength = lambdaValues.length;
        this.arrayLength = this.lambdaValuesLength + 4;
        this.MO = new ParseMetricOptimizer[this.arrayLength];
        int j = 0;
        int i = 0;
        while (i < this.lambdaValuesLength) {
            double lambda = lambdaValues[i];
            this.MO[j++] = new MCP(lambda);
            ++i;
        }
        this.MO[j++] = new MRuleSum();
        this.MO[j++] = new MRuleProduct();
        this.MO[j++] = new MPP();
        this.MO[j++] = new MPD();
    }

    public File[] makeFileOutputList(String fileNamePath, String dotExtension) {
        File[] result = new File[this.arrayLength];
        int i = 0;
        while (i < this.arrayLength) {
            result[i] = new File(String.valueOf(fileNamePath) + this.MO[i].identifier + dotExtension);
            ++i;
        }
        return result;
    }

    public String[] getIdentifiers() {
        String[] result = new String[this.arrayLength];
        int i = 0;
        while (i < this.arrayLength) {
            result[i] = this.MO[i].identifier;
            ++i;
        }
        return result;
    }

    public void appendResult(File[] fileList) throws Exception {
        int i = 0;
        while (i < this.arrayLength) {
            File outputFile = fileList[i];
            FileOutputStream out = new FileOutputStream(outputFile, true);
            PrintWriter pw = new PrintWriter(out);
            this.MO[i].prinBestTrees(pw);
            pw.close();
            out.close();
            ++i;
        }
    }

    public void prepareNextSentence(String[] lexicalItems) {
        ParseMetricOptimizer[] parseMetricOptimizerArray = this.MO;
        int n = this.MO.length;
        int n2 = 0;
        while (n2 < n) {
            ParseMetricOptimizer mo = parseMetricOptimizerArray[n2];
            mo.prepareNextSentence(lexicalItems);
            ++n2;
        }
    }

    public String[] getCurrentSentenceWords() {
        return this.MO[0].getCurrentSentenceWords();
    }

    public void addNewDerivation(TSNodeLabel tree, double prob) {
        ParseMetricOptimizer[] parseMetricOptimizerArray = this.MO;
        int n = this.MO.length;
        int n2 = 0;
        while (n2 < n) {
            ParseMetricOptimizer mo = parseMetricOptimizerArray[n2];
            mo.addNewDerivation(tree.clone(), prob);
            ++n2;
        }
    }

    public void storeCurrentBestParseTrees() throws Exception {
        ParseMetricOptimizer[] parseMetricOptimizerArray = this.MO;
        int n = this.MO.length;
        int n2 = 0;
        while (n2 < n) {
            ParseMetricOptimizer mo = parseMetricOptimizerArray[n2];
            mo.storeCurrentBestParseTrees();
            ++n2;
        }
    }
}

