/*
 * Decompiled with CFR 0.152.
 */
package tsg.corpora;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Scanner;
import java.util.TreeSet;
import settings.Parameters;
import tsg.TSNode;
import util.FileUtil;
import util.Utility;

public class ConstCorpusTiger
implements Serializable {
    private static final long serialVersionUID = 0L;
    public String corpusName;
    public List<TSNode> treeBank;
    public static String unknownTag = "*UNKNOWN*";
    public static String numberTag = "*NUMBER*";
    public static String anonimousLex = "*LEX*";
    public static String topTag = "TOP";

    public ConstCorpusTiger() {
        this.treeBank = new ArrayList<TSNode>();
    }

    public ConstCorpusTiger(String corpusName) {
        this.treeBank = new ArrayList<TSNode>();
        this.corpusName = corpusName;
    }

    public ConstCorpusTiger(File inputPath, String corpusName) {
        this.corpusName = corpusName;
        this.treeBank = new ArrayList<TSNode>();
        this.readInputFile(inputPath);
    }

    public static ConstCorpusTiger fromBinaryFile(File inputFile) {
        ConstCorpusTiger treeBank = new ConstCorpusTiger();
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(inputFile));
            treeBank = (ConstCorpusTiger)in.readObject();
        }
        catch (Exception e) {
            FileUtil.handleExceptions(e);
        }
        return treeBank;
    }

    public void toBinaryFile(File outputFile) {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(outputFile));
            out.writeObject(this);
        }
        catch (Exception e) {
            FileUtil.handleExceptions(e);
        }
    }

    public ConstCorpusTiger deepClone() {
        ConstCorpusTiger clone = new ConstCorpusTiger();
        clone.corpusName = this.corpusName;
        ListIterator<TSNode> i = this.treeBank.listIterator();
        while (i.hasNext()) {
            TSNode element = i.next();
            clone.treeBank.add(new TSNode(element));
        }
        return clone;
    }

    private void readInputFile(File inputFile) {
        if (inputFile.isDirectory()) {
            Object[] fileList = inputFile.listFiles();
            Arrays.sort(fileList);
            int i = 0;
            while (i < fileList.length) {
                this.readInputFile((File)fileList[i]);
                ++i;
            }
            return;
        }
        Scanner scan = FileUtil.getScanner(inputFile);
        int parenthesis = 0;
        String sentence = "";
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            if (line.indexOf("Drain") > 0) {
                System.out.print("");
            }
            line = line.replaceAll("\\$\\(", "\\$.");
            sentence = String.valueOf(sentence) + line;
            if ((parenthesis += Utility.countParenthesis(line)) != 0 || line.length() == 0) continue;
            sentence = sentence.trim();
            sentence = sentence.replaceAll("\n", "");
            sentence = sentence.replaceAll("\\s+", " ");
            sentence = Utility.cleanSlash(sentence);
            if ((sentence = ConstCorpusTiger.adjustParenthesisation(sentence)).indexOf(40) > -1) {
                this.addInputTree(sentence);
            }
            sentence = "";
        }
        scan.close();
    }

    public static String adjustParenthesisation(String line) {
        if (line.startsWith("(TOP (")) {
            return line;
        }
        return line.replaceFirst("\\(\\s\\(", "(TOP (");
    }

    public void buildLabelsStatistics(File reportFile, File internalLable, File posTagLable) {
        TreeSet<String> internalLabels = new TreeSet<String>();
        TreeSet<String> posTagLabels = new TreeSet<String>();
        Hashtable<String, Integer> internalLabelTable = new Hashtable<String, Integer>();
        Hashtable<String, Integer> posTagLabelTable = new Hashtable<String, Integer>();
        for (TSNode inputTree : this.treeBank) {
            List<TSNode> nodes = inputTree.collectAllNodes();
            for (TSNode n : nodes) {
                if (n.isLexical) continue;
                String label = n.label;
                if (n.isPrelexical()) {
                    posTagLabels.add(label);
                    Utility.increaseStringInteger(posTagLabelTable, label, 1);
                    continue;
                }
                internalLabels.add(label);
                Utility.increaseStringInteger(internalLabelTable, label, 1);
            }
        }
        Parameters.internalLabels = internalLabels.toArray(new String[internalLabels.size()]);
        Parameters.posTagLabels = posTagLabels.toArray(new String[posTagLabels.size()]);
        String report = "Internal labels (" + internalLabels.size() + "): " + internalLabels.toString() + "\n\n" + "posTags labels (" + posTagLabels.size() + "): " + posTagLabels.toString();
        Utility.hashtableOrderedToFile(internalLabelTable, internalLable);
        Utility.hashtableOrderedToFile(posTagLabelTable, posTagLable);
        FileUtil.appendReturn(report, reportFile);
    }

    private void addInputTree(String line) {
        TSNode TreeLine = new TSNode(line);
        this.treeBank.add(TreeLine);
    }

    public static String addTop(String line) {
        if (line.startsWith("(" + topTag)) {
            return line;
        }
        line = "(" + topTag + " " + line + ")";
        return line;
    }

    public void removeTop() {
        for (TSNode t : this.treeBank) {
            t.removeTop();
        }
    }

    public String[] maxOfMinDepth() {
        String[] result = new String[2];
        int maxOfMinDepth = 0;
        ListIterator<TSNode> i = this.treeBank.listIterator();
        while (i.hasNext()) {
            TSNode inputTree = i.next();
            int momd = inputTree.maxOfMinDepth();
            if (momd <= maxOfMinDepth) continue;
            maxOfMinDepth = momd;
            result[0] = inputTree.toString();
        }
        result[1] = Integer.toString(maxOfMinDepth);
        return result;
    }

    public int maxOfSerialUnaryProduction() {
        int max = -1;
        TSNode maxTree = null;
        ListIterator<TSNode> i = this.treeBank.listIterator();
        while (i.hasNext()) {
            TSNode inputTree = i.next();
            int temp = inputTree.maxSerialUnaryProduction()[1];
            if (temp <= max) continue;
            max = temp;
            maxTree = inputTree;
        }
        System.out.println(maxTree);
        return max;
    }

    public void removeHeadAnnotations() {
        for (TSNode inputTree : this.treeBank) {
            inputTree.removeHeadAnnotations();
        }
    }

    public void fixUnaryHeadConsistency() {
        for (TSNode inputTree : this.treeBank) {
            inputTree.fixUnaryHeadConsistency();
        }
    }

    public void correctHeadAnnotation() {
        int i = 0;
        String errorLines = "";
        for (TSNode inputTree : this.treeBank) {
            ++i;
            int[] corrections = inputTree.checkHeadConsistency(true);
            if (corrections[0] <= 0) continue;
            errorLines = String.valueOf(errorLines) + "Corrected head assignemnt in: " + this.corpusName + "@" + i + "(Total Wrong Heads: " + corrections[0] + "\tof which unary: " + corrections[1] + "\n";
        }
        FileUtil.appendReturn(errorLines, Parameters.logFile);
    }

    public void removeArgumentInHeads() {
        for (TSNode inputTree : this.treeBank) {
            inputTree.removeArgumentInHeads();
        }
    }

    public void checkHeadAnnotationStatistics(File statisticsFile) {
        int totalWrongHeads = 0;
        int totalUnaryWrongHeads = 0;
        int totalHeadPositions = 0;
        int totalWrongTrees = 0;
        PrintWriter writer = null;
        if (statisticsFile != null) {
            writer = FileUtil.getPrintWriter(statisticsFile);
        }
        int index = -1;
        for (TSNode inputTree : this.treeBank) {
            ++index;
            int[] wrongHeads = inputTree.checkHeadConsistency(false);
            totalWrongHeads += wrongHeads[0];
            totalUnaryWrongHeads += wrongHeads[1];
            if (wrongHeads[0] != wrongHeads[1]) {
                ++totalWrongTrees;
                if (statisticsFile != null) {
                    writer.println("Wrong assignment at index " + index + "\n" + "Total Wrong Heads: " + wrongHeads[0] + "\tof which unary: " + wrongHeads[1] + "\n" + inputTree.toString(true, false));
                }
            }
            totalHeadPositions += inputTree.countNodes(true, false, false);
        }
        float missingRate = (float)totalWrongHeads / (float)totalHeadPositions;
        String report = "\n\n";
        if (this.corpusName != null) {
            report = String.valueOf(report) + "Head annotation statistics of corpus: " + this.corpusName + "\n";
        }
        report = String.valueOf(report) + "Total trees: " + this.size() + "\n" + "Trees with non-superfluous wrong heads: " + totalWrongTrees + "\n" + "Total wrong heads: " + totalWrongHeads + "\n" + "Total unary wrong heads: " + totalUnaryWrongHeads + "\n" + "Total head positions: " + totalHeadPositions + "\n" + "Missing rate: " + missingRate + "\n";
        if (statisticsFile != null) {
            writer.println(report);
            writer.close();
        } else {
            System.out.println(report);
        }
    }

    public void percolatePosTagsInCorpus() {
        for (TSNode TreeLine : this.treeBank) {
            TreeLine.percolatePosTags();
        }
    }

    public void removeTreesLongerThan(int nWords, String[] nonCountCatInLength) {
        ListIterator<TSNode> i = this.treeBank.listIterator();
        while (i.hasNext()) {
            TSNode inputTree = i.next();
            int sentenceLength = inputTree.countLexicalNodesExcludingCatLabels(nonCountCatInLength);
            if (sentenceLength <= nWords) continue;
            i.remove();
        }
    }

    public void replaceNumberWithUniqueTag() {
        for (TSNode inputTree : this.treeBank) {
            inputTree.replaceNumbers(numberTag);
        }
    }

    public void removeRedundantRules() {
        for (TSNode inputTree : this.treeBank) {
            inputTree.removeRedundantRules();
        }
    }

    public void checkRedundentRules() {
        int treeIndex = 0;
        for (TSNode inputTree : this.treeBank) {
            if (inputTree.hasRedundentRules()) {
                System.out.println("RR: " + treeIndex + " : " + inputTree.toString());
            }
            ++treeIndex;
        }
    }

    public void makePosTagsLexicon() {
        for (TSNode inputTree : this.treeBank) {
            inputTree.makePosTagsLexicon();
        }
    }

    public void unMakePosTagsLexicon(ConstCorpusTiger originalTrainingCorpus) {
        ListIterator<TSNode> i = this.treeBank.listIterator();
        ListIterator<TSNode> o = originalTrainingCorpus.treeBank.listIterator();
        while (i.hasNext() && o.hasNext()) {
            i.next().unMakePosTagsLexicon(o.next());
        }
    }

    public void copyHeadDependencyFrom(ConstCorpusTiger originalCorpus) {
        int treeIndex = 0;
        for (TSNode inputTree : this.treeBank) {
            TSNode originalTree = originalCorpus.treeBank.get(treeIndex);
            inputTree.copyHeadAnnotation(originalTree);
            ++treeIndex;
        }
    }

    public void removeTraces(String traceTag) {
        for (TSNode inputTree : this.treeBank) {
            inputTree.pruneSubTrees(traceTag);
        }
    }

    public void removeDoubleQuoteTiger() {
        for (TSNode inputTree : this.treeBank) {
            inputTree.pruneSubTrees("''");
            inputTree.pruneSubTrees("``");
        }
    }

    public void removeSemanticTags() {
        for (TSNode inputTree : this.treeBank) {
            inputTree.removeSemanticTags();
        }
    }

    public void removeSemanticTags(String tag) {
        for (TSNode inputTree : this.treeBank) {
            inputTree.removeSemanticTags(tag);
        }
    }

    public void removeNumbersInLables() {
        for (TSNode inputTree : this.treeBank) {
            inputTree.removeNumberInLabels();
        }
    }

    public void replaceLabels(String oldLabel, String newLabel) {
        for (TSNode inputTree : this.treeBank) {
            inputTree.replaceLabels(oldLabel, newLabel);
        }
    }

    public void assignRandomHeads() {
        this.removeHeadAnnotations();
        for (TSNode inputTree : this.treeBank) {
            inputTree.assignRandomHeads();
        }
    }

    public void assignFirstLeftHeads() {
        this.removeHeadAnnotations();
        for (TSNode inputTree : this.treeBank) {
            inputTree.assignFirstLeftHeads();
        }
    }

    public void assignFirstRightHeads() {
        this.removeHeadAnnotations();
        for (TSNode inputTree : this.treeBank) {
            inputTree.assignFirstRightHeads();
        }
    }

    public Hashtable<String, Integer> buildLexFreq() {
        Hashtable<String, Integer> lexFreq = new Hashtable<String, Integer>();
        for (TSNode inputTree : this.treeBank) {
            List<TSNode> lex = inputTree.collectLexicalItems();
            for (TSNode l : lex) {
                Utility.increaseStringInteger(lexFreq, l.label(), 1);
            }
        }
        return lexFreq;
    }

    public void toFile_Flat(File outputFile) {
        PrintWriter out = FileUtil.getPrintWriter(outputFile);
        for (TSNode inputTree : this.treeBank) {
            String line = inputTree.toFlat();
            out.write(String.valueOf(line) + "\n");
        }
        out.close();
    }

    public void toFile_Complete(File outputFile, boolean heads) {
        this.toFile_Complete(outputFile, heads, true);
    }

    public void toFile_Complete(File outputFile, boolean heads, boolean top) {
        PrintWriter out = FileUtil.getPrintWriter(outputFile);
        for (TSNode inputTree : this.treeBank) {
            if (!top && inputTree.label.equals("TOP")) {
                inputTree = inputTree.firstDaughter();
                inputTree.headMarked = false;
            }
            String line = inputTree.toString(heads, false);
            out.write(String.valueOf(line) + "\n");
        }
        out.close();
    }

    public void toFile_ExtractWords(File outputFile) {
        PrintWriter out = FileUtil.getPrintWriter(outputFile);
        for (TSNode inputTree : this.treeBank) {
            out.write(String.valueOf(inputTree.toExtractWord()) + "\n");
        }
        out.close();
    }

    public List<Integer> containsConstructor(TSNode constructor) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int index = -1;
        for (TSNode TN : this.treeBank) {
            ++index;
            if (!TN.containsConstructor(constructor)) continue;
            result.add(index);
        }
        return result;
    }

    public List<TSNode> containsSpine(TSNode treeSpine) {
        ArrayList<TSNode> result = new ArrayList<TSNode>();
        for (TSNode TN : this.treeBank) {
            if (!TN.containsSpine(treeSpine)) continue;
            result.add(TN);
        }
        return result;
    }

    public int size() {
        return this.treeBank.size();
    }

    public ConstCorpusTiger returnLast(int toReturn) {
        ConstCorpusTiger result = new ConstCorpusTiger();
        int endIndex = this.treeBank.size();
        int index = endIndex - toReturn;
        while (index < endIndex) {
            result.treeBank.add(this.treeBank.get(index));
            ++index;
        }
        return result;
    }

    public ConstCorpusTiger returnFirst(int toReturn) {
        ConstCorpusTiger result = new ConstCorpusTiger();
        result.corpusName = this.corpusName;
        int index = 0;
        while (index < toReturn) {
            result.treeBank.add(this.treeBank.get(index));
            ++index;
        }
        return result;
    }

    public void keepRandomFraction(float fraction) {
        int toKeep = (int)((double)this.treeBank.size() * (double)fraction);
        Collections.shuffle(this.treeBank);
        ArrayList<TSNode> newTreebank = new ArrayList<TSNode>();
        int index = 0;
        while (index < toKeep) {
            newTreebank.add(this.treeBank.get(index));
            ++index;
        }
        this.treeBank = newTreebank;
    }

    public void splitRandom(int sizeFirst, ConstCorpusTiger firstCorpus, ConstCorpusTiger secondCorpus) {
        firstCorpus = new ConstCorpusTiger(this.corpusName);
        secondCorpus = new ConstCorpusTiger(this.corpusName);
        Collections.shuffle(this.treeBank);
        int index = 0;
        while (index < sizeFirst) {
            firstCorpus.treeBank.add(this.treeBank.get(index));
            ++index;
        }
        index = sizeFirst;
        while (index < this.size()) {
            secondCorpus.treeBank.add(this.treeBank.get(index));
            ++index;
        }
    }

    public void multiplyCorpus(int factor) {
        ArrayList<TSNode> newTreeBank = new ArrayList<TSNode>();
        for (TSNode tree : this.treeBank) {
            int i = 0;
            while (i < factor) {
                newTreeBank.add(new TSNode(tree));
                ++i;
            }
        }
        this.treeBank = newTreeBank;
    }

    public void removeIndexes(int[] array) {
        Arrays.sort(array);
        ArrayList<TSNode> newTreeBank = new ArrayList<TSNode>();
        int treeIndex = -1;
        int arrayIndex = 0;
        for (TSNode tree : this.treeBank) {
            if (arrayIndex < array.length && ++treeIndex == array[arrayIndex]) {
                ++arrayIndex;
                continue;
            }
            newTreeBank.add(tree);
        }
        this.treeBank = newTreeBank;
    }

    public ConstCorpusTiger returnIndexes(int[] indexes) {
        ConstCorpusTiger result = new ConstCorpusTiger();
        int[] nArray = indexes;
        int n = indexes.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            result.treeBank.add(this.treeBank.get(i));
            ++n2;
        }
        return result;
    }

    public static void main(String[] args) {
        String line = "($( ``)";
        line = line.replaceAll("\\$\\(", "\\$-");
        System.out.println(line);
    }
}

