/*
 * Decompiled with CFR 0.152.
 */
package kernels;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.ListIterator;
import kernels.NodeSetCollector;
import kernels.NodeSetCollectorFreq;
import util.Duet;
import util.Utility;

public class NodeSetCollectorMUBFreq
extends NodeSetCollector {
    ArrayList<Duet<BitSet, int[]>> bitSetTable = new ArrayList();

    @Override
    public Object clone() {
        NodeSetCollectorFreq clone = new NodeSetCollectorFreq();
        clone.bitSetTable = (ArrayList)this.bitSetTable.clone();
        return clone;
    }

    @Override
    public void makeEmpty() {
        this.bitSetTable.clear();
    }

    @Override
    public boolean add(BitSet bs) {
        return this.add(bs, 1);
    }

    public boolean add(BitSet newBs, int toAdd) {
        int newBsCard = newBs.cardinality();
        ListIterator<Duet<BitSet, int[]>> iter = this.bitSetTable.listIterator();
        while (iter.hasNext()) {
            Duet<BitSet, int[]> element = iter.next();
            BitSet bs = element.getFirst();
            int bsCard = bs.cardinality();
            BitSet intersection = (BitSet)bs.clone();
            intersection.and(newBs);
            int intersectionCard = intersection.cardinality();
            if (intersectionCard == newBsCard) {
                return true;
            }
            if (intersectionCard != bsCard) continue;
            iter.remove();
            this.insertInOrder(newBs, newBsCard, toAdd);
            return true;
        }
        this.insertInOrder(newBs, newBsCard, toAdd);
        return true;
    }

    private void insertInOrder(BitSet newBs, int newBsCard, int toAdd) {
        Duet<BitSet, int[]> newElement = new Duet<BitSet, int[]>(newBs, new int[]{toAdd});
        ListIterator<Duet<BitSet, int[]>> iter = this.bitSetTable.listIterator();
        while (iter.hasNext()) {
            Duet<BitSet, int[]> element = iter.next();
            BitSet bs = element.getFirst();
            int bsCard = bs.cardinality();
            if (newBsCard < bsCard) continue;
            iter.previous();
            iter.add(newElement);
            while (iter.hasNext()) {
                element = iter.next();
                bs = element.getFirst();
                bsCard = bs.cardinality();
                BitSet intersection = (BitSet)bs.clone();
                intersection.and(newBs);
                int intersectionCard = intersection.cardinality();
                if (intersectionCard != bsCard) continue;
                iter.remove();
            }
            return;
        }
        iter.add(newElement);
    }

    @Override
    public boolean addAll(NodeSetCollector collector) {
        boolean result = false;
        NodeSetCollectorMUBFreq coll = (NodeSetCollectorMUBFreq)collector;
        for (Duet<BitSet, int[]> duet : coll.bitSetTable) {
            boolean bl = result = this.add(duet.getFirst(), duet.getSecond()[0]) || result;
        }
        return result;
    }

    @Override
    public boolean addAllCombinations(NodeSetCollector[] collectors, int[] collectorsSizes, int defaultBitSet) {
        int[][] combinations;
        boolean result = false;
        int[][] nArray = combinations = Utility.combinations(collectorsSizes);
        int n = combinations.length;
        int n2 = 0;
        while (n2 < n) {
            int[] comb = nArray[n2];
            BitSet ks = this.getDefaultBitSet(defaultBitSet);
            int min = Integer.MAX_VALUE;
            int i = 0;
            while (i < collectors.length) {
                int comb_i = comb[i];
                Duet<BitSet, int[]> choosenElement = ((NodeSetCollectorMUBFreq)collectors[i]).bitSetTable.get(comb_i);
                int elementFreq = choosenElement.getSecond()[0];
                if (elementFreq < min) {
                    min = elementFreq;
                }
                ks.or(choosenElement.getFirst());
                ++i;
            }
            result = this.add(ks, min) || result;
            ++n2;
        }
        return result;
    }

    @Override
    public boolean removeSingleton(int index) {
        if (this.bitSetTable.isEmpty()) {
            return false;
        }
        Iterator<Duet<BitSet, int[]>> iter = this.bitSetTable.iterator();
        while (iter.hasNext()) {
            BitSet bs = iter.next().getFirst();
            if (bs.cardinality() != 1 || !bs.get(index)) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeUniqueSingleton() {
        if (this.bitSetTable.isEmpty()) {
            return false;
        }
        Iterator<Duet<BitSet, int[]>> iter = this.bitSetTable.iterator();
        while (iter.hasNext()) {
            BitSet bs = iter.next().getFirst();
            if (bs.cardinality() != 1) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.bitSetTable.size();
    }

    @Override
    public BitSet uniteSubGraphs() {
        BitSet unionBS = new BitSet();
        int unionFreq = 0;
        for (Duet<BitSet, int[]> element : this.bitSetTable) {
            unionBS.or(element.getFirst());
            unionFreq += element.getSecond()[0];
        }
        Duet<BitSet, int[]> unionElement = new Duet<BitSet, int[]>(unionBS, new int[]{unionFreq});
        return unionBS;
    }

    public int maxCardinalitySharedSubGraph() {
        if (this.isEmpty()) {
            return 0;
        }
        Duet<BitSet, int[]> biggest = this.bitSetTable.get(0);
        return biggest.getFirst().cardinality();
    }

    public int freqMaxCard() {
        int maxCardinality = 0;
        int freqMaxCard = 0;
        for (Duet<BitSet, int[]> element : this.bitSetTable) {
            BitSet bs = element.getFirst();
            int bsCard = bs.cardinality();
            if (bsCard <= maxCardinality) continue;
            maxCardinality = bsCard;
            freqMaxCard = element.getSecond()[0];
        }
        return freqMaxCard;
    }

    @Override
    public BitSet[] getBitSetsAsArray() {
        int size = this.size();
        if (size == 0) {
            return null;
        }
        BitSet[] result = new BitSet[size];
        int index = 0;
        Iterator<Duet<BitSet, int[]>> iter = this.bitSetTable.iterator();
        while (iter.hasNext()) {
            result[index] = iter.next().getFirst();
            ++index;
        }
        return result;
    }

    public Duet<BitSet, int[]>[] getBitSetsFreqAsArray() {
        int size = this.size();
        if (size == 0) {
            return null;
        }
        Duet[] result = new Duet[size];
        int index = 0;
        Iterator<Duet<BitSet, int[]>> iter = this.bitSetTable.iterator();
        while (iter.hasNext()) {
            result[index] = iter.next();
            ++index;
        }
        return result;
    }

    public int totalFreq() {
        int totalFreq = 0;
        Iterator<Duet<BitSet, int[]>> iter = this.bitSetTable.iterator();
        while (iter.hasNext()) {
            totalFreq = iter.next().getSecond()[0];
        }
        return totalFreq;
    }

    @Override
    public int maxCardinality() {
        int maxCardinality = 0;
        Iterator<Duet<BitSet, int[]>> iter = this.bitSetTable.iterator();
        while (iter.hasNext()) {
            BitSet bs = iter.next().getFirst();
            int bsCard = bs.cardinality();
            if (bsCard <= maxCardinality) continue;
            maxCardinality = bsCard;
        }
        return maxCardinality;
    }

    @Override
    public String toString() {
        String result = "";
        for (Duet<BitSet, int[]> element : this.bitSetTable) {
            result = String.valueOf(result) + element.getFirst() + "\t" + element.getSecond()[0] + "\n";
        }
        return result.trim();
    }
}

