import matplotlib.pyplot as plt                                                                                                                                          
import networkx as nx

plt.rcParams.update({
    "text.usetex": True,
    "font.family": "serif",
    "font.serif": ["Times"],
    "font.size": 30,
    "figure.figsize": (6, 12),
    "axes.titlesize": 12,
    "axes.labelsize": 12,
    "legend.fontsize": 12,
    "xtick.labelsize": 12,
    "ytick.labelsize": 12,
    "xtick.direction": "inout",
    "ytick.direction": "inout",
    "lines.linewidth": 5.0,
    "lines.markersize": 6,
    "legend.frameon": False,
    "legend.loc": "upper right",
    "legend.handlelength": 1.5,
    "legend.handletextpad": 0.5,
    "legend.labelspacing": 0.5,
    "legend.columnspacing": 1.5,
    "legend.borderaxespad": 0.5,
    "legend.borderpad": 0.5,
    "savefig.dpi": 300,
    "savefig.bbox": "tight",
    "savefig.pad_inches": 0.01,
    "savefig.transparent": False,
    "pdf.fonttype": 42,
    "pdf.compression": 9,
    "pgf.texsystem": "pdflatex",
    "pgf.preamble": r"\usepackage{amsmath}",
    "pgf.rcfonts": False,

})

def draw_final_graph_with_larger_text():
    # Create a directed graph
    G = nx.DiGraph()
 
    # Add nodes
    nodes = ["$x_0$", "$x_1$", "$x_2$", "$x_3$", "$x_4$"]
    G.add_nodes_from(nodes)
 
    # Add edges
    edges = [("$x_0$", "$x_2$"), ("$x_2$", "$x_4$"), ("$x_1$", "$x_3$"), ("$x_3$", "$x_4$")]
    G.add_edges_from(edges)
 
    # Define positions for all nodes
    pos = {
        "$x_0$": (1, 4),
        "$x_1$": (1.5, 3),
        "$x_2$": (1, 2),
        "$x_3$": (1.5, 1),
        "$x_4$": (1, 0)
    }
    plt.figure(figsize=(6, 12))
 
    # Draw nodes and edges
    nx.draw(G, pos, with_labels=True, node_size=3000, node_color="white", edgecolors='black', linewidths=2.5, font_size=45, font_color="black", font_weight="bold", arrows=True, arrowstyle='-|>', arrowsize=45, edge_color='red', connectionstyle='arc3,rad=0', width=2.0)
 
    plt.axis('off')
 
    # Save the figure as a PDF
    output_path = "graph_example.pdf"
    plt.savefig(output_path, format="pdf", bbox_inches='tight')
    plt.close()
 
    return output_path
 
# Example usage
output_path = draw_final_graph_with_larger_text()
