/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns.surface;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.tokensregex.MultiPatternMatcher;
import edu.stanford.nlp.ling.tokensregex.SequenceMatchResult;
import edu.stanford.nlp.ling.tokensregex.TokenSequencePattern;
import edu.stanford.nlp.patterns.surface.ConstantsAndVariables;
import edu.stanford.nlp.patterns.surface.PatternsAnnotations;
import edu.stanford.nlp.patterns.surface.SurfacePattern;
import edu.stanford.nlp.stats.TwoDimensionalCounter;
import edu.stanford.nlp.util.CollectionValuedMap;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Triple;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;

public class ApplyPatternsMulti
implements Callable<Pair<TwoDimensionalCounter<Pair<String, String>, SurfacePattern>, CollectionValuedMap<SurfacePattern, Triple<String, Integer, Integer>>>> {
    String label;
    Map<TokenSequencePattern, SurfacePattern> patterns;
    List<String> sentids;
    boolean removeStopWordsFromSelectedPhrases;
    boolean removePhrasesWithStopWords;
    ConstantsAndVariables constVars;
    MultiPatternMatcher<CoreMap> multiPatternMatcher;
    Map<String, List<CoreLabel>> sents = null;

    public ApplyPatternsMulti(Map<String, List<CoreLabel>> sents, List<String> sentids, Map<TokenSequencePattern, SurfacePattern> patterns, String label, boolean removeStopWordsFromSelectedPhrases, boolean removePhrasesWithStopWords, ConstantsAndVariables cv) {
        this.sents = sents;
        this.patterns = patterns;
        this.multiPatternMatcher = TokenSequencePattern.getMultiPatternMatcher(patterns.keySet());
        this.sentids = sentids;
        this.label = label;
        this.removeStopWordsFromSelectedPhrases = removeStopWordsFromSelectedPhrases;
        this.removePhrasesWithStopWords = removePhrasesWithStopWords;
        this.constVars = cv;
    }

    @Override
    public Pair<TwoDimensionalCounter<Pair<String, String>, SurfacePattern>, CollectionValuedMap<SurfacePattern, Triple<String, Integer, Integer>>> call() throws Exception {
        CollectionValuedMap<SurfacePattern, Triple<String, Integer, Integer>> matchedTokensByPat = new CollectionValuedMap<SurfacePattern, Triple<String, Integer, Integer>>();
        TwoDimensionalCounter<Pair<String, String>, SurfacePattern> allFreq = new TwoDimensionalCounter<Pair<String, String>, SurfacePattern>();
        for (String sentid : this.sentids) {
            List<CoreLabel> sent = this.sents.get(sentid);
            Iterable<SequenceMatchResult<CoreLabel>> matched = this.multiPatternMatcher.findAllNonOverlappingMatchesPerPattern(sent);
            for (SequenceMatchResult<CoreLabel> m : matched) {
                int i;
                int s = m.start("$term");
                int e = m.end("$term");
                SurfacePattern matchedPat = this.patterns.get(m.pattern());
                matchedTokensByPat.add(matchedPat, new Triple<String, Integer, Integer>(sentid, s, e));
                String phrase = "";
                String phraseLemma = "";
                boolean useWordNotLabeled = false;
                boolean doNotUse = false;
                boolean[] addedindices = new boolean[e - s];
                Arrays.fill(addedindices, false);
                for (i = s; i < e; ++i) {
                    CoreLabel l = sent.get(i);
                    l.set(PatternsAnnotations.MatchedPattern.class, true);
                    for (Map.Entry<Class, Object> ig : this.constVars.ignoreWordswithClassesDuringSelection.get(this.label).entrySet()) {
                        if (!l.containsKey(ig.getKey()) || !l.get(ig.getKey()).equals(ig.getValue())) continue;
                        doNotUse = true;
                    }
                    boolean containsStop = this.containsStopWord(l, this.constVars.getCommonEngWords(), this.constVars.ignoreWordRegex);
                    if (this.removePhrasesWithStopWords && containsStop) {
                        doNotUse = true;
                        continue;
                    }
                    if (containsStop && this.removeStopWordsFromSelectedPhrases) continue;
                    if (this.label == null || l.get(this.constVars.answerClass.get(this.label)) == null || !((String)l.get(this.constVars.answerClass.get(this.label))).equals(this.label.toString())) {
                        useWordNotLabeled = true;
                    }
                    phrase = phrase + " " + l.word();
                    phraseLemma = phraseLemma + " " + l.lemma();
                    addedindices[i - s] = true;
                }
                for (i = 0; i < addedindices.length; ++i) {
                    if (i <= 0 || i >= addedindices.length - 1 || !addedindices[i - 1] || addedindices[i] || !addedindices[i + 1]) continue;
                    doNotUse = true;
                    break;
                }
                if (doNotUse || !useWordNotLabeled) continue;
                phrase = phrase.trim();
                phraseLemma = phraseLemma.trim();
                allFreq.incrementCount(new Pair<String, String>(phrase, phraseLemma), matchedPat, 1.0);
            }
        }
        return new Pair<TwoDimensionalCounter<Pair<String, String>, SurfacePattern>, CollectionValuedMap<SurfacePattern, Triple<String, Integer, Integer>>>(allFreq, matchedTokensByPat);
    }

    boolean containsStopWord(CoreLabel l, Set<String> commonEngWords, Pattern ignoreWordRegex) {
        return commonEngWords.contains(l.lemma()) || commonEngWords.contains(l.word()) || ignoreWordRegex != null && ignoreWordRegex.matcher(l.lemma()).matches();
    }
}

