/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.dcoref.sievepasses;

import edu.stanford.nlp.dcoref.CorefCluster;
import edu.stanford.nlp.dcoref.Dictionaries;
import edu.stanford.nlp.dcoref.Document;
import edu.stanford.nlp.dcoref.Mention;
import edu.stanford.nlp.dcoref.MentionMatcher;
import edu.stanford.nlp.dcoref.Rules;
import edu.stanford.nlp.dcoref.sievepasses.DeterministicCorefSieve;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.ReflectionLoading;
import java.util.Properties;
import java.util.Set;

public class NameMatch
extends DeterministicCorefSieve {
    protected MentionMatcher mentionMatcher = null;
    protected int minTokens = 0;
    protected boolean ignoreGender = true;
    private Set<String> supportedNerTypes = Generics.newHashSet();

    public NameMatch() {
        this.flags.USE_iwithini = true;
        this.flags.USE_NAME_MATCH = true;
        this.supportedNerTypes.add("ORG");
        this.supportedNerTypes.add("ORGANIZATION");
        this.supportedNerTypes.add("PER");
        this.supportedNerTypes.add("PERSON");
        this.supportedNerTypes.add("MISC");
    }

    @Override
    public void init(Properties props) {
        this.mentionMatcher = (MentionMatcher)ReflectionLoading.loadByReflection("edu.stanford.nlp.kbp.entitylinking.classify.namematcher.RuleBasedNameMatcher", "dcoref.mentionMatcher", props);
    }

    private static boolean isNamedMention(Mention m, Dictionaries dict, Set<Mention> roleSet) {
        return m.mentionType == Dictionaries.MentionType.PROPER;
    }

    @Override
    public boolean checkEntityMatch(Document document, CorefCluster mentionCluster, CorefCluster potentialAntecedent, Dictionaries dict, Set<Mention> roleSet) {
        Boolean matched = false;
        Mention mainMention = mentionCluster.getRepresentativeMention();
        Mention antMention = potentialAntecedent.getRepresentativeMention();
        if (NameMatch.isNamedMention(mainMention, dict, roleSet) && NameMatch.isNamedMention(antMention, dict, roleSet) && (mainMention.originalSpan.size() > this.minTokens || antMention.originalSpan.size() > this.minTokens) && Rules.entityAttributesAgree(mentionCluster, potentialAntecedent, this.ignoreGender) && (this.supportedNerTypes.contains(mainMention.nerString) || this.supportedNerTypes.contains(antMention.nerString))) {
            matched = this.mentionMatcher.isCompatible(mainMention, antMention);
            if (matched != null) {
                if (!matched.booleanValue()) {
                    document.addIncompatible(mainMention, antMention);
                }
            } else {
                matched = false;
            }
        }
        return matched;
    }
}

