from types import MethodType
from transformers.models.llama.modeling_llama import LlamaAttention


def modify_method_of_instance(instance, target_class_name, target_method_name, new_method, visited_instances=None):
    """
        This function modifies the method of an instance of a model class. 
        It's part from chat-GPT.
        It will replace the method  with the new method.
        Currently, we only use this function to modify the attention method of a model. Do not test it further. 

        instance: 
            instance of a model to modify.
        target_class_name: 
            name of the attention class to modify. E.g. 'LlamaAttention', 'GPTNeoXAttention', etc.
        new_method: new method to replace the original method. E.g. 'self_extend_forward'. 
            It should include a parameter 'self' to be binded to the instance.
    """
    if visited_instances is None:
        visited_instances = set()
    # Unique identifier for the instance (using id() since object's id is unique)
    instance_id = id(instance)
    if instance_id in visited_instances:
        return 
    # Add the instance to the already_visited set
    visited_instances.add(instance_id)

    # Check if this instance is of the target class
    if instance.__class__.__name__ == target_class_name:
        bond_method = MethodType(new_method, instance) 
        setattr(instance, target_method_name, bond_method)
    elif hasattr(instance, '__dict__'):
        for attr_name, attr_value in instance.__dict__.items():
            if isinstance(attr_value, object) and not isinstance(attr_value, (list, tuple, dict, set)):
                modify_method_of_instance(attr_value, target_class_name, target_method_name, new_method, visited_instances)
            elif isinstance(attr_value, (list, tuple)):
                for item in attr_value:
                    if isinstance(item, object):
                        modify_method_of_instance(item, target_class_name, target_method_name, new_method, visited_instances)
            # If attribute value is a dictionary, iterate over its values and recurse
            # E.g, for a ModuleList, its moudels are stored in a dictionary: ._modules
            elif isinstance(attr_value, dict):
                for key, value in attr_value.items():
                    if isinstance(value, object):
                        modify_method_of_instance(value, target_class_name, target_method_name, new_method, visited_instances)
            
            # If attribute value is a set, iterate and recurse
            elif isinstance(attr_value, set):
                for item in attr_value:
                    if isinstance(item, object):
                        modify_method_of_instance(item, target_class_name, target_method_name, new_method, visited_instances)
    
def set_dynamicntk_rope_length(model, max_length):
    for name, module in model.named_modules():
        if isinstance(module, LlamaAttention):
            module.rotary_emb._set_cos_sin_cache(max_length, device=model.device, dtype=module.rotary_emb.inv_freq.dtype)
    print(f"DynamicNTKRoPE max length reset to {max_length}")