CUDA_VISIBLE_DEVICES=2,3,4,5,6,7
epochs=2
seed=46
# --num_gpus=4 --include=3,4,5,6 localhost:
# THUDM/chatglm2-6b
nohup deepspeed --include=localhost:2,3,4,5,6,7 --master_port 8888 train_lora.py \
            --train_path data/lora/train.json \
            --model_name_or_path THUDM/chatglm2-6b \
            --per_device_train_batch_size 2 \
            --max_len 8192 \
            --max_src_len 8192 \
            --learning_rate 1e-4 \
            --weight_decay 0.1 \
            --num_train_epochs ${epochs} \
            --gradient_accumulation_steps 4 \
            --warmup_ratio 0.1 \
            --mode glm2 \
            --train_type lora \
            --lora_dim 16 \
            --lora_alpha 64 \
            --lora_dropout 0.1 \
            --lora_module_name "query_key_value,dense_h_to_4h,dense_4h_to_h,dense" \
            --seed ${seed} \
            --ds_file ds_zero2_no_offload.json \
            --gradient_checkpointing \
            --show_loss_step 10 \
            --output_dir ./output-chatglm2-${epochs}-${seed} > ./log/chatglm2-${epochs}-${seed}.log &