theory question_93_5
imports Main

begin

typedecl entity
typedecl event

consts
  Running :: "event ⇒ bool"
  Agent :: "entity ⇒ bool"
  Location :: "entity ⇒ bool"
  TimeInterval :: "entity ⇒ bool"
  During :: "entity ⇒ event ⇒ bool" (* Changed the type of the first argument from event to entity *)
  AdultStarfish :: "entity ⇒ bool"
  RadialSymmetry :: "entity ⇒ bool"

(* Explanation 1: An event e is a running event if and only if there exists an agent x who is running at location l during time interval t. *)
axiomatization where
  explanation_1: "∀e. Running e ⟷ (∃x l t. Agent x ∧ During t e ∧ Located_at l x ∧ Happens_during t (Running x))"

theorem hypothesis:
  assumes asm: "AdultStarfish x"
  (* Hypothesis: Adults of starfish have radial symmetry. *)
  shows "RadialSymmetry x"
proof -
  have "AdultStarfish x ⟹ Echinoderm x" using asm by simp
  then have "RadialSymmetry x" using explanation_1 by blast
  then show ?thesis by simp
qed

end
