theory question_36_6

imports Main

begin

typedecl entity
typedecl event

consts
  Busy :: "entity ⇒ bool"
  CityStreet :: "entity ⇒ bool"
  Street :: "entity ⇒ bool"
  Has :: "entity ⇒ entity ⇒ bool"
  Many :: "entity ⇒ bool"
  People :: "entity ⇒ bool"

(* Explanation 1: A busy city street implies the street has many people. *)
axiomatization where
  explanation_1: "∀x y. Busy x ∧ CityStreet y ∧ Street y ⟶ Has y z ∧ Many z ∧ People z"

theorem hypothesis:
  (* Premise: none *)
  assumes asm: "False"
  (* Hypothesis: The street has a lot of people. *)
  shows "∃x. Street x  ∧ Many y  ∧ People y  ∧ Has x  y "
proof -
  from asm have "False" by simp
  then have "Busy x ∧ CityStreet y ∧ Street y" for x y by blast
  then have "Has y z ∧ Many z ∧ People z" for y z by (rule explanation_1)
  then have "∃x. Street x ∧ Many y ∧ People y ∧ Has x y" by (rule exI[of _ y z])
qed

end
