from langchain.chat_models import ChatOpenAI
from langchain.chains import ConversationChain
from langchain.memory import ConversationBufferMemory
from langchain.llms import OpenAI
import os
OPENAI_API_KEY = os.environ['OPENAI_API_KEY']
 
def chatsettubg(model_name='gpt-3.5-turbo', stop=None, completion=None):
    if completion == 'completion_mode':
        llm = OpenAI(
            model='gpt-3.5-turbo-instruct',
            temperature=1.0,
            max_tokens=1400,
            openai_api_key=OPENAI_API_KEY,
            stop=stop
            )
        return llm    

    if stop != None:
        llm = ChatOpenAI(
            model=model_name,
            temperature=1.0,
            openai_api_key=OPENAI_API_KEY,
            stop=stop
        )
    else:
        llm = ChatOpenAI(
            model=model_name,
            temperature=1.0,
            openai_api_key=OPENAI_API_KEY,
            
        )
    
    memory = ConversationBufferMemory()
    conversation = ConversationChain(
        llm=llm,
        memory=memory,
        verbose=True
    )
    return {'memory': memory, 'conversation': conversation}
