import os
import sys

def readTxt(filename):
    data = []
    print("Reading " + filename)
    with open(filename) as f:
        for line in f:
            data.append(line.strip())
    return data

if __name__ == "__main__":
    if len(sys.argv) < 4:
        print("Usage: python filterempty.py <input1> <input2> <outputdir>")
    
    data1 = readTxt(sys.argv[1])
    data2 = readTxt(sys.argv[2])

    if not os.path.exists(sys.argv[3]):
        os.makedirs(sys.argv[3])

    output1 = open(os.path.join(sys.argv[3], sys.argv[1].split('/')[-1]) , 'w')
    output2 = open(os.path.join(sys.argv[3], sys.argv[2].split('/')[-1]) , 'w')

    empty = 0
    for idx, (x, y) in enumerate(zip(data1, data2)):
        if len(x) > 0 and len(y) > 0:
            output1.write(x + '\n')
            output2.write(y + '\n')
        else:
            empty += 1
    
    output1.close()
    output2.close()
    print("Filter %d empty example" % empty)

    