### Processed captions data for the Coling 2020 experiments

All of the files contain the extracted contexts of varying length for running the experiments. The only difference are the labels:

    * `extracted_contexts-02.dill`: is the original 3-way split ('telic', 'atelic', 'stative')
    * `extracted_contexts-02-state-event.dill`: label recoding of the original data to just cover 2 labels: 'state' and 'event'
    * `extracted_contexts-02-telic-atelic.dill`: filtered version of the original data, i.e. all `stative` examples were removed to just cover 'telic' and 'atelic' examples`

```
# Loading files:
from telicity.util import io

data = io.load_structured_resource('/path/to/captions/extracted_contexts-02-state-event.dill')
```

An example data item looks like:
```
{
    "label": "event",
    "target_word": "holds",
    "lemma_word_map": [
        "hold",
        "holds"
    ],
    "target_word_pos": "VBZ",
    "target_word_idx": 4,
    "conll": [
        [
            "1",
            "girl",
            "girl",
            "NN",
            "_",
            "5",
            "nsubj"
        ],
        [
            "2",
            "in",
            "in",
            "IN",
            "_",
            "4",
            "case"
        ],
        [
            "3",
            "white",
            "white",
            "JJ",
            "_",
            "4",
            "amod"
        ],
        [
            "4",
            "clothes",
            "clothes",
            "NNS",
            "_",
            "1",
            "nmod"
        ],
        [
            "5",
            "holds",
            "hold",
            "VBZ",
            "_",
            "0",
            "ROOT"
        ],
        [
            "6",
            "a",
            "a",
            "DT",
            "_",
            "7",
            "det"
        ],
        [
            "7",
            "basket",
            "basket",
            "NN",
            "_",
            "5",
            "dobj"
        ],
        [
            "8",
            "of",
            "of",
            "IN",
            "_",
            "9",
            "case"
        ],
        [
            "9",
            "decorations",
            "decoration",
            "NNS",
            "_",
            "7",
            "nmod"
        ]
    ],
    "window_1": [
        "clothes_###POS###_NNS",
        "a_###POS###_DT"
    ],
    "window_1_lemma": [
        "clothes_###POS###_NNS",
        "a_###POS###_DT"
    ],
    "window_1_dependency_paths": [
        "nmod.nsubj",
        "det.dobj"
    ],
    "window_1_lemma_dependency_paths": [
        "nmod.nsubj",
        "det.dobj"
    ],
    "window_2": [
        "white_###POS###_JJ",
        "clothes_###POS###_NNS",
        "a_###POS###_DT",
        "basket_###POS###_NN"
    ],
    "window_2_lemma": [
        "white_###POS###_JJ",
        "clothes_###POS###_NNS",
        "a_###POS###_DT",
        "basket_###POS###_NN"
    ],
    "window_3": [
        "in_###POS###_IN",
        "white_###POS###_JJ",
        "clothes_###POS###_NNS",
        "a_###POS###_DT",
        "basket_###POS###_NN",
        "of_###POS###_IN"
    ],
    "window_3_lemma": [
        "in_###POS###_IN",
        "white_###POS###_JJ",
        "clothes_###POS###_NNS",
        "a_###POS###_DT",
        "basket_###POS###_NN",
        "of_###POS###_IN"
    ],
    "window_5": [
        "girl_###POS###_NN",
        "in_###POS###_IN",
        "white_###POS###_JJ",
        "clothes_###POS###_NNS",
        "a_###POS###_DT",
        "basket_###POS###_NN",
        "of_###POS###_IN"
    ],
    "window_5_lemma": [
        "girl_###POS###_NN",
        "in_###POS###_IN",
        "white_###POS###_JJ",
        "clothes_###POS###_NNS",
        "a_###POS###_DT",
        "basket_###POS###_NN",
        "of_###POS###_IN"
    ],
    "window_10": [
        "girl_###POS###_NN",
        "in_###POS###_IN",
        "white_###POS###_JJ",
        "clothes_###POS###_NNS",
        "a_###POS###_DT",
        "basket_###POS###_NN",
        "of_###POS###_IN"
    ],
    "window_10_lemma": [
        "girl_###POS###_NN",
        "in_###POS###_IN",
        "white_###POS###_JJ",
        "clothes_###POS###_NNS",
        "a_###POS###_DT",
        "basket_###POS###_NN",
        "of_###POS###_IN"
    ],
    "dep_1": [
        [
            "nsubj",
            "girl_###POS###_NN"
        ],
        [
            "dobj",
            "basket_###POS###_NN"
        ]
    ],
    "dep_1_lemma": [
        [
            "nsubj",
            "girl_###POS###_NN"
        ],
        [
            "dobj",
            "basket_###POS###_NN"
        ]
    ],
    "dep_1_head": [],
    "dep_1_head_lemma": [],
    "dep_1_children": [
        [
            "nsubj",
            "girl_###POS###_NN"
        ],
        [
            "dobj",
            "basket_###POS###_NN"
        ]
    ],
    "dep_1_children_lemma": [
        [
            "nsubj",
            "girl_###POS###_NN"
        ],
        [
            "dobj",
            "basket_###POS###_NN"
        ]
    ],
    "sent": "girl in white clothes holds a basket of decorations",
    "lemma_sent": "girl in white clothes hold a basket of decoration"
}
```
