from sister_terms_generation.collect_oov_test_sister_definitions import oov_sister_terms_definitions, \
    oov_sister_terms_definitions_comparable

import os
from sister_terms_similarity.collect_pedersen_similarities import compute_oov_sister_terms, compute_sister_terms

data_dir = 'data/similarity_pedersen_test'
if not os.path.exists(data_dir):
    os.mkdir(data_dir)


seeds = ['19']
sister_terms_output_path = 'data/similarity_pedersen_test/sister_terms'
if not os.path.exists(sister_terms_output_path):
    os.mkdir(sister_terms_output_path)

pretrained_path = 'data/pretrained_embeddings/GoogleNews-vectors-negative300.bin'

compute_oov_sister_terms(seeds, sister_terms_output_path, pretrained_path, check_if_computed=True)
compute_sister_terms(seeds, sister_terms_output_path, pretrained_path, check_if_computed=True)


sister_terms_output_path = 'data/similarity_pedersen_test/fasttext_sister_terms'
if not os.path.exists(sister_terms_output_path):
    os.mkdir(sister_terms_output_path)

pretrained_path = 'data/pretrained_embeddings/cc.en.300.bin'
compute_oov_sister_terms(seeds, sister_terms_output_path, pretrained_path, check_if_computed=True)
compute_sister_terms(seeds, sister_terms_output_path, pretrained_path, check_if_computed=True)


oov_sister_terms_definitions()
oov_sister_terms_definitions_comparable()