## Requirements
Recommended Python version: Python 3.7  
### Install packages
```bash
pip install torch torchvision
pip install -U spacy
python -m spacy download en_core_web_sm
pip install transformers
pip install git+https://github.com/kmkurn/pytorch-crf
```

## How to Fine-tune

- To fine-tune RoBERTa model on CD-SCO corpus run the below command: 
```bash
  python train.py -c ./config/en/config.json 
```
  + Arguments:
	  - -c, --config_path: path to the configuration file, (required)
	
## How to Evaluate on New Data
	
```bash
  python evaluate.py --config_path ./config/en/predict.json --input_path ./outputs/sample_io/input_file.txt --output_path ./outputs/sample_io/output_file.txt
```
  + Arguments:  
	  - --config-path: path to the configuration file; (required). It contains all hyperparameter settings.  
	  - --input_path: path to the input file (one sentence per line)  
	  - --output_path: path to the output file (file contains negation cues, cue positions, and the corresponding sentence (tab separated) in each line). 
 	  
	  

