/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.realiser;

import java.util.ArrayList;
import java.util.List;
import simplenlg.exception.SimplenlgException;
import simplenlg.features.Case;
import simplenlg.features.Category;
import simplenlg.features.ClauseStatus;
import simplenlg.features.DiscourseFunction;
import simplenlg.features.Form;
import simplenlg.features.InterrogativeType;
import simplenlg.features.NumberAgr;
import simplenlg.features.Person;
import simplenlg.features.Position;
import simplenlg.features.SModifierPosition;
import simplenlg.features.Tense;
import simplenlg.lexicon.lexicalitems.Constants;
import simplenlg.lexicon.lexicalitems.Noun;
import simplenlg.lexicon.lexicalitems.Verb;
import simplenlg.realiser.CoordinatePhraseSet;
import simplenlg.realiser.CoordinateSPhraseSpec;
import simplenlg.realiser.CoordinateVPPhraseSpec;
import simplenlg.realiser.HeadedPhraseSpec;
import simplenlg.realiser.NPPhraseSpec;
import simplenlg.realiser.PPPhraseSpec;
import simplenlg.realiser.Phrase;
import simplenlg.realiser.PhraseSpec;
import simplenlg.realiser.Realiser;
import simplenlg.realiser.SPhraseSpec;
import simplenlg.realiser.StringPhraseSpec;
import simplenlg.realiser.TextSpec;
import simplenlg.realiser.VPPhraseSpec;
import simplenlg.realiser.comparators.WordOrder;

public class SPhraseSpec
extends HeadedPhraseSpec<Verb> {
    Phrase cuePhrase = null;
    List<Phrase> subjects;
    List<Phrase> frontModifiers;
    List<Phrase> frontedElements;
    VPPhraseSpec verbPhrase = new VPPhraseSpec();
    PPPhraseSpec passiveComplement;
    CoordinatePhraseSet<Phrase> surfaceSubject;
    Object complementiser;
    ClauseStatus status;
    boolean suppressComp;
    boolean expletiveSubject;
    boolean suppressGenitiveInGerund;
    boolean interrogative;
    InterrogativeType interrogType;
    DiscourseFunction whArgument;
    DiscourseFunction relArgument;
    char terminator;
    boolean suppressPunctuationDefault;

    public SPhraseSpec() {
        this.verbPhrase.setParentSpec(this);
        this.subjects = new ArrayList<Phrase>();
        this.frontModifiers = new ArrayList<Phrase>();
        this.frontedElements = new ArrayList<Phrase>();
        this.surfaceSubject = new CoordinatePhraseSet<SPhraseSpec>(this);
        this.passiveComplement = null;
        this.status = ClauseStatus.MATRIX;
        this.category = Category.CLAUSE;
        this.complementiser = Constants.DASS.getBaseForm();
        this.suppressComp = false;
        this.expletiveSubject = false;
        this.interrogative = false;
        this.interrogType = null;
        this.whArgument = DiscourseFunction.NULL;
        this.suppressGenitiveInGerund = false;
        this.terminator = (char)46;
        this.suppressPunctuationDefault = false;
        this.relArgument = DiscourseFunction.NULL;
    }

    public SPhraseSpec(Object subject, Object verb, Object complement) {
        this(subject, verb);
        this.addComplement(complement);
    }

    public boolean isExistential() {
        boolean ex = false;
        if (this.subjects.size() == 1) {
            String string;
            Phrase subj = this.subjects.get(0);
            if (subj instanceof NPPhraseSpec) {
                Noun head = (Noun)((NPPhraseSpec)subj).getHead();
                if (head != null) {
                    ex = head.getBaseForm().equals("there");
                }
            } else if (subj instanceof StringPhraseSpec && (string = ((StringPhraseSpec)subj).getString()) != null) {
                ex = string.equals("there");
            }
        }
        return ex;
    }

    public SPhraseSpec(Object subject, Object verb) {
        this();
        if (verb instanceof String) {
            this.setHead((String)verb);
        } else if (verb instanceof Verb) {
            this.setHead((Verb)verb);
        } else {
            throw new SimplenlgException("Verb argument to SPhraseSpec constructor must be Verb or String");
        }
        this.addSubject(subject);
    }

    public void setVerb(Object verb) {
        if (verb instanceof Verb) {
            this.setHead((Verb)verb);
        } else if (verb instanceof String) {
            this.setHead((String)verb);
        } else {
            throw new SimplenlgException("Argument to SPhraseSpec.setVerb(Object) must be a Verb or String");
        }
    }

    public void setVerbPhrase(VPPhraseSpec vp) {
        boolean perf = this.isPerfect();
        boolean prog = this.isProgressive();
        boolean pass = this.isPassive();
        Tense t = this.getTense();
        vp.setParentSpec(this);
        this.verbPhrase = vp;
        this.verbPhrase.setTense(t);
        this.verbPhrase.setPerfect(perf);
        this.verbPhrase.setProgressive(prog);
        this.verbPhrase.setPassive(pass);
    }

    public void addVerbPhrase(VPPhraseSpec vp) {
        this.verbPhrase = this.verbPhrase.coordinate(new Phrase[]{vp});
        this.verbPhrase.setParentSpec(this);
    }

    public VPPhraseSpec getVerbPhrase() {
        return this.verbPhrase;
    }

    @Override
    public void setHead(Verb head) {
        this.verbPhrase.setHead(head);
    }

    @Override
    public void setHead(String head) {
        this.verbPhrase.setHead(head);
    }

    @Override
    public Verb getHead() {
        return (Verb)this.verbPhrase.getHead();
    }

    @Deprecated
    public Verb getVerb() {
        return this.getHead();
    }

    @Override
    public String getHeadAsString() {
        Verb v = this.getHead();
        if (v != null) {
            return v.getBaseForm();
        }
        return null;
    }

    @Deprecated
    public String getVerbAsString() {
        return this.getHeadAsString();
    }

    public void addVerb(Object verb) {
        VPPhraseSpec newVP = new VPPhraseSpec();
        if (verb instanceof String) {
            newVP.setHead((String)verb);
        } else if (verb instanceof Verb) {
            newVP.setHead((Verb)verb);
        } else {
            throw new SimplenlgException("Can only add String or Verb as head of SPhraseSpec.");
        }
        newVP = this.fixAllFeatures(newVP);
        if (this.verbPhrase.hasHead()) {
            if (this.verbPhrase.isCoordinate()) {
                ((CoordinateVPPhraseSpec)this.verbPhrase).addCoordinates(newVP);
            } else {
                this.verbPhrase = this.verbPhrase.coordinate(new Phrase[]{newVP});
            }
        } else {
            this.verbPhrase = newVP;
        }
    }

    public String getVerbParticle() {
        if (this.verbPhrase.hasHead()) {
            return ((Verb)this.verbPhrase.getHead()).getParticle();
        }
        return null;
    }

    public void setVerbParticle(String particle) {
        if (this.verbPhrase.hasHead()) {
            this.verbPhrase.setParticle(particle);
        }
    }

    public void suppressGenitiveInGerund(boolean suppress) {
        this.suppressGenitiveInGerund = suppress;
    }

    @Deprecated
    public void addModifier(SModifierPosition position, Object modifier) {
        switch (1.$SwitchMap$simplenlg$features$SModifierPosition[position.ordinal()]) {
            case 1: {
                this.frontModifiers.add(this.makeConstituent(modifier, DiscourseFunction.PREMODIFIER));
                break;
            }
            case 2: {
                this.verbPhrase.addPremodifier(modifier);
                break;
            }
            case 3: {
                this.verbPhrase.addPostmodifier(modifier);
            }
        }
    }

    public void addModifier(Position pos, Object mod) {
        this.verbPhrase.addModifier(pos, mod);
    }

    @Override
    public void addModifier(Object modifier) {
        this.verbPhrase.addModifier(modifier);
    }

    @Deprecated
    public void setModifier(SModifierPosition position, Object modifier) {
        switch (1.$SwitchMap$simplenlg$features$SModifierPosition[position.ordinal()]) {
            case 1: {
                this.frontModifiers.clear();
                this.frontModifiers.add(this.makeConstituent(modifier, DiscourseFunction.FRONT_MODIFIER));
                break;
            }
            case 2: {
                this.verbPhrase.setPremodifier(modifier);
                break;
            }
            case 3: {
                this.verbPhrase.setPostmodifier(modifier);
            }
        }
    }

    @Override
    @Deprecated
    public void addPremodifier(Object mod) {
        this.verbPhrase.addPremodifier(mod);
    }

    @Override
    @Deprecated
    public void setPremodifier(Object mod) {
        this.verbPhrase.setPremodifier(mod);
    }

    @Override
    @Deprecated
    public void addPostmodifier(Object mod) {
        this.verbPhrase.addPostmodifier(mod);
    }

    @Override
    @Deprecated
    public void setPostmodifier(Object mod) {
        this.verbPhrase.setPostmodifier(mod);
    }

    public List<Phrase> getSubjects() {
        return this.verbPhrase.getComplements(DiscourseFunction.SUBJECT);
    }

    public List<Phrase> getSurfaceSubjects() {
        return this.verbPhrase.getPassiveRaisingComplements();
    }

    public void addSubject(Object sub) {
        this.verbPhrase.addComplement(sub, DiscourseFunction.SUBJECT);
    }

    public void setSubject(Object sub) {
        this.verbPhrase.setComplement(sub, DiscourseFunction.SUBJECT);
    }

    public boolean hasSubject() {
        return this.verbPhrase.hasComplements(DiscourseFunction.SUBJECT);
    }

    public List<Phrase> getModifiers(SModifierPosition position) {
        switch (1.$SwitchMap$simplenlg$features$SModifierPosition[position.ordinal()]) {
            case 1: {
                return this.frontModifiers;
            }
            case 2: {
                return this.verbPhrase.getPremodifiers();
            }
            case 3: {
                return this.verbPhrase.getPostmodifiers();
            }
        }
        return null;
    }

    public List<Phrase> getModifiers(Position pos) {
        return this.getConstituents(pos);
    }

    public List<Phrase> getConstituents(Position pos) {
        return this.verbPhrase.getConstituents(pos);
    }

    @Override
    public void addComplement(Object comp) {
        this.verbPhrase.addComplement(comp);
    }

    @Override
    public void setComplement(Object comp) {
        this.verbPhrase.setComplement(comp);
    }

    public void setComplement(Object comp, DiscourseFunction function) {
        this.verbPhrase.setComplement(comp, function);
    }

    public void addComplement(DiscourseFunction func, Object comp) {
        this.verbPhrase.addComplement(comp, func);
    }

    @Override
    public List<Phrase> getComplements() {
        return this.verbPhrase.getComplements();
    }

    public List<Phrase> getComplements(DiscourseFunction func) {
        return this.verbPhrase.getComplements(func);
    }

    @Deprecated
    public List<Phrase> getIndirectObjects() {
        return this.verbPhrase.getComplements(DiscourseFunction.INDIRECT_OBJECT);
    }

    public void setCuePhrase(Object cue) {
        this.cuePhrase = this.makeConstituent(cue, DiscourseFunction.CUE_PHRASE);
    }

    public Phrase getCuePhrase() {
        return this.cuePhrase;
    }

    public void setComplementiser(Object comp) {
        this.complementiser = comp;
    }

    public void setComplementiser(NPPhraseSpec comp, DiscourseFunction func) {
        this.complementiser = comp;
        this.relArgument = func;
    }

    public Object getComplementiser() {
        return this.complementiser;
    }

    @Override
    public boolean hasPremodifiers() {
        return this.verbPhrase.hasPremodifiers();
    }

    @Override
    public boolean hasComplements() {
        return this.verbPhrase.hasComplements();
    }

    @Override
    public boolean hasPostmodifiers() {
        return this.verbPhrase.hasPostmodifiers();
    }

    public boolean hasFrontModifiers() {
        return !this.frontModifiers.isEmpty();
    }

    public List<Phrase> getFrontModifiers() {
        return this.frontModifiers;
    }

    public void addIndirectObject(Object indirectObject) {
        this.verbPhrase.addComplement(indirectObject, DiscourseFunction.INDIRECT_OBJECT);
    }

    public void setIndirectObject(Object indirectObject) {
        this.verbPhrase.setComplement(indirectObject, DiscourseFunction.INDIRECT_OBJECT);
    }

    public void addFrontModifier(Object modifier) {
        if (modifier != null) {
            PhraseSpec spec = this.makePhraseSpec(modifier);
            spec.setDiscourseFunction(DiscourseFunction.FRONT_MODIFIER);
            this.frontModifiers.add(0, spec);
        }
    }

    public void addSubordinate(Position pos, String comp, SPhraseSpec sent) {
        sent.setComplementiser(comp);
        this.addModifier(pos, (Object)sent);
    }

    @Override
    public void addSubordinate(String comp, SPhraseSpec sent) {
        sent.setComplementiser(comp);
        this.addAttributivePostmodifier(sent);
    }

    public boolean hasCuePhrase() {
        return this.cuePhrase != null;
    }

    public boolean isSubordinateClause() {
        return this.status.equals(ClauseStatus.SUBORDINATE);
    }

    public boolean isMainClause() {
        return this.status.equals(ClauseStatus.MATRIX);
    }

    public void suppressComplementiser(boolean suppress) {
        this.suppressComp = suppress;
    }

    protected boolean isRelativeWithComplementPosition() {
        return this.complementiser != null && this.complementiser instanceof NPPhraseSpec && this.relArgument != null && this.relArgument.isComplementFunction();
    }

    public void setClauseStatus(ClauseStatus type) {
        this.status = type;
    }

    public void setInterrogative(Object obj, DiscourseFunction func, boolean fronted) {
        this.verbPhrase.setInterrogative(obj, func, fronted);
        if (obj instanceof InterrogativeType) {
            this.interrogType = (InterrogativeType)obj;
            this.interrogative = true;
            this.whArgument = obj.equals(InterrogativeType.JA_NEIN) ? null : func;
            if (!this.suppressPunctuationDefault) {
                this.terminator = (char)63;
            }
        } else {
            this.interrogType = InterrogativeType.WH_ELEMENT;
            this.interrogative = true;
            if (!this.suppressPunctuationDefault) {
                this.terminator = (char)63;
            }
        }
    }

    public void setInterrogative(Object obj, DiscourseFunction func) {
        this.setInterrogative(obj, func, true);
    }

    public void setInterrogative(Object obj) {
        if (obj == null) {
            this.verbPhrase.deleteInterrogative();
            this.interrogative = false;
            this.interrogType = null;
            this.whArgument = null;
            if (!this.suppressPunctuationDefault) {
                this.terminator = (char)46;
            }
        } else if (obj instanceof InterrogativeType) {
            if (obj == InterrogativeType.WER || obj == InterrogativeType.WAS) {
                this.setInterrogative(obj, DiscourseFunction.SUBJECT);
            } else if (obj == InterrogativeType.WARUM || obj == InterrogativeType.WO || obj == InterrogativeType.WIE) {
                this.setInterrogative(obj, DiscourseFunction.MODIFIER);
            } else {
                this.setInterrogative(obj, DiscourseFunction.NULL);
            }
        } else {
            this.setInterrogative(obj, DiscourseFunction.NULL);
        }
    }

    public void setEchoInterrogative(Object obj) {
        this.setClauseStatus(ClauseStatus.SUBORDINATE);
        this.suppressComplementiser(true);
        this.setInterrogative(obj);
    }

    public void setEchoInterrogative(Object obj, DiscourseFunction func) {
        this.setClauseStatus(ClauseStatus.SUBORDINATE);
        this.suppressComplementiser(true);
        this.setInterrogative(obj, func);
    }

    public boolean isInterrogative() {
        return this.interrogative;
    }

    public InterrogativeType getInterrogativeType() {
        return this.interrogType;
    }

    public DiscourseFunction getWhArgument() {
        return this.whArgument;
    }

    public void setSentenceTerminator(char terminator) {
        this.terminator = terminator;
        this.suppressPunctuationDefault = true;
    }

    public char getSentenceTerminator() {
        return this.terminator;
    }

    public void setTense(Tense t) {
        this.verbPhrase.setTense(t);
    }

    public Tense getTense() {
        return this.verbPhrase.getTense();
    }

    public Verb getModal() {
        return this.verbPhrase.getModal();
    }

    public void setModal(String modal) {
        this.verbPhrase.setModal(modal);
    }

    public void setModal(Verb modal) {
        this.verbPhrase.setModal(modal);
    }

    public void addModal(String modal) {
        this.verbPhrase.addModal(modal);
    }

    public void addModal(Verb modal) {
        this.verbPhrase.addModal(modal);
    }

    public boolean isMainVerbPerfect() {
        return this.verbPhrase.isMainVerbPerfect();
    }

    public void setMainVerbPerfect(boolean perfect) {
        this.verbPhrase.setMainVerbPerfect(perfect);
    }

    public void setForm(Form f) {
        if (f.equals(Form.IMPERATIVE)) {
            if (!this.suppressPunctuationDefault) {
                this.terminator = (char)33;
            }
        } else if (!this.suppressPunctuationDefault) {
            this.terminator = (char)46;
        }
        this.verbPhrase.setForm(f);
    }

    public Form getForm() {
        return this.verbPhrase.getForm();
    }

    public void setPerfect(boolean perf) {
        this.verbPhrase.setPerfect(perf);
    }

    public boolean isPerfect() {
        return this.verbPhrase.isPerfect();
    }

    public void setProgressive(boolean prog) {
        this.verbPhrase.setProgressive(prog);
    }

    public boolean isProgressive() {
        return this.verbPhrase.isProgressive();
    }

    @Override
    public void setNegated(boolean neg) {
        this.verbPhrase.setNegated(neg);
    }

    @Override
    public boolean isNegated() {
        return this.verbPhrase.isNegated();
    }

    public boolean isPassive() {
        return this.verbPhrase.isPassive();
    }

    public void setPassive(boolean pass) {
        this.verbPhrase.setPassive(pass);
    }

    public Position getPassiveComplementPosition() {
        return this.verbPhrase.getPassiveComplementPosition();
    }

    public void setPassiveComplementPosition(Position passiveComplementPosition) {
        this.verbPhrase.setPassiveComplementPosition(passiveComplementPosition);
    }

    public boolean isPassiveComplementRealisation() {
        return this.verbPhrase.isPassiveComplementRealisation();
    }

    public void setPassiveComplementRealisation(boolean passiveComplementRealisation) {
        this.verbPhrase.setPassiveComplementRealisation(passiveComplementRealisation);
    }

    public void setImperativeForm(NumberAgr num, boolean honorific) {
        if (!this.suppressPunctuationDefault) {
            this.terminator = (char)33;
        }
        this.verbPhrase.setImperativeForm(num, honorific);
    }

    public WordOrder getWordOrder() {
        return this.verbPhrase.getWordOrder();
    }

    public void setWordOrder(WordOrder order) {
        this.verbPhrase.setWordOrder(order);
    }

    public SPhraseSpec coordinate(Phrase ... coords) {
        if (coords.length == 0) {
            return this;
        }
        CoordinateSPhraseSpec csp = new CoordinateSPhraseSpec(this);
        try {
            for (Phrase p : coords) {
                csp.addCoordinates((SPhraseSpec)p);
            }
            return csp;
        }
        catch (ClassCastException cce) {
            throw new SimplenlgException("Cannot coordinate: only phrases of the same type can be coordinated");
        }
    }

    @Override
    public boolean equals(Object o) {
        boolean eq = false;
        if (o instanceof SPhraseSpec) {
            SPhraseSpec s = (SPhraseSpec)o;
            eq = !(this.cuePhrase != s.cuePhrase && !this.cuePhrase.equals(s.cuePhrase) || this.verbPhrase != s.verbPhrase && !this.verbPhrase.equals(s.verbPhrase) || !this.frontModifiers.equals(s.frontModifiers) || !this.subjects.equals(s.subjects));
        }
        return eq;
    }

    boolean isBeVerb(String verb) {
        return verb.equalsIgnoreCase("be") || verb.equalsIgnoreCase("am") || verb.equalsIgnoreCase("are") || verb.equalsIgnoreCase("is") || verb.equalsIgnoreCase("was") || verb.equalsIgnoreCase("were");
    }

    @Override
    String realise(Realiser r) {
        String result;
        this.verbPhrase.initialiseArgs();
        this.computeForm();
        String cuePhraseText = r.realise(this.cuePhrase);
        String frontModifierText = r.realiseConjunctList(this.frontModifiers, ",");
        String verbText = this.verbPhrase.realise(r, this.isSubordinateClause());
        String mainSent = "";
        String attribModifierText = r.realiseConjunctList(this.attributiveModifiers, ",");
        if (!attribModifierText.isEmpty()) {
            attribModifierText = r.appendSpace(",", attribModifierText);
        }
        String frontSeparator = frontModifierText.length() == 0 || cuePhraseText != null && cuePhraseText.endsWith(",") ? "" : ",";
        mainSent = r.appendSpace(cuePhraseText, frontModifierText, frontSeparator, verbText, attribModifierText);
        if (this.isSubordinateClause() && !this.suppressComp) {
            if (this.isRelativeWithComplementPosition()) {
                ((NPPhraseSpec)this.complementiser).setCase(this.relArgument.getCaseValue());
            }
            mainSent = r.appendSpace(r.realise(this.complementiser), mainSent);
        }
        if (this.parentSpec != null) {
            if (this.parentSpec instanceof TextSpec && ((TextSpec)this.parentSpec).hasDefaultCaps()) {
                ((TextSpec)this.parentSpec).setDefaultCaps(this.canCapitaliseFirstChar());
            }
            result = mainSent;
        } else {
            result = r.applySentenceOrthography(mainSent, this.terminator, this.canCapitaliseFirstChar());
        }
        return result;
    }

    boolean canCapitaliseFirstChar() {
        Phrase first;
        List<Phrase> subjects = this.surfaceSubject.getCoordinates();
        boolean capitalise = true;
        if (!subjects.isEmpty() && (first = subjects.get(0)) instanceof NPPhraseSpec) {
            NPPhraseSpec np = (NPPhraseSpec)first;
            capitalise = !np.isAcronym() || np.hasSpecifier();
        }
        return capitalise;
    }

    boolean needsFrontAuxiliary() {
        if (this.interrogative) {
            if (this.interrogType.isWhQuestion()) {
                return !this.whArgument.equals(DiscourseFunction.SUBJECT) || this.isPassive();
            }
            return true;
        }
        return false;
    }

    String getInterrogativeElements(Realiser r) {
        String fronted = "";
        if (this.interrogative && !this.interrogType.equals(InterrogativeType.JA_NEIN)) {
            NPPhraseSpec inp = (NPPhraseSpec)this.makeConstituent(new NPPhraseSpec(Constants.getInterrogative(this.interrogType)), this.whArgument);
            fronted = inp.realise(r);
        }
        return fronted;
    }

    void buildPassiveComplement(boolean comps) {
        List<Phrase> actualSubjects = this.getNonElidedSubjects();
        if (!actualSubjects.isEmpty()) {
            this.passiveComplement = new PPPhraseSpec(Constants.PASSIVE_VON);
            if (comps) {
                for (Phrase p : actualSubjects) {
                    p.setDiscourseFunction(DiscourseFunction.PREP_OBJECT);
                    this.passiveComplement.addComplement(p);
                }
            }
        }
    }

    List<Phrase> getNonElidedSubjects() {
        ArrayList<Phrase> subjects = new ArrayList<Phrase>();
        for (Phrase p : this.subjects) {
            if (p.isElided()) continue;
            subjects.add(p);
        }
        return subjects;
    }

    protected void computeSurfaceArgs() {
        this.surfaceSubject.clearCoordinates();
        this.passiveComplement = null;
        if (this.isPassive()) {
            if (this.interrogative && this.interrogType.isWhQuestion()) {
                switch (1.$SwitchMap$simplenlg$features$DiscourseFunction[this.whArgument.ordinal()]) {
                    case 1: {
                        this.buildPassiveComplement(false);
                        this.surfaceSubject.addCoordinates(this.verbPhrase.getPassiveRaisingComplements());
                        break;
                    }
                    case 2: {
                        this.verbPhrase.suppressArg(DiscourseFunction.INDIRECT_OBJECT);
                        break;
                    }
                    default: {
                        this.buildPassiveComplement(true);
                        break;
                    }
                }
            } else {
                this.surfaceSubject.addCoordinates(this.verbPhrase.getPassiveRaisingComplements());
                this.buildPassiveComplement(true);
            }
        } else if (this.interrogative && this.interrogType.isWhQuestion()) {
            switch (1.$SwitchMap$simplenlg$features$DiscourseFunction[this.whArgument.ordinal()]) {
                case 1: {
                    break;
                }
                default: {
                    this.verbPhrase.suppressArg(this.whArgument);
                    this.surfaceSubject.addCoordinates(this.subjects);
                    break;
                }
            }
        } else {
            this.surfaceSubject.addCoordinates(this.subjects);
        }
        for (Phrase p : this.surfaceSubject.getCoordinates()) {
            if (!(p instanceof NPPhraseSpec)) continue;
            ((NPPhraseSpec)p).setCase(Case.NOMINATIVE);
        }
        if (this.passiveComplement != null) {
            this.verbPhrase.addModifier(this.passiveComplement);
        }
    }

    protected void computeForm() {
        switch (1.$SwitchMap$simplenlg$features$DiscourseFunction[this.getDiscourseFunction().ordinal()]) {
            case 3: {
                this.verbPhrase.setDiscourseFunction(DiscourseFunction.OBJECT);
                this.suppressComplementiser(true);
                break;
            }
        }
        switch (1.$SwitchMap$simplenlg$features$Form[this.getForm().ordinal()]) {
            case 1: {
                this.verbPhrase.suppressArg(DiscourseFunction.SUBJECT);
                break;
            }
            case 2: {
                this.verbPhrase.suppressArg(DiscourseFunction.SUBJECT);
                for (Phrase p : this.frontModifiers) {
                    this.verbPhrase.addPostmodifier(p);
                }
                this.frontModifiers.clear();
                break;
            }
        }
        if (this.isRelativeWithComplementPosition()) {
            this.verbPhrase.suppressArg(this.relArgument);
        }
    }

    String getVorfeldText(Realiser r) {
        if (this.interrogative && !this.interrogType.equals(InterrogativeType.WH_ELEMENT)) {
            if (this.interrogType == InterrogativeType.JA_NEIN) {
                for (Phrase p : this.surfaceSubject.coordinates) {
                    this.verbPhrase.addComplement(p, DiscourseFunction.SUBJECT);
                }
                return "";
            }
            if (this.whArgument != DiscourseFunction.SUBJECT) {
                for (Phrase p : this.surfaceSubject.coordinates) {
                    this.verbPhrase.addComplement(p, DiscourseFunction.SUBJECT);
                }
            }
            return this.getInterrogativeElements(r);
        }
        if (this.frontedElements.isEmpty()) {
            return this.surfaceSubject.realise(r);
        }
        for (Phrase p : this.surfaceSubject.coordinates) {
            this.verbPhrase.addComplement(p, DiscourseFunction.SUBJECT);
        }
        String sep = "";
        if (this.frontedElements.get(0) instanceof SPhraseSpec) {
            sep = ",";
        }
        return r.realiseList(this.frontedElements) + sep;
    }

    protected Person getPersonFeature(List<Phrase> agreeNP) {
        Phrase agr;
        if (agreeNP.size() == 1 && (agr = agreeNP.get(0)) instanceof NPPhraseSpec) {
            return ((NPPhraseSpec)agr).getPerson();
        }
        return Person.THIRD;
    }

    protected NumberAgr getNumberFeature(List<Phrase> agreeNP) {
        if (agreeNP.size() == 1) {
            Phrase agr = agreeNP.get(0);
            if (agr instanceof NPPhraseSpec) {
                return ((NPPhraseSpec)agr).getNumber();
            }
            if (agr instanceof StringPhraseSpec && ((StringPhraseSpec)agr).isPlural()) {
                return NumberAgr.PLURAL;
            }
            if (agr.isCoordinate()) {
                return NumberAgr.PLURAL;
            }
        } else if (agreeNP.size() > 1) {
            return NumberAgr.PLURAL;
        }
        return NumberAgr.SINGULAR;
    }

    protected VPPhraseSpec fixAllFeatures(VPPhraseSpec newVP) {
        newVP.setForm(this.getForm());
        newVP.setModal(this.getModal());
        newVP.setNegated(this.isNegated());
        newVP.setTense(this.getTense());
        newVP.setPerfect(this.isPerfect());
        newVP.setPassive(this.isPassive());
        newVP.setProgressive(this.isProgressive());
        return newVP;
    }

    protected boolean isExpletiveSubject() {
        if (this.subjects.size() > 1) {
            return false;
        }
        if (this.subjects.size() == 1) {
            Phrase subjectNP = this.subjects.get(0);
            if (subjectNP instanceof NPPhraseSpec) {
                return ((NPPhraseSpec)subjectNP).isExpletive();
            }
            if (subjectNP instanceof StringPhraseSpec) {
                return ((StringPhraseSpec)subjectNP).getString().equals("es");
            }
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SENTENCE: [");
        builder.append("Verb = ");
        if (this.verbPhrase != null) {
            Verb head = (Verb)this.verbPhrase.getHead();
            builder.append(head == null ? "null" : head.getBaseForm());
        }
        builder.append("]");
        return builder.toString();
    }
}

