/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon.lexicalitems;

import simplenlg.features.Agreement;
import simplenlg.features.Case;
import simplenlg.features.Category;
import simplenlg.features.Deixis;
import simplenlg.features.Gender;
import simplenlg.features.NumberAgr;
import simplenlg.features.Quantification;
import simplenlg.lexicon.lexicalitems.Constants;
import simplenlg.lexicon.lexicalitems.Determiner;
import simplenlg.lexicon.lexicalitems.Word;
import simplenlg.lexicon.morph.InflectionPattern;

public class Determiner
extends Word {
    Deixis deixis;
    Quantification quantification;
    Agreement agreement;
    NumberAgr number;
    Case cs;
    Gender gender;
    String[] mascForms;
    String[] femForms;
    String[] neutForms;
    String[] pluralForms;
    InflectionPattern<Determiner> pattern;

    public Determiner(String baseform) {
        super(baseform);
        this.category = Category.DETERMINER;
    }

    public Determiner(String id, String baseform) {
        this(baseform);
        this.setID(id);
    }

    public Determiner(String id, String baseform, String citationform) {
        this(id, baseform);
        this.setCitationForm(citationform);
    }

    public Determiner(String baseform, Gender g) {
        this(baseform);
        this.setGender(g);
    }

    public Determiner(String baseform, Gender g, boolean definite) {
        this(baseform, g);
        this.setQuantification(definite ? Quantification.DEFINITE : Quantification.INDEFINITE);
    }

    public Determiner(String baseform, NumberAgr n, Gender g, Case c) {
        this(baseform);
        this.setNumber(n);
        this.setCase(c);
        this.setGender(g);
    }

    public Determiner(String[] mascForms, String[] femForms, String[] neutForms, String[] pluralForms, boolean definite) {
        this(mascForms[0]);
        this.mascForms = mascForms;
        this.femForms = femForms;
        this.neutForms = neutForms;
        this.pluralForms = pluralForms;
        this.setQuantification(definite ? Quantification.DEFINITE : Quantification.INDEFINITE);
    }

    public Determiner(String baseform, InflectionPattern<Determiner> pattern, boolean definite) {
        this(baseform);
        this.pattern = pattern;
        this.setQuantification(definite ? Quantification.DEFINITE : Quantification.INDEFINITE);
    }

    @Deprecated
    public Determiner(String baseform, boolean definite) {
        this(baseform);
    }

    public String getForm(Case cas, NumberAgr num, Gender gen) {
        String[] allForms;
        if (this.pattern != null) {
            return this.pattern.apply(this.baseForm, cas, num, gen);
        }
        boolean plural = num == NumberAgr.PLURAL;
        switch (1.$SwitchMap$simplenlg$features$Gender[gen.ordinal()]) {
            case 1: {
                allForms = this.mascForms;
                break;
            }
            case 2: {
                allForms = this.femForms;
                break;
            }
            default: {
                allForms = this.neutForms;
            }
        }
        switch (1.$SwitchMap$simplenlg$features$Case[cas.ordinal()]) {
            case 1: {
                return plural ? this.pluralForms[1] : allForms[1];
            }
            case 2: {
                return plural ? this.pluralForms[2] : allForms[2];
            }
            case 3: {
                return plural ? this.pluralForms[3] : allForms[3];
            }
        }
        return plural ? this.pluralForms[0] : allForms[0];
    }

    public String getForm() {
        return this.getForm(this.cs, this.number, this.gender);
    }

    public String getForm(Case cas) {
        return this.getForm(cas, this.number, this.gender);
    }

    public String getForm(Case cas, NumberAgr num) {
        return this.getForm(cas, num, this.gender);
    }

    public boolean isDefinite() {
        return this.quantification == Quantification.DEFINITE;
    }

    public NumberAgr getNumber() {
        return this.number;
    }

    public void setNumber(NumberAgr number) {
        this.number = number;
    }

    public Case getCase() {
        return this.cs;
    }

    public void setCase(Case cs) {
        this.cs = cs;
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public Deixis getDeixis() {
        return this.deixis;
    }

    public void setDeixis(Deixis deixis) {
        this.deixis = deixis;
    }

    public Quantification getQuantification() {
        return this.quantification;
    }

    public void setQuantification(Quantification quantification) {
        this.quantification = quantification;
    }

    public Agreement getAgreement() {
        return this.agreement;
    }

    public void setAgreement(Agreement agreement) {
        this.agreement = agreement;
    }

    @Deprecated
    public String getForm(String phonAgreementString) {
        return this.baseForm;
    }

    @Deprecated
    public static Determiner getDeterminer(String word) {
        return Constants.getDeterminer(word);
    }
}

