/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon.lexicalitems;

import simplenlg.features.AuxType;
import simplenlg.features.Case;
import simplenlg.features.ConjunctionType;
import simplenlg.features.Gender;
import simplenlg.features.InterrogativeType;
import simplenlg.features.NumberAgr;
import simplenlg.features.Person;
import simplenlg.features.VerbType;
import simplenlg.features.WordMorph;
import simplenlg.lexicon.lexicalitems.Conjunction;
import simplenlg.lexicon.lexicalitems.Constants;
import simplenlg.lexicon.lexicalitems.Determiner;
import simplenlg.lexicon.lexicalitems.Preposition;
import simplenlg.lexicon.lexicalitems.Pronoun;
import simplenlg.lexicon.lexicalitems.Verb;
import simplenlg.lexicon.morph.InflectionPattern;
import simplenlg.lexicon.morph.VerbInflectionPattern;
import simplenlg.realiser.NPPhraseSpec;

public class Constants {
    public static VerbInflectionPattern VERB_INFLECTION_DEFAULT = new VerbInflectionPattern("default", new String[]{"e", "st", "t", "en", "t", "en"}, new String[]{"", "st", "", "en", "t", "en"}, new String[]{"e", "est", "e", "en", "et", "en"}, new String[]{"e", "est", "e", "en", "et", "en"}, new String[]{"e", "t"});
    public static VerbInflectionPattern VERB_INFLECTION_NO_IMP_E = VERB_INFLECTION_DEFAULT.clone("no imperative-e", new String[]{"", "t"});
    public static VerbInflectionPattern VERB_INFLECTION_ALT_IMPERATIVE = VERB_INFLECTION_NO_IMP_E.clone("alt. imperative", WordMorph.ALTERNATE_IMPERATIVE);
    public static VerbInflectionPattern VERB_INFLECTION_ERN = new VerbInflectionPattern("ern/eln", new String[]{"e", "st", "t", "n", "t", "n"}, new String[]{"", "st", "", "en", "t", "en"}, new String[]{"e", "st", "e", "n", "t", "n"}, new String[]{"e", "est", "e", "en", "et", "en"}, new String[]{"e", "t"});
    public static VerbInflectionPattern VERB_INFLECTION_ERN_ELISION = VERB_INFLECTION_ERN.clone("ern/eln elision", WordMorph.STEM_E_ELISION);
    public static VerbInflectionPattern VERB_INFLECTION_EPENTHESIS = new VerbInflectionPattern("epenthesis", new String[]{"e", "st", "t", "en", "et", "en"}, new String[]{"", "st", "", "en", "et", "en"}, new String[]{"e", "est", "e", "en", "et", "en"}, new String[]{"e", "est", "e", "en", "et", "en"}, new String[]{"e", "et"});
    public static VerbInflectionPattern VERB_INFLECTION_MODAL = new VerbInflectionPattern("modal", new String[]{"", "st", "", "en", "t", "en"}, new String[]{"", "st", "", "en", "t", "en"}, new String[]{"e", "est", "e", "en", "et", "en"}, new String[]{"e", "est", "e", "en", "et", "en"}, new String[]{"e", "t"}, WordMorph.MODAL_INFLECTION);
    public static VerbInflectionPattern VERB_INFLECTION_TUN = new VerbInflectionPattern("tun", new String[]{"e", "st", "t", "n", "t", "n"}, new String[]{"", "st", "", "en", "et", "en"}, new String[]{"e", "est", "e", "en", "et", "en"}, new String[]{"e", "est", "e", "en", "et", "en"}, new String[]{"e", "t"});
    public static VerbInflectionPattern VERB_INFLECTION_WERDEN = new VerbInflectionPattern("werden", new String[]{"e", "st", "d", "en", "et", "en"}, new String[]{"", "st", "", "en", "et", "en"}, new String[]{"e", "est", "e", "en", "et", "en"}, new String[]{"e", "est", "e", "en", "et", "en"}, new String[]{"e", "et"});
    public static VerbInflectionPattern VERB_INFLECTION_SEIN = new VerbInflectionPattern("sein", new String[]{"bin", "bist", "ist", "sind", "seid", "sind"}, new String[]{"war", "warst", "war", "waren", "wart", "waren"}, new String[]{"sei", "seist", "sei", "seien", "seiet", "seien"}, new String[]{"w\u00e4re", "w\u00e4rst", "w\u00e4re", "w\u00e4ren", "w\u00e4rt", "w\u00e4ren"}, new String[]{"sei", "seid"}, WordMorph.FULL_FORMS);
    public static VerbInflectionPattern[] ALL_INFLECTION_PATTERNS = new VerbInflectionPattern[]{VERB_INFLECTION_ALT_IMPERATIVE, VERB_INFLECTION_DEFAULT, VERB_INFLECTION_EPENTHESIS, VERB_INFLECTION_ERN, VERB_INFLECTION_ERN_ELISION, VERB_INFLECTION_MODAL, VERB_INFLECTION_NO_IMP_E, VERB_INFLECTION_SEIN, VERB_INFLECTION_TUN, VERB_INFLECTION_WERDEN};
    public static final String[] ALL_DEFINITE = new String[]{"der", "die", "das", "den", "dem", "des"};
    public static final String[] ALL_INDEFINITE = new String[]{"ein", "eine", "einer", "eines", "einem", "einen", "einige", "einiger", "einigen"};
    public static final InflectionPattern<Determiner> DEFINITE_DET_PATTERN = new InflectionPattern(new String[]{"der", "den", "des", "dem"}, new String[]{"die", "die", "der", "der"}, new String[]{"das", "das", "des", "dem"}, new String[]{"die", "die", "der", "den"}, WordMorph.FULL_FORMS);
    public static final Determiner DEFINITE_DET = new Determiner("der", DEFINITE_DET_PATTERN, true);
    public static final InflectionPattern<Determiner> INDEFINITE_DET_PATTERN = new InflectionPattern(new String[]{"ein", "einen", "eines", "einem"}, new String[]{"eine", "eine", "einer", "einer"}, new String[]{"ein", "ein", "eines", "einem"}, new String[]{"einige", "einige", "einiger", "einigen"}, WordMorph.FULL_FORMS);
    public static final Determiner INDEFINITE_DET = new Determiner("ein", INDEFINITE_DET_PATTERN, false);
    public static final Determiner[] ALL_DETERMINERS = new Determiner[]{DEFINITE_DET, INDEFINITE_DET};
    public static final Verb AUX_WERDEN = new Verb("werden", "wurde", "geworden", "wir", "w\u00fcrde", AuxType.SEIN, VerbType.AUX, VERB_INFLECTION_WERDEN);
    public static final Verb AUX_HABEN = new Verb("haben", "hatte", "gehabt", "ha", "h\u00e4tte", AuxType.HABEN, VerbType.AUX, VERB_INFLECTION_DEFAULT);
    public static final Verb AUX_SEIN = new Verb("sein", "war", "gewesen", "", "w\u00e4r", "seiend", AuxType.SEIN, VerbType.AUX, VERB_INFLECTION_SEIN);
    public static final Verb[] ALL_AUXILIARIES = new Verb[]{AUX_HABEN, AUX_SEIN, AUX_WERDEN};
    public static final Verb D\u00dcRFEN = new Verb("d\u00fcrfen", "durfte", "gedurft", "darf", "d\u00fcrfte", AuxType.HABEN, VerbType.MODAL, VERB_INFLECTION_MODAL);
    public static final Verb BED\u00dcRFEN = new Verb("bed\u00fcrfen", "bedurfte", "bedurft", "bedarf", "bed\u00fcrfte", AuxType.HABEN, VerbType.MODAL, VERB_INFLECTION_MODAL);
    public static final Verb K\u00d6NNEN = new Verb("k\u00f6nnen", "konnte", "gekonnt", "kann", "k\u00f6nnte", AuxType.HABEN, VerbType.MODAL, VERB_INFLECTION_MODAL);
    public static final Verb M\u00d6GEN = new Verb("m\u00f6gen", "mochte", "gemocht", "mag", "m\u00f6chte", AuxType.HABEN, VerbType.MODAL, VERB_INFLECTION_MODAL);
    public static final Verb VERM\u00d6GEN = new Verb("verm\u00f6gen", "vermochte", "vermocht", "vermag", "verm\u00f6chte", AuxType.HABEN, VerbType.MODAL, VERB_INFLECTION_MODAL);
    public static final Verb M\u00dcSSEN = new Verb("m\u00fcssen", "musste", "gemusst", "muss", "m\u00fcsste", AuxType.HABEN, VerbType.MODAL, VERB_INFLECTION_MODAL);
    public static final Verb SOLLEN = new Verb("sollen", "sollte", "gesollt", "soll", "", AuxType.HABEN, VerbType.MODAL, VERB_INFLECTION_MODAL);
    public static final Verb WOLLEN = new Verb("wollen", "wollte", "gewollt", "will", "", AuxType.HABEN, VerbType.MODAL, VERB_INFLECTION_MODAL);
    public static final Verb[] ALL_MODALS = new Verb[]{D\u00dcRFEN, K\u00d6NNEN, M\u00d6GEN, M\u00dcSSEN, SOLLEN, WOLLEN};
    public static final Verb WISSEN = new Verb("wissen", "wusste", "gewusst", "wei\u00df", "w\u00fcsste", AuxType.HABEN, VERB_INFLECTION_MODAL);
    public static final InflectionPattern<Pronoun> PERS_PRO_1ST_PATTERN = new InflectionPattern(new String[]{"ich", "mich", "meiner", "mir"}, new String[]{"wir", "uns", "unser", "uns"}, WordMorph.FULL_FORMS);
    public static final InflectionPattern<Pronoun> PERS_PRO_2ND_PATTERN = new InflectionPattern(new String[]{"du", "dich", "deiner", "dir"}, new String[]{"ihr", "euch", "euer", "euch"}, WordMorph.FULL_FORMS);
    public static final InflectionPattern<Pronoun> PERS_PRO_HON_PATTERN = new InflectionPattern(new String[]{"Sie", "Sie", "Ihrer", "Ihnen"}, new String[]{"Sie", "Sie", "Ihrer", "Ihnen"}, WordMorph.FULL_FORMS);
    public static final InflectionPattern<Pronoun> PERS_PRO_3RD_PATTERN = new InflectionPattern(new String[]{"er", "ihn", "seiner", "ihm"}, new String[]{"sie", "sie", "ihrer", "ihr"}, new String[]{"es", "es", "seiner", "ihm"}, new String[]{"sie", "sie", "ihrer", "ihnen"}, WordMorph.FULL_FORMS);
    public static final Pronoun PRO_1ST = new Pronoun("ich", PERS_PRO_1ST_PATTERN, PERS_PRO_1ST_PATTERN, Person.FIRST);
    public static final Pronoun PRO_2ND = new Pronoun("du", PERS_PRO_2ND_PATTERN, PERS_PRO_2ND_PATTERN, Person.SECOND);
    public static final Pronoun PRO_3RD = new Pronoun("er", PERS_PRO_3RD_PATTERN, PERS_PRO_3RD_PATTERN, Person.THIRD);
    public static final Pronoun PRO_HON = new Pronoun("Sie", PERS_PRO_HON_PATTERN, PERS_PRO_HON_PATTERN, Person.THIRD);
    public static final Pronoun PRO_EXPLETIVE = new Pronoun("es", "es", "seiner", "ihm", "sie", "sie", "ihrer", "ihnen", Person.THIRD, Gender.NEUTER);
    public static final Pronoun[] PERSONAL_PRONOUNS = new Pronoun[]{PRO_1ST, PRO_2ND, PRO_3RD, PRO_HON};
    public static final InflectionPattern<Pronoun> REFL_PRO_3RD_PATTERN = new InflectionPattern(new String[]{"", "sich", "seiner", "sich"}, new String[]{"", "sich", "ihrer", "sich"}, new String[]{"", "sich", "seiner", "sich"}, new String[]{"", "sich", "ihrer", "sich"}, WordMorph.FULL_FORMS);
    public static final Pronoun PRO_REFLEXIVE_3RD = new Pronoun("sich", REFL_PRO_3RD_PATTERN, REFL_PRO_3RD_PATTERN, Person.THIRD);
    public static final InflectionPattern<Pronoun> POSS_ART_PATTERN = new InflectionPattern(new String[]{"", "en", "es", "em"}, new String[]{"e", "e", "er", "er"}, new String[]{"", "", "es", "em"}, new String[]{"e", "e", "er", "en"});
    public static final InflectionPattern<Pronoun> POSS_ART_ELISION_PATTERN = new InflectionPattern(new String[]{"", "en", "es", "em"}, new String[]{"e", "e", "er", "er"}, new String[]{"", "", "es", "em"}, new String[]{"e", "e", "er", "en"}, WordMorph.STEM_E_ELISION);
    public static final InflectionPattern<Pronoun> POSS_NOUN_PATTERN = new InflectionPattern(new String[]{"er", "en", "es", "em"}, new String[]{"e", "e", "er", "er"}, new String[]{"es", "es", "es", "em"}, new String[]{"e", "e", "er", "en"});
    public static final InflectionPattern<Pronoun> POSS_NOUN_ELISION_PATTERN = new InflectionPattern(new String[]{"er", "en", "es", "em"}, new String[]{"e", "e", "er", "er"}, new String[]{"es", "es", "es", "em"}, new String[]{"e", "e", "er", "en"}, WordMorph.STEM_E_ELISION);
    public static final Pronoun PRO_POSS_1ST_SG = new Pronoun("mein", POSS_ART_PATTERN, POSS_NOUN_PATTERN, Person.FIRST, NumberAgr.SINGULAR);
    public static final Pronoun PRO_POSS_1ST_PL = new Pronoun("unser", POSS_ART_PATTERN, POSS_NOUN_PATTERN, Person.FIRST, NumberAgr.PLURAL);
    public static final Pronoun PRO_POSS_2ND_SG = new Pronoun("dein", POSS_ART_PATTERN, POSS_NOUN_PATTERN, Person.SECOND, NumberAgr.SINGULAR);
    public static final Pronoun PRO_POSS_2ND_PL = new Pronoun("euer", POSS_ART_ELISION_PATTERN, POSS_NOUN_ELISION_PATTERN, Person.SECOND, NumberAgr.PLURAL);
    public static final Pronoun PRO_POSS_3RD_SG_MASC = new Pronoun("sein", POSS_ART_PATTERN, POSS_NOUN_PATTERN, Person.THIRD, NumberAgr.SINGULAR, Gender.MASCULINE);
    public static final Pronoun PRO_POSS_3RD_SG_NEUT = new Pronoun("sein", POSS_ART_PATTERN, POSS_NOUN_PATTERN, Person.THIRD, NumberAgr.SINGULAR, Gender.NEUTER);
    public static final Pronoun PRO_POSS_3RD_SG_FEM = new Pronoun("ihr", POSS_ART_PATTERN, POSS_NOUN_PATTERN, Person.THIRD, NumberAgr.SINGULAR, Gender.FEMININE);
    public static final Pronoun PRO_POSS_3RD_PL = new Pronoun("ihr", POSS_ART_PATTERN, POSS_NOUN_PATTERN, Person.THIRD, NumberAgr.PLURAL);
    public static final Pronoun PRO_POSS_HON = new Pronoun("Ihr", POSS_ART_PATTERN, POSS_NOUN_PATTERN, Person.THIRD, NumberAgr.PLURAL);
    public static final InflectionPattern<Pronoun> PRO_WEAK_ADJ_PATTERN = new InflectionPattern(new String[]{"", "n", "n", "n"}, new String[]{"", "", "n", "n"}, new String[]{"", "", "n", "n"}, new String[]{"n", "n", "n", "n"});
    public static final InflectionPattern<Pronoun> PRO_STRONG_ADJ_PATTERN = new InflectionPattern(new String[]{"r", "n", "n", "m"}, new String[]{"", "", "r", "r"}, new String[]{"s", "s", "n", "m"}, new String[]{"", "", "r", "n"});
    public static final Pronoun PRO_POSS_ALT_1ST_SG = new Pronoun("meinige", PRO_WEAK_ADJ_PATTERN, PRO_WEAK_ADJ_PATTERN, Person.FIRST, NumberAgr.SINGULAR);
    public static final Pronoun PRO_POSS_ALT_1ST_PL = new Pronoun("unsrige", PRO_WEAK_ADJ_PATTERN, PRO_WEAK_ADJ_PATTERN, Person.FIRST, NumberAgr.PLURAL);
    public static final Pronoun PRO_POSS_ALT_2ND_SG = new Pronoun("deinige", PRO_WEAK_ADJ_PATTERN, PRO_WEAK_ADJ_PATTERN, Person.SECOND, NumberAgr.SINGULAR);
    public static final Pronoun PRO_POSS_ALT_2ND_PL = new Pronoun("eurige", PRO_WEAK_ADJ_PATTERN, PRO_WEAK_ADJ_PATTERN, Person.SECOND, NumberAgr.PLURAL);
    public static final Pronoun PRO_POSS_ALT_3RD_SG_MASC = new Pronoun("seinige", PRO_WEAK_ADJ_PATTERN, PRO_WEAK_ADJ_PATTERN, Person.THIRD, NumberAgr.SINGULAR, Gender.MASCULINE);
    public static final Pronoun PRO_POSS_ALT_3RD_SG_NEUT = new Pronoun("seinige", PRO_WEAK_ADJ_PATTERN, PRO_WEAK_ADJ_PATTERN, Person.THIRD, NumberAgr.SINGULAR, Gender.NEUTER);
    public static final Pronoun PRO_POSS_ALT_3RD_SG_FEM = new Pronoun("ihrige", PRO_WEAK_ADJ_PATTERN, PRO_WEAK_ADJ_PATTERN, Person.THIRD, NumberAgr.SINGULAR, Gender.FEMININE);
    public static final Pronoun PRO_POSS_ALT_3RD_PL = new Pronoun("ihrige", PRO_WEAK_ADJ_PATTERN, PRO_WEAK_ADJ_PATTERN, Person.THIRD, NumberAgr.PLURAL);
    public static final Pronoun PRO_POSS_ALT_HON = new Pronoun("Ihrige", PRO_WEAK_ADJ_PATTERN, PRO_WEAK_ADJ_PATTERN, Person.THIRD, NumberAgr.PLURAL);
    public static final Pronoun[] POSSESSIVE_PRONOUNS = new Pronoun[]{PRO_POSS_1ST_SG, PRO_POSS_1ST_PL, PRO_POSS_2ND_SG, PRO_POSS_2ND_PL, PRO_POSS_3RD_SG_MASC, PRO_POSS_3RD_SG_NEUT, PRO_POSS_3RD_SG_FEM, PRO_POSS_3RD_PL, PRO_POSS_HON, PRO_POSS_ALT_1ST_SG, PRO_POSS_ALT_1ST_PL, PRO_POSS_ALT_2ND_SG, PRO_POSS_ALT_2ND_PL, PRO_POSS_ALT_3RD_SG_MASC, PRO_POSS_ALT_3RD_SG_NEUT, PRO_POSS_ALT_3RD_SG_FEM, PRO_POSS_ALT_3RD_PL, PRO_POSS_ALT_HON};
    public static final InflectionPattern<Pronoun> DEM_PRON_DERDIEDAS_PATTERN = new InflectionPattern(new String[]{"der", "den", "dessen", "dem"}, new String[]{"die", "die", "deren", "der"}, new String[]{"das", "das", "dessen", "dem"}, new String[]{"die", "die", "derer", "denen"}, WordMorph.FULL_FORMS);
    public static final InflectionPattern<Pronoun> DEM_PRON_DERJENIGE_PATTERN = new InflectionPattern(new String[]{"derjenige", "denjenigen", "desjenigen", "demjenigen"}, new String[]{"diejenige", "diejenige", "derjenigen", "derjenigen"}, new String[]{"dasjenige", "dasjenige", "desjenigen", "demjenigen"}, new String[]{"diejenigen", "diejenigen", "derjenigen", "denjenigen"}, WordMorph.FULL_FORMS);
    public static final InflectionPattern<Pronoun> DEM_PRON_DERSELBE_PATTERN = new InflectionPattern(new String[]{"derselbe", "denselben", "desselben", "demselben"}, new String[]{"dieselbe", "dieselbe", "derselben", "derselben"}, new String[]{"dasselbe", "dasselbe", "desselben", "demselben"}, new String[]{"dieselben", "dieselben", "derselben", "denselben"}, WordMorph.FULL_FORMS);
    public static final Pronoun PRO_DEM_DAS = new Pronoun("das", DEM_PRON_DERDIEDAS_PATTERN, DEM_PRON_DERDIEDAS_PATTERN);
    public static final Pronoun PRO_DEM_DIESER = new Pronoun("dies", POSS_NOUN_PATTERN, POSS_NOUN_PATTERN);
    public static final Pronoun PRO_DEM_JENER = new Pronoun("jen", POSS_NOUN_PATTERN, POSS_NOUN_PATTERN);
    public static final Pronoun PRO_DEM_DERJENIGE = new Pronoun("derjenige", DEM_PRON_DERJENIGE_PATTERN, DEM_PRON_DERJENIGE_PATTERN);
    public static final Pronoun PRO_DEM_DERSELBE = new Pronoun("derselbe", DEM_PRON_DERSELBE_PATTERN, DEM_PRON_DERSELBE_PATTERN);
    public static final Pronoun[] DEMONSTRATIVE_PRONOUNS = new Pronoun[]{PRO_DEM_DIESER, PRO_DEM_JENER, PRO_DEM_DAS, PRO_DEM_DERJENIGE, PRO_DEM_DERSELBE};
    public static final InflectionPattern<Pronoun> REL_PRON_PATTERN = new InflectionPattern(new String[]{"der", "den", "dessen", "dem"}, new String[]{"die", "die", "deren", "der"}, new String[]{"das", "das", "dessen", "dem"}, new String[]{"die", "die", "deren", "denen"}, WordMorph.FULL_FORMS);
    public static final Pronoun PRO_REL = new Pronoun("der", REL_PRON_PATTERN, REL_PRON_PATTERN);
    public static final Pronoun PRO_WELCHER = new Pronoun("welch", POSS_NOUN_PATTERN, POSS_NOUN_PATTERN);
    public static final InflectionPattern<Pronoun> INTERROGATIVE_WER_PATTERN = new InflectionPattern(new String[]{"wer", "wen", "wessen", "wem"}, WordMorph.FULL_FORMS);
    public static final InflectionPattern<Pronoun> INTERROGATIVE_WAS_PATTERN = new InflectionPattern(new String[]{"was", "was", "wessen", "was"}, WordMorph.FULL_FORMS);
    public static final Pronoun PRO_INTER_WER = new Pronoun("wer", INTERROGATIVE_WER_PATTERN, INTERROGATIVE_WER_PATTERN);
    public static final Pronoun PRO_INTER_WAS = new Pronoun("was", INTERROGATIVE_WAS_PATTERN, INTERROGATIVE_WAS_PATTERN);
    public static final InflectionPattern<Pronoun> JEMAND_UNINF_PATTERN = new InflectionPattern(new String[]{"", "", "", "es"}, new WordMorph[0]);
    public static final InflectionPattern<Pronoun> JEMAND_PATTERN = new InflectionPattern(new String[]{"", "en", "es", "em"}, new WordMorph[0]);
    public static final InflectionPattern<Pronoun> BEIDE_PATTERN = new InflectionPattern(new String[]{"s", "s", "s", "m"}, new String[]{"", "", "r", "n"}, new WordMorph[0]);
    public static final Pronoun PRO_INDEF_ALLE = new Pronoun("all", POSS_NOUN_PATTERN, POSS_NOUN_PATTERN);
    public static final Pronoun PRO_INDEF_ANDERE = new Pronoun("andere", PRO_STRONG_ADJ_PATTERN, PRO_STRONG_ADJ_PATTERN);
    public static final Pronoun PRO_INDEF_BEIDE = new Pronoun("beide", BEIDE_PATTERN, BEIDE_PATTERN);
    public static final Pronoun PRO_INDEF_EINER = new Pronoun("ein", POSS_NOUN_PATTERN, POSS_NOUN_PATTERN);
    public static final Pronoun PRO_INDEF_ETLICHE = new Pronoun("etliche", PRO_STRONG_ADJ_PATTERN, PRO_STRONG_ADJ_PATTERN);
    public static final Pronoun PRO_INDEF_IRGENDEIN = new Pronoun("irgendein", POSS_ART_PATTERN, POSS_NOUN_PATTERN);
    public static final Pronoun PRO_INDEF_IRGENDWELCHER = new Pronoun("irgendwelch", POSS_NOUN_PATTERN, POSS_NOUN_PATTERN);
    public static final Pronoun PRO_INDEF_JEDER = new Pronoun("jed", POSS_NOUN_PATTERN, POSS_NOUN_PATTERN);
    public static final Pronoun PRO_INDEF_JEGLICHER = new Pronoun("jeglich", POSS_NOUN_PATTERN, POSS_NOUN_PATTERN);
    public static final Pronoun PRO_INDEF_JEDWEDER = new Pronoun("jedwed", POSS_NOUN_PATTERN, POSS_NOUN_PATTERN);
    public static final Pronoun PRO_INDEF_JEMAND = new Pronoun("jemand", JEMAND_UNINF_PATTERN, JEMAND_PATTERN);
    public static final Pronoun PRO_INDEF_IRGENDJEMAND = new Pronoun("irgendjemand", JEMAND_UNINF_PATTERN, JEMAND_PATTERN);
    public static final Pronoun PRO_INDEF_NIEMAND = new Pronoun("niemand", JEMAND_UNINF_PATTERN, JEMAND_PATTERN);
    public static final Pronoun PRO_INDEF_KEIN = new Pronoun("kein", POSS_ART_PATTERN, POSS_NOUN_PATTERN);
    public static final Pronoun PRO_INDEF_MANCHER = new Pronoun("manch", POSS_NOUN_PATTERN, POSS_NOUN_PATTERN);
    public static final Pronoun PRO_INDEF_MEHRERE = new Pronoun("mehrer", POSS_NOUN_PATTERN, POSS_NOUN_PATTERN);
    public static final Pronoun[] ALL_PRONOUNS = new Pronoun[]{PRO_1ST, PRO_2ND, PRO_HON, PRO_3RD, PRO_EXPLETIVE, PRO_POSS_1ST_SG, PRO_POSS_1ST_PL, PRO_POSS_2ND_SG, PRO_POSS_2ND_PL, PRO_POSS_3RD_SG_MASC, PRO_POSS_3RD_SG_NEUT, PRO_POSS_3RD_SG_FEM, PRO_POSS_3RD_PL, PRO_POSS_HON, PRO_DEM_DIESER, PRO_DEM_JENER, PRO_DEM_DAS, PRO_REFLEXIVE_3RD, PRO_REL, PRO_WELCHER, PRO_POSS_ALT_1ST_SG, PRO_POSS_ALT_1ST_PL, PRO_POSS_ALT_2ND_SG, PRO_POSS_ALT_2ND_PL, PRO_POSS_ALT_3RD_SG_MASC, PRO_POSS_ALT_3RD_SG_NEUT, PRO_POSS_ALT_3RD_SG_FEM, PRO_POSS_ALT_3RD_PL, PRO_POSS_ALT_HON, PRO_DEM_DERJENIGE, PRO_DEM_DERSELBE, PRO_INTER_WER, PRO_INTER_WAS, PRO_INDEF_ALLE, PRO_INDEF_ETLICHE, PRO_INDEF_IRGENDEIN, PRO_INDEF_IRGENDWELCHER, PRO_INDEF_JEDER, PRO_INDEF_JEGLICHER, PRO_INDEF_JEDWEDER, PRO_INDEF_JEMAND, PRO_INDEF_NIEMAND, PRO_INDEF_IRGENDJEMAND, PRO_INDEF_KEIN, PRO_INDEF_MANCHER, PRO_INDEF_MEHRERE, PRO_INDEF_EINER, PRO_INDEF_BEIDE, PRO_INDEF_ANDERE};
    public static final Pronoun[] PLURAL_PRONOUNS = new Pronoun[]{PRO_HON, PRO_INDEF_ALLE, PRO_INDEF_ETLICHE, PRO_INDEF_MEHRERE, PRO_INDEF_BEIDE};
    public static final Preposition PASSIVE_VON = new Preposition("von", Case.DATIVE);
    public static final String[] PREPOSITIONS_ACCUSATIVE = new String[]{"\u00e0", "betreffend", "bis", "durch", "entlang", "f\u00fcr", "gegen", "je", "kontra", "ohne", "per", "pro", "um", "versus", "via", "wider"};
    public static final String[] PREPOSITIONS_DATIVE = new String[]{"ab", "aus", "au\u00dfer", "bei", "binnen", "dank", "entgegen", "entsprechend", "fern", "gegen\u00fcber", "gem\u00e4\u00df", "laut", "mit", "mitsamt", "nach", "nahe", "nebst", "samt", "seit", "vis-\u00e0-vis", "von", "zu", "zufolge", "zuliebe", "von ... an"};
    public static final String[] PREPOSITIONS_DAT_ACC = new String[]{"an", "auf", "hinter", "in", "neben", "\u00fcber", "unter", "vor", "zwischen"};
    public static final String[] PREPOSITIONS_GENITIVE = new String[]{"abseits", "abz\u00fcglich", "angesichts", "anhand", "anl\u00e4sslich", "anstatt", "anstelle", "aufgrund", "aufseiten", "ausgangs", "ausschlie\u00dflich", "ausweislich", "au\u00dferhalb", "behufs", "beiderseits", "beidseits", "betreffs", "bez\u00fcglich", "dank", "diesseits", "eingangs", "eingedenk", "einschlie\u00dflich", "exklusive", "fernab", "halber", "hinsichtlich", "infolge", "inklusive", "inmitten", "innerhalb", "innert", "in puncto", "jenseits", "kraft", "l\u00e4ngs", "l\u00e4ngsseits", "laut", "mangels", "mithilfe", "mittels", "namens", "ob", "oberhalb", "punkto", "r\u00fccksichtlich", "seitens", "seitlich", "statt", "trotz", "um ... willen", "unbeschadet", "uneingedenk", "unfern", "ungeachtet", "unterhalb", "unweit", "vermittels", "vonseiten", "vorbehaltlich", "vorbeh\u00e4ltlich", "w\u00e4hrend", "wegen", "weitab", "zugunsten", "zuhanden", "zu H\u00e4nden", "zulasten", "zuseiten", "zuungunsten", "zuz\u00fcglich", "zwecks"};
    public static final Conjunction UND = new Conjunction("und", ConjunctionType.COORDINATING);
    public static final Conjunction ODER = new Conjunction("oder", ConjunctionType.COORDINATING);
    public static final Conjunction ABER = new Conjunction("aber", ConjunctionType.SUBORDINATING);
    public static final Conjunction WEIL = new Conjunction("weil", ConjunctionType.SUBORDINATING);
    public static final Conjunction DASS = new Conjunction("dass", ConjunctionType.SUBORDINATING);
    public static final Conjunction[] ALL_CONJUNCTIONS = new Conjunction[]{UND, ODER, ABER, WEIL, DASS};
    public static final Verb TUN = new Verb("tun", "tat", "getan", "", "t\u00e4t", "tuend", AuxType.HABEN, VERB_INFLECTION_TUN);
    public static final Verb[] ALL_VERBS = new Verb[]{AUX_HABEN, AUX_SEIN, AUX_WERDEN, D\u00dcRFEN, K\u00d6NNEN, M\u00d6GEN, M\u00dcSSEN, SOLLEN, WOLLEN, TUN, WISSEN, BED\u00dcRFEN, VERM\u00d6GEN};

    public static Pronoun getPersonalPronoun(Person p) {
        switch (1.$SwitchMap$simplenlg$features$Person[p.ordinal()]) {
            case 1: {
                return PRO_1ST;
            }
            case 2: {
                return PRO_2ND;
            }
        }
        return PRO_3RD;
    }

    public static Pronoun getHonorificPronoun(boolean possessive) {
        if (possessive) {
            return PRO_POSS_HON;
        }
        return PRO_HON;
    }

    public static Pronoun getPossessivePronoun(Person p, NumberAgr n, Gender g) {
        switch (1.$SwitchMap$simplenlg$features$Person[p.ordinal()]) {
            case 1: {
                return n == NumberAgr.SINGULAR ? PRO_POSS_1ST_SG : PRO_POSS_1ST_PL;
            }
            case 2: {
                return n == NumberAgr.SINGULAR ? PRO_POSS_2ND_SG : PRO_POSS_2ND_PL;
            }
        }
        if (n == NumberAgr.SINGULAR) {
            switch (1.$SwitchMap$simplenlg$features$Gender[g.ordinal()]) {
                case 1: {
                    return PRO_POSS_3RD_SG_MASC;
                }
                case 2: {
                    return PRO_POSS_3RD_SG_FEM;
                }
            }
            return PRO_POSS_3RD_SG_NEUT;
        }
        return PRO_POSS_3RD_PL;
    }

    public static Pronoun getPossessivePronoun(Person p, NumberAgr n) {
        return Constants.getPossessivePronoun(p, n, Gender.NEUTER);
    }

    public static Pronoun getPossessivePronoun(NPPhraseSpec np) {
        return Constants.getPossessivePronoun(Person.THIRD, np.getNumber(), np.getGender());
    }

    public static Pronoun getReflexivePronoun(Person p) {
        if (p == Person.THIRD) {
            return PRO_REFLEXIVE_3RD;
        }
        return Constants.getPersonalPronoun(p);
    }

    public static Pronoun getPronoun(String baseform) {
        if (baseform != null) {
            for (Pronoun p : ALL_PRONOUNS) {
                if (!baseform.equals(p.baseForm)) continue;
                return p;
            }
            for (Pronoun p : ALL_PRONOUNS) {
                if (!p.hasForm(baseform)) continue;
                return p;
            }
        }
        return null;
    }

    public static NumberAgr getPronounNumber(String baseform) {
        if (baseform != null) {
            for (Pronoun p : ALL_PRONOUNS) {
                if (!baseform.equals(p.baseForm)) continue;
                return NumberAgr.SINGULAR;
            }
            for (Pronoun p : ALL_PRONOUNS) {
                if (!baseform.equals(p.getForm(Case.NOMINATIVE, NumberAgr.PLURAL))) continue;
                return NumberAgr.PLURAL;
            }
        }
        return null;
    }

    public static Conjunction getConjunction(String s) {
        if (s.equalsIgnoreCase("und")) {
            return UND;
        }
        if (s.equalsIgnoreCase("oder")) {
            return ODER;
        }
        if (s.equalsIgnoreCase("aber")) {
            return ABER;
        }
        if (s.equalsIgnoreCase("weil")) {
            return WEIL;
        }
        return null;
    }

    public static Determiner getDeterminer(String word) {
        for (String d : ALL_DEFINITE) {
            if (!d.equalsIgnoreCase(word)) continue;
            return DEFINITE_DET;
        }
        for (String d : ALL_INDEFINITE) {
            if (!d.equalsIgnoreCase(word)) continue;
            return INDEFINITE_DET;
        }
        return null;
    }

    public static Determiner getDeterminer(boolean definite) {
        if (definite) {
            return DEFINITE_DET;
        }
        return INDEFINITE_DET;
    }

    public static Gender detGender(String gender) {
        if (gender.equals("die")) {
            return Gender.FEMININE;
        }
        if (gender.equals("der")) {
            return Gender.MASCULINE;
        }
        return Gender.NEUTER;
    }

    public static Preposition getPreposition(String baseform) {
        Case c = Constants.getPrepositionCase(baseform);
        if (c == Case.DAT_ACC) {
            c = Case.ACCUSATIVE;
        } else if (c == null) {
            c = Case.GENITIVE;
        }
        return new Preposition(baseform, c);
    }

    public static Preposition getAdposition(String leftform, String rightform) {
        Case c = Constants.getPrepositionCase(leftform + " ... " + rightform);
        if (c == Case.DAT_ACC) {
            c = Case.ACCUSATIVE;
        } else if (c == null) {
            c = Case.GENITIVE;
        }
        return new Preposition(leftform, rightform, c);
    }

    public static Preposition getPostposition(String baseform) {
        Case c = Constants.getPrepositionCase(baseform);
        if (c == Case.DAT_ACC) {
            c = Case.ACCUSATIVE;
        } else if (c == null) {
            c = Case.GENITIVE;
        }
        return new Preposition("", baseform, c);
    }

    public static Case getPrepositionCase(String baseform) {
        for (String s : PREPOSITIONS_DAT_ACC) {
            if (!s.equalsIgnoreCase(baseform)) continue;
            return Case.DAT_ACC;
        }
        for (String s : PREPOSITIONS_ACCUSATIVE) {
            if (!s.equalsIgnoreCase(baseform)) continue;
            return Case.ACCUSATIVE;
        }
        for (String s : PREPOSITIONS_DATIVE) {
            if (!s.equalsIgnoreCase(baseform)) continue;
            return Case.DATIVE;
        }
        for (String s : PREPOSITIONS_GENITIVE) {
            if (!s.equalsIgnoreCase(baseform)) continue;
            return Case.GENITIVE;
        }
        return null;
    }

    public static Pronoun getInterrogative(InterrogativeType inttype) {
        switch (1.$SwitchMap$simplenlg$features$InterrogativeType[inttype.ordinal()]) {
            case 1: {
                return PRO_INTER_WAS;
            }
            case 2: {
                return PRO_INTER_WER;
            }
        }
        return new Pronoun(inttype.toString().toLowerCase());
    }

    public static Verb getAuxiliary(String baseform) {
        if (baseform.equalsIgnoreCase("werden")) {
            return AUX_WERDEN;
        }
        if (baseform.equalsIgnoreCase("haben")) {
            return AUX_HABEN;
        }
        if (baseform.equalsIgnoreCase("sein")) {
            return AUX_SEIN;
        }
        return null;
    }

    public static Verb getAuxiliary(AuxType type) {
        switch (1.$SwitchMap$simplenlg$features$AuxType[type.ordinal()]) {
            default: {
                return AUX_HABEN;
            }
            case 3: 
        }
        return AUX_SEIN;
    }

    public static Verb getModal(String modal) {
        for (Verb v : ALL_MODALS) {
            if (!v.getBaseForm().equalsIgnoreCase(modal)) continue;
            return v;
        }
        Verb v = new Verb(modal);
        v.setVerbType(VerbType.MODAL);
        return v;
    }

    public static boolean requiresPlural(Pronoun pro) {
        for (Pronoun plural : PLURAL_PRONOUNS) {
            if (!pro.equals(plural)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPossessivePronoun(Pronoun pro) {
        for (Pronoun p : POSSESSIVE_PRONOUNS) {
            if (!p.equals(pro)) continue;
            return true;
        }
        return false;
    }

    public static boolean isConstantVerb(Verb v) {
        for (Verb con : ALL_VERBS) {
            if (!con.equals(v)) continue;
            return true;
        }
        return false;
    }

    public static VerbInflectionPattern getInflectionPatternByName(String name) {
        for (VerbInflectionPattern ptrn : ALL_INFLECTION_PATTERNS) {
            if (!ptrn.getName().equalsIgnoreCase(name)) continue;
            return ptrn;
        }
        return VERB_INFLECTION_DEFAULT;
    }
}

