/*
 * Decompiled with CFR 0.152.
 */
package babel.util.language;

import babel.util.language.Language;

public class LangDetectionResult {
    protected Language m_language;
    protected Double m_confidence;
    protected Boolean m_isReliable;

    public LangDetectionResult(Language language) {
        this(language, null, null);
    }

    public LangDetectionResult(Language language, Double confidence) {
        this(language, confidence, null);
    }

    public LangDetectionResult(Language language, Double confidence, Boolean isReliable) {
        this.m_language = language;
        this.m_confidence = confidence;
        this.m_isReliable = isReliable;
    }

    public Language language() {
        return this.m_language;
    }

    public Double confidence() {
        return this.m_confidence;
    }

    public Boolean isReliable() {
        return this.m_isReliable;
    }

    public String toString() {
        StringBuilder strBld = new StringBuilder();
        strBld.append(this.m_language == null ? "undefined" : this.m_language.toString());
        if (this.m_confidence != null) {
            strBld.append(", confidence = " + this.m_confidence);
        }
        if (this.m_isReliable != null) {
            strBld.append(", reliable = " + this.m_isReliable);
        }
        return strBld.toString();
    }
}

