/*
 * Decompiled with CFR 0.152.
 */
package babel.util.config;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Configurator {
    protected static final Log LOG = LogFactory.getLog(Configurator.class);
    protected static final String ENV_CONFIG_FILE = "CONFIG";
    protected static final String DEFAULT_CONFIG = "babel.xml";
    public static HierarchicalConfiguration CONFIG;

    static {
        String cfgFileName = System.getProperty(ENV_CONFIG_FILE);
        if (cfgFileName == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"No config file specified, assuming babel.xml");
            }
            cfgFileName = DEFAULT_CONFIG;
        }
        try {
            CONFIG = new XMLConfiguration(cfgFileName);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Error reading configuration from file " + cfgFileName + "."));
            }
            CONFIG = null;
        }
    }

    public static String getConfigDescriptor() {
        StringBuilder strBld = new StringBuilder();
        Iterator iter = CONFIG.getKeys();
        strBld.append("----------- Configuration -----------\n");
        while (iter.hasNext()) {
            String key = (String)iter.next();
            List vals = CONFIG.getList(key);
            for (String val : vals) {
                strBld.append(String.valueOf(key) + ": " + val + "\n");
            }
        }
        strBld.append("-------------------------------------");
        return strBld.toString();
    }
}

