/*
 * Decompiled with CFR 0.152.
 */
package babel.ranking.scorers.timedistribution;

import babel.content.eqclasses.EquivalenceClass;
import babel.content.eqclasses.properties.time.TimeDistribution;
import babel.ranking.scorers.Scorer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class TimeDistributionCosineScorer
extends Scorer {
    protected boolean m_slidingWindow;
    protected int m_windowSize;

    public TimeDistributionCosineScorer(int windowSize, boolean slidingWindow) {
        this.m_slidingWindow = slidingWindow;
        this.m_windowSize = windowSize;
    }

    @Override
    public double score(EquivalenceClass oneEq, EquivalenceClass twoEq) {
        TimeDistribution distroOne = (TimeDistribution)oneEq.getProperty(TimeDistribution.class.getName());
        TimeDistribution distroTwo = (TimeDistribution)twoEq.getProperty(TimeDistribution.class.getName());
        if (distroOne == null || distroTwo == null) {
            throw new IllegalArgumentException("At least one of the arguments doesn't have the distribution property.");
        }
        if (!distroOne.isNormalized() || !distroTwo.isNormalized()) {
            throw new IllegalArgumentException("At least one of the arguments' distribution property is not normalized.");
        }
        double result = 0.0;
        HashMap<Integer, Double> oneBins = distroOne.getBins();
        HashMap<Integer, Double> twoBins = distroTwo.getBins();
        HashSet keys = new HashSet(oneBins.keySet());
        keys.retainAll((Collection)twoBins.keySet());
        for (Integer key : keys) {
            result += oneBins.get(key) * twoBins.get(key);
        }
        double denom = Math.sqrt(distroOne.getSumSquares()) * Math.sqrt(distroTwo.getSumSquares());
        result = denom == 0.0 ? 0.0 : result / denom;
        return result;
    }

    @Override
    public boolean smallerScoresAreBetter() {
        return false;
    }

    @Override
    public void prepare(EquivalenceClass eq) {
        TimeDistribution distro = (TimeDistribution)eq.getProperty(TimeDistribution.class.getName());
        if (distro == null) {
            throw new IllegalArgumentException("Class has no time distribution property.");
        }
        distro.reBin(this.m_windowSize, this.m_slidingWindow);
        distro.normalize();
    }
}

