/*
 * Decompiled with CFR 0.152.
 */
package babel.ranking;

import babel.content.eqclasses.EquivalenceClass;
import babel.ranking.EquivClassCandRanking;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MRRAggregator {
    public static final Log LOG = LogFactory.getLog(MRRAggregator.class);

    public Collection<EquivClassCandRanking> aggregate(Collection<Collection<EquivClassCandRanking>> rankings) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Aggregating " + rankings.size() + " rankings."));
        }
        HashMap<EquivalenceClass, HashSet<EquivClassCandRanking>> map = this.prepare(rankings);
        ArrayList<EquivClassCandRanking> agg = new ArrayList<EquivClassCandRanking>(map.size());
        for (EquivalenceClass src : map.keySet()) {
            agg.add(this.aggregateForOneSrc(src, map.get(src)));
        }
        return agg;
    }

    protected HashMap<EquivalenceClass, HashSet<EquivClassCandRanking>> prepare(Collection<Collection<EquivClassCandRanking>> rankings) {
        HashMap<EquivalenceClass, HashSet<EquivClassCandRanking>> map = new HashMap<EquivalenceClass, HashSet<EquivClassCandRanking>>();
        for (Collection<EquivClassCandRanking> ranking : rankings) {
            for (EquivClassCandRanking cands : ranking) {
                HashSet<EquivClassCandRanking> curCands = map.get(cands.m_eq);
                if (curCands == null) {
                    curCands = new HashSet();
                    map.put(cands.m_eq, curCands);
                }
                curCands.add(cands);
            }
        }
        return map;
    }

    protected EquivClassCandRanking aggregateForOneSrc(EquivalenceClass src, HashSet<EquivClassCandRanking> candRankings) {
        EquivClassCandRanking agg = new EquivClassCandRanking(src, -1, false);
        HashSet<EquivalenceClass> allCands = new HashSet<EquivalenceClass>();
        for (EquivClassCandRanking candRanking : candRankings) {
            allCands.addAll(candRanking.getCandidates());
        }
        double mrr = 0.0;
        for (EquivalenceClass cand : allCands) {
            mrr = 0.0;
            for (EquivClassCandRanking ranking : candRankings) {
                double d;
                double rr = ranking.rankOf(cand);
                rr = d < 0.0 ? 0.0 : 1.0 / rr;
                mrr += rr;
            }
            agg.add(cand, mrr /= (double)candRankings.size());
        }
        return agg;
    }
}

