/*
 * Decompiled with CFR 0.152.
 */
package babel.content.eqclasses;

import babel.content.eqclasses.EquivalenceClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class SimpleEquivalenceClass
extends EquivalenceClass {
    protected String m_word = null;
    protected ArrayList<String> m_allWords = new ArrayList();

    @Override
    public void init(String word, boolean caseSensitive) {
        super.init(word, caseSensitive);
        this.m_word = SimpleEquivalenceClass.getWordOfAppropriateForm(word, this.m_caseSensitive);
        this.m_allWords.clear();
    }

    @Override
    public boolean isInEqClass(String word) {
        this.checkInitialized();
        return this.m_word.equals(SimpleEquivalenceClass.getWordOfAppropriateForm(word, this.m_caseSensitive));
    }

    @Override
    public boolean addMorph(String word) {
        this.checkInitialized();
        return this.m_word.equals(SimpleEquivalenceClass.getWordOfAppropriateForm(word, this.m_caseSensitive));
    }

    @Override
    public boolean merge(EquivalenceClass other) {
        return this.sameEqClass(other);
    }

    @Override
    public Collection<String> getAllWords() {
        this.checkInitialized();
        if (this.m_allWords.size() == 0) {
            this.m_allWords.add(this.m_word);
        }
        return Collections.unmodifiableList(this.m_allWords);
    }

    public String getWord() {
        return this.m_word;
    }

    @Override
    public String getStem() {
        return this.m_word;
    }

    public String toString() {
        return this.m_word;
    }

    @Override
    public String persistToString() {
        StringBuilder strBld = new StringBuilder();
        strBld.append(this.m_id);
        strBld.append("\t");
        strBld.append(this.m_initialized);
        strBld.append("\t");
        strBld.append(this.m_caseSensitive);
        strBld.append("\t");
        strBld.append(this.m_word);
        return strBld.toString();
    }

    @Override
    public void unpersistFromString(String str) throws Exception {
        String[] toks = str.split("\t");
        this.m_id = Long.parseLong(toks[0]);
        this.m_initialized = Boolean.parseBoolean(toks[1]);
        this.m_caseSensitive = Boolean.parseBoolean(toks[2]);
        this.m_word = toks[3];
        this.m_allWords.clear();
        this.m_properties.clear();
    }
}

